package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretLocalReferenceBuilder extends SecretLocalReferenceFluentImpl<SecretLocalReferenceBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.SecretLocalReference,io.fabric8.openshift.api.model.SecretLocalReferenceBuilder>{
  public SecretLocalReferenceBuilder() {
    this(false);
  }
  public SecretLocalReferenceBuilder(Boolean validationEnabled) {
    this(new SecretLocalReference(), validationEnabled);
  }
  public SecretLocalReferenceBuilder(SecretLocalReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretLocalReferenceBuilder(io.fabric8.openshift.api.model.SecretLocalReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecretLocalReference(), validationEnabled);
  }
  public SecretLocalReferenceBuilder(io.fabric8.openshift.api.model.SecretLocalReferenceFluent<?> fluent,io.fabric8.openshift.api.model.SecretLocalReference instance) {
    this(fluent, instance, false);
  }
  public SecretLocalReferenceBuilder(io.fabric8.openshift.api.model.SecretLocalReferenceFluent<?> fluent,io.fabric8.openshift.api.model.SecretLocalReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecretLocalReferenceBuilder(io.fabric8.openshift.api.model.SecretLocalReference instance) {
    this(instance,false);
  }
  public SecretLocalReferenceBuilder(io.fabric8.openshift.api.model.SecretLocalReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.SecretLocalReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.SecretLocalReference build() {
    SecretLocalReference buildable = new SecretLocalReference(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}