package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TLSProfileSpecBuilder extends TLSProfileSpecFluentImpl<TLSProfileSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.TLSProfileSpec,TLSProfileSpecBuilder>{
  public TLSProfileSpecBuilder() {
    this(false);
  }
  public TLSProfileSpecBuilder(Boolean validationEnabled) {
    this(new TLSProfileSpec(), validationEnabled);
  }
  public TLSProfileSpecBuilder(io.fabric8.openshift.api.model.TLSProfileSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TLSProfileSpecBuilder(io.fabric8.openshift.api.model.TLSProfileSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new TLSProfileSpec(), validationEnabled);
  }
  public TLSProfileSpecBuilder(io.fabric8.openshift.api.model.TLSProfileSpecFluent<?> fluent,io.fabric8.openshift.api.model.TLSProfileSpec instance) {
    this(fluent, instance, false);
  }
  public TLSProfileSpecBuilder(io.fabric8.openshift.api.model.TLSProfileSpecFluent<?> fluent,io.fabric8.openshift.api.model.TLSProfileSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCiphers(instance.getCiphers()); 
    fluent.withMinTLSVersion(instance.getMinTLSVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TLSProfileSpecBuilder(io.fabric8.openshift.api.model.TLSProfileSpec instance) {
    this(instance,false);
  }
  public TLSProfileSpecBuilder(io.fabric8.openshift.api.model.TLSProfileSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCiphers(instance.getCiphers()); 
    this.withMinTLSVersion(instance.getMinTLSVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.TLSProfileSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.TLSProfileSpec build() {
    TLSProfileSpec buildable = new TLSProfileSpec(fluent.getCiphers(),fluent.getMinTLSVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}