package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TemplateBuilder extends TemplateFluentImpl<TemplateBuilder> implements VisitableBuilder<Template,io.fabric8.openshift.api.model.TemplateBuilder>{
  public TemplateBuilder() {
    this(false);
  }
  public TemplateBuilder(Boolean validationEnabled) {
    this(new Template(), validationEnabled);
  }
  public TemplateBuilder(io.fabric8.openshift.api.model.TemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public TemplateBuilder(io.fabric8.openshift.api.model.TemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Template(), validationEnabled);
  }
  public TemplateBuilder(io.fabric8.openshift.api.model.TemplateFluent<?> fluent,io.fabric8.openshift.api.model.Template instance) {
    this(fluent, instance, false);
  }
  public TemplateBuilder(io.fabric8.openshift.api.model.TemplateFluent<?> fluent,io.fabric8.openshift.api.model.Template instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withLabels(instance.getLabels()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withObjects(instance.getObjects()); 
    fluent.withParameters(instance.getParameters()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TemplateBuilder(io.fabric8.openshift.api.model.Template instance) {
    this(instance,false);
  }
  public TemplateBuilder(io.fabric8.openshift.api.model.Template instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withLabels(instance.getLabels()); 
    this.withMessage(instance.getMessage()); 
    this.withMetadata(instance.getMetadata()); 
    this.withObjects(instance.getObjects()); 
    this.withParameters(instance.getParameters()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.TemplateFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.Template build() {
    Template buildable = new Template(fluent.getApiVersion(),fluent.getKind(),fluent.getLabels(),fluent.getMessage(),fluent.getMetadata(),fluent.getObjects(),fluent.getParameters());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}