package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TemplateInstanceSpecFluentImpl<A extends TemplateInstanceSpecFluent<A>> extends BaseFluent<A> implements TemplateInstanceSpecFluent<A>{
  public TemplateInstanceSpecFluentImpl() {
  }
  public TemplateInstanceSpecFluentImpl(TemplateInstanceSpec instance) {
    this.withRequester(instance.getRequester()); 
    this.withSecret(instance.getSecret()); 
    this.withTemplate(instance.getTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private TemplateInstanceRequesterBuilder requester;
  private LocalObjectReferenceBuilder secret;
  private TemplateBuilder template;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildRequester instead.
   * @return The buildable object.
   */
  @Deprecated
  public TemplateInstanceRequester getRequester() {
    return this.requester!=null ?this.requester.build():null;
  }
  public io.fabric8.openshift.api.model.TemplateInstanceRequester buildRequester() {
    return this.requester!=null ?this.requester.build():null;
  }
  public A withRequester(io.fabric8.openshift.api.model.TemplateInstanceRequester requester) {
    _visitables.get("requester").remove(this.requester);
    if (requester!=null){ this.requester= new io.fabric8.openshift.api.model.TemplateInstanceRequesterBuilder(requester); _visitables.get("requester").add(this.requester);} return (A) this;
  }
  public Boolean hasRequester() {
    return this.requester != null;
  }
  public TemplateInstanceSpecFluent.RequesterNested<A> withNewRequester() {
    return new TemplateInstanceSpecFluentImpl.RequesterNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateInstanceSpecFluent.RequesterNested<A> withNewRequesterLike(io.fabric8.openshift.api.model.TemplateInstanceRequester item) {
    return new TemplateInstanceSpecFluentImpl.RequesterNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.TemplateInstanceSpecFluent.RequesterNested<A> editRequester() {
    return withNewRequesterLike(getRequester());
  }
  public io.fabric8.openshift.api.model.TemplateInstanceSpecFluent.RequesterNested<A> editOrNewRequester() {
    return withNewRequesterLike(getRequester() != null ? getRequester(): new io.fabric8.openshift.api.model.TemplateInstanceRequesterBuilder().build());
  }
  public io.fabric8.openshift.api.model.TemplateInstanceSpecFluent.RequesterNested<A> editOrNewRequesterLike(io.fabric8.openshift.api.model.TemplateInstanceRequester item) {
    return withNewRequesterLike(getRequester() != null ? getRequester(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSecret instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public LocalObjectReference getSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public A withSecret(io.fabric8.kubernetes.api.model.LocalObjectReference secret) {
    _visitables.get("secret").remove(this.secret);
    if (secret!=null){ this.secret= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(secret); _visitables.get("secret").add(this.secret);} return (A) this;
  }
  public java.lang.Boolean hasSecret() {
    return this.secret != null;
  }
  public A withNewSecret(java.lang.String name) {
    return (A)withSecret(new LocalObjectReference(name));
  }
  public TemplateInstanceSpecFluent.SecretNested<A> withNewSecret() {
    return new TemplateInstanceSpecFluentImpl.SecretNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateInstanceSpecFluent.SecretNested<A> withNewSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return new io.fabric8.openshift.api.model.TemplateInstanceSpecFluentImpl.SecretNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.TemplateInstanceSpecFluent.SecretNested<A> editSecret() {
    return withNewSecretLike(getSecret());
  }
  public io.fabric8.openshift.api.model.TemplateInstanceSpecFluent.SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(getSecret() != null ? getSecret(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.TemplateInstanceSpecFluent.SecretNested<A> editOrNewSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return withNewSecretLike(getSecret() != null ? getSecret(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.Template getTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public io.fabric8.openshift.api.model.Template buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(io.fabric8.openshift.api.model.Template template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new io.fabric8.openshift.api.model.TemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
  }
  public java.lang.Boolean hasTemplate() {
    return this.template != null;
  }
  public TemplateInstanceSpecFluent.TemplateNested<A> withNewTemplate() {
    return new TemplateInstanceSpecFluentImpl.TemplateNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateInstanceSpecFluent.TemplateNested<A> withNewTemplateLike(io.fabric8.openshift.api.model.Template item) {
    return new io.fabric8.openshift.api.model.TemplateInstanceSpecFluentImpl.TemplateNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.TemplateInstanceSpecFluent.TemplateNested<A> editTemplate() {
    return withNewTemplateLike(getTemplate());
  }
  public io.fabric8.openshift.api.model.TemplateInstanceSpecFluent.TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.fabric8.openshift.api.model.TemplateBuilder().build());
  }
  public io.fabric8.openshift.api.model.TemplateInstanceSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.fabric8.openshift.api.model.Template item) {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TemplateInstanceSpecFluentImpl that = (TemplateInstanceSpecFluentImpl) o;
    if (requester != null ? !requester.equals(that.requester) :that.requester != null) return false;
    if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
    if (template != null ? !template.equals(that.template) :that.template != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(requester,  secret,  template,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (requester != null) { sb.append("requester:"); sb.append(requester + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class RequesterNestedImpl<N> extends TemplateInstanceRequesterFluentImpl<TemplateInstanceSpecFluent.RequesterNested<N>> implements io.fabric8.openshift.api.model.TemplateInstanceSpecFluent.RequesterNested<N>,Nested<N>{
    RequesterNestedImpl(io.fabric8.openshift.api.model.TemplateInstanceRequester item) {
      this.builder = new TemplateInstanceRequesterBuilder(this, item);
    }
    RequesterNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.TemplateInstanceRequesterBuilder(this);
    }
    io.fabric8.openshift.api.model.TemplateInstanceRequesterBuilder builder;
    public N and() {
      return (N) TemplateInstanceSpecFluentImpl.this.withRequester(builder.build());
    }
    public N endRequester() {
      return and();
    }
    
  }
  class SecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<TemplateInstanceSpecFluent.SecretNested<N>> implements io.fabric8.openshift.api.model.TemplateInstanceSpecFluent.SecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SecretNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this, item);
    }
    SecretNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) TemplateInstanceSpecFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret() {
      return and();
    }
    
  }
  class TemplateNestedImpl<N> extends TemplateFluentImpl<TemplateInstanceSpecFluent.TemplateNested<N>> implements io.fabric8.openshift.api.model.TemplateInstanceSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TemplateNestedImpl(io.fabric8.openshift.api.model.Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.TemplateBuilder(this);
    }
    io.fabric8.openshift.api.model.TemplateBuilder builder;
    public N and() {
      return (N) TemplateInstanceSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}