package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TemplateListBuilder extends TemplateListFluentImpl<TemplateListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.TemplateList,io.fabric8.openshift.api.model.TemplateListBuilder>{
  public TemplateListBuilder() {
    this(false);
  }
  public TemplateListBuilder(Boolean validationEnabled) {
    this(new TemplateList(), validationEnabled);
  }
  public TemplateListBuilder(TemplateListFluent<?> fluent) {
    this(fluent, false);
  }
  public TemplateListBuilder(io.fabric8.openshift.api.model.TemplateListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new TemplateList(), validationEnabled);
  }
  public TemplateListBuilder(io.fabric8.openshift.api.model.TemplateListFluent<?> fluent,io.fabric8.openshift.api.model.TemplateList instance) {
    this(fluent, instance, false);
  }
  public TemplateListBuilder(io.fabric8.openshift.api.model.TemplateListFluent<?> fluent,io.fabric8.openshift.api.model.TemplateList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TemplateListBuilder(io.fabric8.openshift.api.model.TemplateList instance) {
    this(instance,false);
  }
  public TemplateListBuilder(io.fabric8.openshift.api.model.TemplateList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.TemplateListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.TemplateList build() {
    TemplateList buildable = new TemplateList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}