package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TokenConfigBuilder extends TokenConfigFluentImpl<TokenConfigBuilder> implements VisitableBuilder<TokenConfig,io.fabric8.openshift.api.model.TokenConfigBuilder>{
  public TokenConfigBuilder() {
    this(false);
  }
  public TokenConfigBuilder(Boolean validationEnabled) {
    this(new TokenConfig(), validationEnabled);
  }
  public TokenConfigBuilder(io.fabric8.openshift.api.model.TokenConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public TokenConfigBuilder(io.fabric8.openshift.api.model.TokenConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new TokenConfig(), validationEnabled);
  }
  public TokenConfigBuilder(io.fabric8.openshift.api.model.TokenConfigFluent<?> fluent,io.fabric8.openshift.api.model.TokenConfig instance) {
    this(fluent, instance, false);
  }
  public TokenConfigBuilder(io.fabric8.openshift.api.model.TokenConfigFluent<?> fluent,io.fabric8.openshift.api.model.TokenConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAccessTokenInactivityTimeout(instance.getAccessTokenInactivityTimeout()); 
    fluent.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds()); 
    fluent.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TokenConfigBuilder(io.fabric8.openshift.api.model.TokenConfig instance) {
    this(instance,false);
  }
  public TokenConfigBuilder(io.fabric8.openshift.api.model.TokenConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAccessTokenInactivityTimeout(instance.getAccessTokenInactivityTimeout()); 
    this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds()); 
    this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.TokenConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.TokenConfig build() {
    TokenConfig buildable = new TokenConfig(fluent.getAccessTokenInactivityTimeout(),fluent.getAccessTokenInactivityTimeoutSeconds(),fluent.getAccessTokenMaxAgeSeconds());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}