package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UserIdentityMappingBuilder extends UserIdentityMappingFluentImpl<UserIdentityMappingBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.UserIdentityMapping,io.fabric8.openshift.api.model.UserIdentityMappingBuilder>{
  public UserIdentityMappingBuilder() {
    this(false);
  }
  public UserIdentityMappingBuilder(Boolean validationEnabled) {
    this(new UserIdentityMapping(), validationEnabled);
  }
  public UserIdentityMappingBuilder(UserIdentityMappingFluent<?> fluent) {
    this(fluent, false);
  }
  public UserIdentityMappingBuilder(io.fabric8.openshift.api.model.UserIdentityMappingFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new UserIdentityMapping(), validationEnabled);
  }
  public UserIdentityMappingBuilder(io.fabric8.openshift.api.model.UserIdentityMappingFluent<?> fluent,io.fabric8.openshift.api.model.UserIdentityMapping instance) {
    this(fluent, instance, false);
  }
  public UserIdentityMappingBuilder(io.fabric8.openshift.api.model.UserIdentityMappingFluent<?> fluent,io.fabric8.openshift.api.model.UserIdentityMapping instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withIdentity(instance.getIdentity()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withUser(instance.getUser()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public UserIdentityMappingBuilder(io.fabric8.openshift.api.model.UserIdentityMapping instance) {
    this(instance,false);
  }
  public UserIdentityMappingBuilder(io.fabric8.openshift.api.model.UserIdentityMapping instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withIdentity(instance.getIdentity()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withUser(instance.getUser()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.UserIdentityMappingFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.UserIdentityMapping build() {
    UserIdentityMapping buildable = new UserIdentityMapping(fluent.getApiVersion(),fluent.getIdentity(),fluent.getKind(),fluent.getMetadata(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}