package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UserRestrictionBuilder extends UserRestrictionFluentImpl<UserRestrictionBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.UserRestriction,UserRestrictionBuilder>{
  public UserRestrictionBuilder() {
    this(false);
  }
  public UserRestrictionBuilder(Boolean validationEnabled) {
    this(new UserRestriction(), validationEnabled);
  }
  public UserRestrictionBuilder(io.fabric8.openshift.api.model.UserRestrictionFluent<?> fluent) {
    this(fluent, false);
  }
  public UserRestrictionBuilder(io.fabric8.openshift.api.model.UserRestrictionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new UserRestriction(), validationEnabled);
  }
  public UserRestrictionBuilder(io.fabric8.openshift.api.model.UserRestrictionFluent<?> fluent,io.fabric8.openshift.api.model.UserRestriction instance) {
    this(fluent, instance, false);
  }
  public UserRestrictionBuilder(io.fabric8.openshift.api.model.UserRestrictionFluent<?> fluent,io.fabric8.openshift.api.model.UserRestriction instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroups(instance.getGroups()); 
    fluent.withLabels(instance.getLabels()); 
    fluent.withUsers(instance.getUsers()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public UserRestrictionBuilder(io.fabric8.openshift.api.model.UserRestriction instance) {
    this(instance,false);
  }
  public UserRestrictionBuilder(io.fabric8.openshift.api.model.UserRestriction instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroups(instance.getGroups()); 
    this.withLabels(instance.getLabels()); 
    this.withUsers(instance.getUsers()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.UserRestrictionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.UserRestriction build() {
    UserRestriction buildable = new UserRestriction(fluent.getGroups(),fluent.getLabels(),fluent.getUsers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}