package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VSpherePlatformStatusBuilder extends VSpherePlatformStatusFluentImpl<VSpherePlatformStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.VSpherePlatformStatus,io.fabric8.openshift.api.model.VSpherePlatformStatusBuilder>{
  public VSpherePlatformStatusBuilder() {
    this(false);
  }
  public VSpherePlatformStatusBuilder(Boolean validationEnabled) {
    this(new VSpherePlatformStatus(), validationEnabled);
  }
  public VSpherePlatformStatusBuilder(VSpherePlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public VSpherePlatformStatusBuilder(io.fabric8.openshift.api.model.VSpherePlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new VSpherePlatformStatus(), validationEnabled);
  }
  public VSpherePlatformStatusBuilder(io.fabric8.openshift.api.model.VSpherePlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.VSpherePlatformStatus instance) {
    this(fluent, instance, false);
  }
  public VSpherePlatformStatusBuilder(io.fabric8.openshift.api.model.VSpherePlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.VSpherePlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiServerInternalIP(instance.getApiServerInternalIP()); 
    fluent.withIngressIP(instance.getIngressIP()); 
    fluent.withNodeDNSIP(instance.getNodeDNSIP()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public VSpherePlatformStatusBuilder(io.fabric8.openshift.api.model.VSpherePlatformStatus instance) {
    this(instance,false);
  }
  public VSpherePlatformStatusBuilder(io.fabric8.openshift.api.model.VSpherePlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
    this.withIngressIP(instance.getIngressIP()); 
    this.withNodeDNSIP(instance.getNodeDNSIP()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.VSpherePlatformStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.VSpherePlatformStatus build() {
    VSpherePlatformStatus buildable = new VSpherePlatformStatus(fluent.getApiServerInternalIP(),fluent.getIngressIP(),fluent.getNodeDNSIP());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}