package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WebHookTriggerBuilder extends WebHookTriggerFluentImpl<WebHookTriggerBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.WebHookTrigger,io.fabric8.openshift.api.model.WebHookTriggerBuilder>{
  public WebHookTriggerBuilder() {
    this(false);
  }
  public WebHookTriggerBuilder(Boolean validationEnabled) {
    this(new WebHookTrigger(), validationEnabled);
  }
  public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent) {
    this(fluent, false);
  }
  public WebHookTriggerBuilder(io.fabric8.openshift.api.model.WebHookTriggerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new WebHookTrigger(), validationEnabled);
  }
  public WebHookTriggerBuilder(io.fabric8.openshift.api.model.WebHookTriggerFluent<?> fluent,io.fabric8.openshift.api.model.WebHookTrigger instance) {
    this(fluent, instance, false);
  }
  public WebHookTriggerBuilder(io.fabric8.openshift.api.model.WebHookTriggerFluent<?> fluent,io.fabric8.openshift.api.model.WebHookTrigger instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllowEnv(instance.getAllowEnv()); 
    fluent.withSecret(instance.getSecret()); 
    fluent.withSecretReference(instance.getSecretReference()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public WebHookTriggerBuilder(io.fabric8.openshift.api.model.WebHookTrigger instance) {
    this(instance,false);
  }
  public WebHookTriggerBuilder(io.fabric8.openshift.api.model.WebHookTrigger instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllowEnv(instance.getAllowEnv()); 
    this.withSecret(instance.getSecret()); 
    this.withSecretReference(instance.getSecretReference()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.WebHookTriggerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.WebHookTrigger build() {
    WebHookTrigger buildable = new WebHookTrigger(fluent.getAllowEnv(),fluent.getSecret(),fluent.getSecretReference());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}