package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.openshift.api.model.runtime.RawExtensionFluent;
import java.lang.Integer;
import io.fabric8.openshift.api.model.runtime.RawExtension;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface ImageFluent<A extends ImageFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getDockerImageConfig();
  public A withDockerImageConfig(String dockerImageConfig);
  public Boolean hasDockerImageConfig();
  public A addToDockerImageLayers(Integer index,ImageLayer item);
  public A setToDockerImageLayers(Integer index,ImageLayer item);
  public A addToDockerImageLayers(io.fabric8.openshift.api.model.ImageLayer... items);
  public A addAllToDockerImageLayers(Collection<ImageLayer> items);
  public A removeFromDockerImageLayers(io.fabric8.openshift.api.model.ImageLayer... items);
  public A removeAllFromDockerImageLayers(Collection<ImageLayer> items);
  public A removeMatchingFromDockerImageLayers(Predicate<ImageLayerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildDockerImageLayers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ImageLayer> getDockerImageLayers();
  public List<ImageLayer> buildDockerImageLayers();
  public ImageLayer buildDockerImageLayer(Integer index);
  public ImageLayer buildFirstDockerImageLayer();
  public ImageLayer buildLastDockerImageLayer();
  public ImageLayer buildMatchingDockerImageLayer(Predicate<ImageLayerBuilder> predicate);
  public Boolean hasMatchingDockerImageLayer(Predicate<ImageLayerBuilder> predicate);
  public A withDockerImageLayers(List<ImageLayer> dockerImageLayers);
  public A withDockerImageLayers(io.fabric8.openshift.api.model.ImageLayer... dockerImageLayers);
  public Boolean hasDockerImageLayers();
  public A addNewDockerImageLayer(String mediaType,String name,Long size);
  public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayer();
  public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayerLike(ImageLayer item);
  public ImageFluent.DockerImageLayersNested<A> setNewDockerImageLayerLike(Integer index,ImageLayer item);
  public ImageFluent.DockerImageLayersNested<A> editDockerImageLayer(Integer index);
  public ImageFluent.DockerImageLayersNested<A> editFirstDockerImageLayer();
  public ImageFluent.DockerImageLayersNested<A> editLastDockerImageLayer();
  public ImageFluent.DockerImageLayersNested<A> editMatchingDockerImageLayer(Predicate<ImageLayerBuilder> predicate);
  public String getDockerImageManifest();
  public A withDockerImageManifest(String dockerImageManifest);
  public Boolean hasDockerImageManifest();
  public String getDockerImageManifestMediaType();
  public A withDockerImageManifestMediaType(String dockerImageManifestMediaType);
  public Boolean hasDockerImageManifestMediaType();
  
  /**
   * This method has been deprecated, please use method buildDockerImageMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public RawExtension getDockerImageMetadata();
  public RawExtension buildDockerImageMetadata();
  public A withDockerImageMetadata(RawExtension dockerImageMetadata);
  public Boolean hasDockerImageMetadata();
  public ImageFluent.DockerImageMetadataNested<A> withNewDockerImageMetadata();
  public ImageFluent.DockerImageMetadataNested<A> withNewDockerImageMetadataLike(RawExtension item);
  public ImageFluent.DockerImageMetadataNested<A> editDockerImageMetadata();
  public ImageFluent.DockerImageMetadataNested<A> editOrNewDockerImageMetadata();
  public ImageFluent.DockerImageMetadataNested<A> editOrNewDockerImageMetadataLike(RawExtension item);
  public String getDockerImageMetadataVersion();
  public A withDockerImageMetadataVersion(String dockerImageMetadataVersion);
  public Boolean hasDockerImageMetadataVersion();
  public String getDockerImageReference();
  public A withDockerImageReference(String dockerImageReference);
  public Boolean hasDockerImageReference();
  public A addToDockerImageSignatures(Integer index,String item);
  public A setToDockerImageSignatures(Integer index,String item);
  public A addToDockerImageSignatures(java.lang.String... items);
  public A addAllToDockerImageSignatures(Collection<String> items);
  public A removeFromDockerImageSignatures(java.lang.String... items);
  public A removeAllFromDockerImageSignatures(Collection<String> items);
  public List<String> getDockerImageSignatures();
  public String getDockerImageSignature(Integer index);
  public String getFirstDockerImageSignature();
  public String getLastDockerImageSignature();
  public String getMatchingDockerImageSignature(Predicate<String> predicate);
  public Boolean hasMatchingDockerImageSignature(Predicate<String> predicate);
  public A withDockerImageSignatures(List<String> dockerImageSignatures);
  public A withDockerImageSignatures(java.lang.String... dockerImageSignatures);
  public Boolean hasDockerImageSignatures();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ImageFluent.MetadataNested<A> withNewMetadata();
  public ImageFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ImageFluent.MetadataNested<A> editMetadata();
  public ImageFluent.MetadataNested<A> editOrNewMetadata();
  public ImageFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public A addToSignatures(Integer index,ImageSignature item);
  public A setToSignatures(Integer index,ImageSignature item);
  public A addToSignatures(io.fabric8.openshift.api.model.ImageSignature... items);
  public A addAllToSignatures(Collection<ImageSignature> items);
  public A removeFromSignatures(io.fabric8.openshift.api.model.ImageSignature... items);
  public A removeAllFromSignatures(Collection<ImageSignature> items);
  public A removeMatchingFromSignatures(Predicate<ImageSignatureBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSignatures instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ImageSignature> getSignatures();
  public List<ImageSignature> buildSignatures();
  public ImageSignature buildSignature(Integer index);
  public ImageSignature buildFirstSignature();
  public ImageSignature buildLastSignature();
  public ImageSignature buildMatchingSignature(Predicate<ImageSignatureBuilder> predicate);
  public Boolean hasMatchingSignature(Predicate<ImageSignatureBuilder> predicate);
  public A withSignatures(List<ImageSignature> signatures);
  public A withSignatures(io.fabric8.openshift.api.model.ImageSignature... signatures);
  public Boolean hasSignatures();
  public ImageFluent.SignaturesNested<A> addNewSignature();
  public ImageFluent.SignaturesNested<A> addNewSignatureLike(ImageSignature item);
  public ImageFluent.SignaturesNested<A> setNewSignatureLike(Integer index,ImageSignature item);
  public ImageFluent.SignaturesNested<A> editSignature(Integer index);
  public ImageFluent.SignaturesNested<A> editFirstSignature();
  public ImageFluent.SignaturesNested<A> editLastSignature();
  public ImageFluent.SignaturesNested<A> editMatchingSignature(Predicate<ImageSignatureBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface DockerImageLayersNested<N> extends Nested<N>,ImageLayerFluent<ImageFluent.DockerImageLayersNested<N>>{
    public N and();
    public N endDockerImageLayer();
    
  }
  public interface DockerImageMetadataNested<N> extends Nested<N>,RawExtensionFluent<ImageFluent.DockerImageMetadataNested<N>>{
    public N and();
    public N endDockerImageMetadata();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ImageFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SignaturesNested<N> extends Nested<N>,ImageSignatureFluent<ImageFluent.SignaturesNested<N>>{
    public N and();
    public N endSignature();
    
  }
  
}