package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
public interface ResourceAccessReviewFluent<A extends ResourceAccessReviewFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  
  /**
   * This method has been deprecated, please use method buildContent instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getContent();
  public HasMetadata buildContent();
  public A withContent(HasMetadata content);
  public Boolean hasContent();
  public A withImageStreamImportContent(ImageStreamImport imageStreamImportContent);
  public ResourceAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContent();
  public ResourceAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContentLike(ImageStreamImport item);
  public A withProjectContent(Project projectContent);
  public ResourceAccessReviewFluent.ProjectContentNested<A> withNewProjectContent();
  public ResourceAccessReviewFluent.ProjectContentNested<A> withNewProjectContentLike(Project item);
  public A withBuildConfigContent(BuildConfig buildConfigContent);
  public ResourceAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContent();
  public ResourceAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContentLike(BuildConfig item);
  public A withHelmChartRepositoryContent(HelmChartRepository helmChartRepositoryContent);
  public ResourceAccessReviewFluent.HelmChartRepositoryContentNested<A> withNewHelmChartRepositoryContent();
  public ResourceAccessReviewFluent.HelmChartRepositoryContentNested<A> withNewHelmChartRepositoryContentLike(HelmChartRepository item);
  public A withRangeAllocationContent(RangeAllocation rangeAllocationContent);
  public ResourceAccessReviewFluent.RangeAllocationContentNested<A> withNewRangeAllocationContent();
  public ResourceAccessReviewFluent.RangeAllocationContentNested<A> withNewRangeAllocationContentLike(RangeAllocation item);
  public A withRouteContent(Route routeContent);
  public ResourceAccessReviewFluent.RouteContentNested<A> withNewRouteContent();
  public ResourceAccessReviewFluent.RouteContentNested<A> withNewRouteContentLike(Route item);
  public A withClusterNetworkContent(ClusterNetwork clusterNetworkContent);
  public ResourceAccessReviewFluent.ClusterNetworkContentNested<A> withNewClusterNetworkContent();
  public ResourceAccessReviewFluent.ClusterNetworkContentNested<A> withNewClusterNetworkContentLike(ClusterNetwork item);
  public A withOAuthAuthorizeTokenContent(OAuthAuthorizeToken oAuthAuthorizeTokenContent);
  public ResourceAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContent();
  public ResourceAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContentLike(OAuthAuthorizeToken item);
  public A withUserOAuthAccessTokenContent(UserOAuthAccessToken userOAuthAccessTokenContent);
  public ResourceAccessReviewFluent.UserOAuthAccessTokenContentNested<A> withNewUserOAuthAccessTokenContent();
  public ResourceAccessReviewFluent.UserOAuthAccessTokenContentNested<A> withNewUserOAuthAccessTokenContentLike(UserOAuthAccessToken item);
  public A withClusterRoleBindingContent(ClusterRoleBinding clusterRoleBindingContent);
  public ResourceAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContent();
  public ResourceAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContentLike(ClusterRoleBinding item);
  public A withClusterResourceQuotaContent(ClusterResourceQuota clusterResourceQuotaContent);
  public ResourceAccessReviewFluent.ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContent();
  public ResourceAccessReviewFluent.ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContentLike(ClusterResourceQuota item);
  public A withProjectRequestContent(ProjectRequest projectRequestContent);
  public ResourceAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContent();
  public ResourceAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContentLike(ProjectRequest item);
  public A withTemplateContent(Template templateContent);
  public ResourceAccessReviewFluent.TemplateContentNested<A> withNewTemplateContent();
  public ResourceAccessReviewFluent.TemplateContentNested<A> withNewTemplateContentLike(Template item);
  public A withOAuthClientAuthorizationContent(OAuthClientAuthorization oAuthClientAuthorizationContent);
  public ResourceAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContent();
  public ResourceAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContentLike(OAuthClientAuthorization item);
  public A withClusterRoleContent(ClusterRole clusterRoleContent);
  public ResourceAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContent();
  public ResourceAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContentLike(ClusterRole item);
  public A withImageTagContent(ImageTag imageTagContent);
  public ResourceAccessReviewFluent.ImageTagContentNested<A> withNewImageTagContent();
  public ResourceAccessReviewFluent.ImageTagContentNested<A> withNewImageTagContentLike(ImageTag item);
  public A withOAuthAccessTokenContent(OAuthAccessToken oAuthAccessTokenContent);
  public ResourceAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContent();
  public ResourceAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContentLike(OAuthAccessToken item);
  public A withDeploymentConfigContent(DeploymentConfig deploymentConfigContent);
  public ResourceAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContent();
  public ResourceAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContentLike(DeploymentConfig item);
  public A withRoleBindingContent(RoleBinding roleBindingContent);
  public ResourceAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContent();
  public ResourceAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContentLike(RoleBinding item);
  public A withImageContent(Image imageContent);
  public ResourceAccessReviewFluent.ImageContentNested<A> withNewImageContent();
  public ResourceAccessReviewFluent.ImageContentNested<A> withNewImageContentLike(Image item);
  public A withPersistentVolumeClaimContent(PersistentVolumeClaim persistentVolumeClaimContent);
  public ResourceAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContent();
  public ResourceAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContentLike(PersistentVolumeClaim item);
  public A withImageStreamMappingContent(ImageStreamMapping imageStreamMappingContent);
  public ResourceAccessReviewFluent.ImageStreamMappingContentNested<A> withNewImageStreamMappingContent();
  public ResourceAccessReviewFluent.ImageStreamMappingContentNested<A> withNewImageStreamMappingContentLike(ImageStreamMapping item);
  public A withRoleContent(Role roleContent);
  public ResourceAccessReviewFluent.RoleContentNested<A> withNewRoleContent();
  public ResourceAccessReviewFluent.RoleContentNested<A> withNewRoleContentLike(Role item);
  public A withBrokerTemplateInstanceContent(BrokerTemplateInstance brokerTemplateInstanceContent);
  public ResourceAccessReviewFluent.BrokerTemplateInstanceContentNested<A> withNewBrokerTemplateInstanceContent();
  public ResourceAccessReviewFluent.BrokerTemplateInstanceContentNested<A> withNewBrokerTemplateInstanceContentLike(BrokerTemplateInstance item);
  public A withUserContent(User userContent);
  public ResourceAccessReviewFluent.UserContentNested<A> withNewUserContent();
  public ResourceAccessReviewFluent.UserContentNested<A> withNewUserContentLike(User item);
  public A withImageStreamImageContent(ImageStreamImage imageStreamImageContent);
  public ResourceAccessReviewFluent.ImageStreamImageContentNested<A> withNewImageStreamImageContent();
  public ResourceAccessReviewFluent.ImageStreamImageContentNested<A> withNewImageStreamImageContentLike(ImageStreamImage item);
  public A withTemplateInstanceContent(TemplateInstance templateInstanceContent);
  public ResourceAccessReviewFluent.TemplateInstanceContentNested<A> withNewTemplateInstanceContent();
  public ResourceAccessReviewFluent.TemplateInstanceContentNested<A> withNewTemplateInstanceContentLike(TemplateInstance item);
  public A withBuildContent(Build buildContent);
  public ResourceAccessReviewFluent.BuildContentNested<A> withNewBuildContent();
  public ResourceAccessReviewFluent.BuildContentNested<A> withNewBuildContentLike(Build item);
  public A withRoleBindingRestrictionContent(RoleBindingRestriction roleBindingRestrictionContent);
  public ResourceAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContent();
  public ResourceAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContentLike(RoleBindingRestriction item);
  public A withImageStreamTagContent(ImageStreamTag imageStreamTagContent);
  public ResourceAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContent();
  public ResourceAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContentLike(ImageStreamTag item);
  public A withGroupContent(Group groupContent);
  public ResourceAccessReviewFluent.GroupContentNested<A> withNewGroupContent();
  public ResourceAccessReviewFluent.GroupContentNested<A> withNewGroupContentLike(Group item);
  public A withImageSignatureContent(ImageSignature imageSignatureContent);
  public ResourceAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContent();
  public ResourceAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContentLike(ImageSignature item);
  public A withHostSubnetContent(HostSubnet hostSubnetContent);
  public ResourceAccessReviewFluent.HostSubnetContentNested<A> withNewHostSubnetContent();
  public ResourceAccessReviewFluent.HostSubnetContentNested<A> withNewHostSubnetContentLike(HostSubnet item);
  public A withAppliedClusterResourceQuotaContent(AppliedClusterResourceQuota appliedClusterResourceQuotaContent);
  public ResourceAccessReviewFluent.AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContent();
  public ResourceAccessReviewFluent.AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContentLike(AppliedClusterResourceQuota item);
  public A withSecurityContextConstraintsContent(SecurityContextConstraints securityContextConstraintsContent);
  public ResourceAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContent();
  public ResourceAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContentLike(SecurityContextConstraints item);
  public A withBuildRequestContent(BuildRequest buildRequestContent);
  public ResourceAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContent();
  public ResourceAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContentLike(BuildRequest item);
  public A withEgressNetworkPolicyContent(EgressNetworkPolicy egressNetworkPolicyContent);
  public ResourceAccessReviewFluent.EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContent();
  public ResourceAccessReviewFluent.EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContentLike(EgressNetworkPolicy item);
  public A withNetNamespaceContent(NetNamespace netNamespaceContent);
  public ResourceAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContent();
  public ResourceAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContentLike(NetNamespace item);
  public A withUserIdentityMappingContent(UserIdentityMapping userIdentityMappingContent);
  public ResourceAccessReviewFluent.UserIdentityMappingContentNested<A> withNewUserIdentityMappingContent();
  public ResourceAccessReviewFluent.UserIdentityMappingContentNested<A> withNewUserIdentityMappingContentLike(UserIdentityMapping item);
  public A withImageStreamContent(ImageStream imageStreamContent);
  public ResourceAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContent();
  public ResourceAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContentLike(ImageStream item);
  public A withOAuthClientContent(OAuthClient oAuthClientContent);
  public ResourceAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContent();
  public ResourceAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContentLike(OAuthClient item);
  public A withIdentityContent(Identity identityContent);
  public ResourceAccessReviewFluent.IdentityContentNested<A> withNewIdentityContent();
  public ResourceAccessReviewFluent.IdentityContentNested<A> withNewIdentityContentLike(Identity item);
  public Boolean getIsNonResourceURL();
  public A withIsNonResourceURL(Boolean isNonResourceURL);
  public Boolean hasIsNonResourceURL();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public String getNamespace();
  public A withNamespace(String namespace);
  public Boolean hasNamespace();
  public String getPath();
  public A withPath(String path);
  public Boolean hasPath();
  public String getResource();
  public A withResource(String resource);
  public Boolean hasResource();
  public String getResourceAPIGroup();
  public A withResourceAPIGroup(String resourceAPIGroup);
  public Boolean hasResourceAPIGroup();
  public String getResourceAPIVersion();
  public A withResourceAPIVersion(String resourceAPIVersion);
  public Boolean hasResourceAPIVersion();
  public String getResourceName();
  public A withResourceName(String resourceName);
  public Boolean hasResourceName();
  public String getVerb();
  public A withVerb(String verb);
  public Boolean hasVerb();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withIsNonResourceURL();
  public interface ImageStreamImportContentNested<N> extends Nested<N>,ImageStreamImportFluent<ResourceAccessReviewFluent.ImageStreamImportContentNested<N>>{
    public N and();
    public N endImageStreamImportContent();
    
  }
  public interface ProjectContentNested<N> extends Nested<N>,ProjectFluent<ResourceAccessReviewFluent.ProjectContentNested<N>>{
    public N and();
    public N endProjectContent();
    
  }
  public interface BuildConfigContentNested<N> extends Nested<N>,BuildConfigFluent<ResourceAccessReviewFluent.BuildConfigContentNested<N>>{
    public N and();
    public N endBuildConfigContent();
    
  }
  public interface HelmChartRepositoryContentNested<N> extends Nested<N>,HelmChartRepositoryFluent<ResourceAccessReviewFluent.HelmChartRepositoryContentNested<N>>{
    public N and();
    public N endHelmChartRepositoryContent();
    
  }
  public interface RangeAllocationContentNested<N> extends Nested<N>,RangeAllocationFluent<ResourceAccessReviewFluent.RangeAllocationContentNested<N>>{
    public N and();
    public N endRangeAllocationContent();
    
  }
  public interface RouteContentNested<N> extends Nested<N>,RouteFluent<ResourceAccessReviewFluent.RouteContentNested<N>>{
    public N and();
    public N endRouteContent();
    
  }
  public interface ClusterNetworkContentNested<N> extends Nested<N>,ClusterNetworkFluent<ResourceAccessReviewFluent.ClusterNetworkContentNested<N>>{
    public N and();
    public N endClusterNetworkContent();
    
  }
  public interface OAuthAuthorizeTokenContentNested<N> extends Nested<N>,OAuthAuthorizeTokenFluent<ResourceAccessReviewFluent.OAuthAuthorizeTokenContentNested<N>>{
    public N and();
    public N endOAuthAuthorizeTokenContent();
    
  }
  public interface UserOAuthAccessTokenContentNested<N> extends Nested<N>,UserOAuthAccessTokenFluent<ResourceAccessReviewFluent.UserOAuthAccessTokenContentNested<N>>{
    public N and();
    public N endUserOAuthAccessTokenContent();
    
  }
  public interface ClusterRoleBindingContentNested<N> extends Nested<N>,ClusterRoleBindingFluent<ResourceAccessReviewFluent.ClusterRoleBindingContentNested<N>>{
    public N and();
    public N endClusterRoleBindingContent();
    
  }
  public interface ClusterResourceQuotaContentNested<N> extends Nested<N>,ClusterResourceQuotaFluent<ResourceAccessReviewFluent.ClusterResourceQuotaContentNested<N>>{
    public N and();
    public N endClusterResourceQuotaContent();
    
  }
  public interface ProjectRequestContentNested<N> extends Nested<N>,ProjectRequestFluent<ResourceAccessReviewFluent.ProjectRequestContentNested<N>>{
    public N and();
    public N endProjectRequestContent();
    
  }
  public interface TemplateContentNested<N> extends Nested<N>,TemplateFluent<ResourceAccessReviewFluent.TemplateContentNested<N>>{
    public N and();
    public N endTemplateContent();
    
  }
  public interface OAuthClientAuthorizationContentNested<N> extends Nested<N>,OAuthClientAuthorizationFluent<ResourceAccessReviewFluent.OAuthClientAuthorizationContentNested<N>>{
    public N and();
    public N endOAuthClientAuthorizationContent();
    
  }
  public interface ClusterRoleContentNested<N> extends Nested<N>,ClusterRoleFluent<ResourceAccessReviewFluent.ClusterRoleContentNested<N>>{
    public N and();
    public N endClusterRoleContent();
    
  }
  public interface ImageTagContentNested<N> extends Nested<N>,ImageTagFluent<ResourceAccessReviewFluent.ImageTagContentNested<N>>{
    public N and();
    public N endImageTagContent();
    
  }
  public interface OAuthAccessTokenContentNested<N> extends Nested<N>,OAuthAccessTokenFluent<ResourceAccessReviewFluent.OAuthAccessTokenContentNested<N>>{
    public N and();
    public N endOAuthAccessTokenContent();
    
  }
  public interface DeploymentConfigContentNested<N> extends Nested<N>,DeploymentConfigFluent<ResourceAccessReviewFluent.DeploymentConfigContentNested<N>>{
    public N and();
    public N endDeploymentConfigContent();
    
  }
  public interface RoleBindingContentNested<N> extends Nested<N>,RoleBindingFluent<ResourceAccessReviewFluent.RoleBindingContentNested<N>>{
    public N and();
    public N endRoleBindingContent();
    
  }
  public interface ImageContentNested<N> extends Nested<N>,ImageFluent<ResourceAccessReviewFluent.ImageContentNested<N>>{
    public N and();
    public N endImageContent();
    
  }
  public interface PersistentVolumeClaimContentNested<N> extends Nested<N>,PersistentVolumeClaimFluent<ResourceAccessReviewFluent.PersistentVolumeClaimContentNested<N>>{
    public N and();
    public N endPersistentVolumeClaimContent();
    
  }
  public interface ImageStreamMappingContentNested<N> extends Nested<N>,ImageStreamMappingFluent<ResourceAccessReviewFluent.ImageStreamMappingContentNested<N>>{
    public N and();
    public N endImageStreamMappingContent();
    
  }
  public interface RoleContentNested<N> extends Nested<N>,RoleFluent<ResourceAccessReviewFluent.RoleContentNested<N>>{
    public N and();
    public N endRoleContent();
    
  }
  public interface BrokerTemplateInstanceContentNested<N> extends Nested<N>,BrokerTemplateInstanceFluent<ResourceAccessReviewFluent.BrokerTemplateInstanceContentNested<N>>{
    public N and();
    public N endBrokerTemplateInstanceContent();
    
  }
  public interface UserContentNested<N> extends Nested<N>,UserFluent<ResourceAccessReviewFluent.UserContentNested<N>>{
    public N and();
    public N endUserContent();
    
  }
  public interface ImageStreamImageContentNested<N> extends Nested<N>,ImageStreamImageFluent<ResourceAccessReviewFluent.ImageStreamImageContentNested<N>>{
    public N and();
    public N endImageStreamImageContent();
    
  }
  public interface TemplateInstanceContentNested<N> extends Nested<N>,TemplateInstanceFluent<ResourceAccessReviewFluent.TemplateInstanceContentNested<N>>{
    public N and();
    public N endTemplateInstanceContent();
    
  }
  public interface BuildContentNested<N> extends Nested<N>,BuildFluent<ResourceAccessReviewFluent.BuildContentNested<N>>{
    public N and();
    public N endBuildContent();
    
  }
  public interface RoleBindingRestrictionContentNested<N> extends Nested<N>,RoleBindingRestrictionFluent<ResourceAccessReviewFluent.RoleBindingRestrictionContentNested<N>>{
    public N and();
    public N endRoleBindingRestrictionContent();
    
  }
  public interface ImageStreamTagContentNested<N> extends Nested<N>,ImageStreamTagFluent<ResourceAccessReviewFluent.ImageStreamTagContentNested<N>>{
    public N and();
    public N endImageStreamTagContent();
    
  }
  public interface GroupContentNested<N> extends Nested<N>,GroupFluent<ResourceAccessReviewFluent.GroupContentNested<N>>{
    public N and();
    public N endGroupContent();
    
  }
  public interface ImageSignatureContentNested<N> extends Nested<N>,ImageSignatureFluent<ResourceAccessReviewFluent.ImageSignatureContentNested<N>>{
    public N and();
    public N endImageSignatureContent();
    
  }
  public interface HostSubnetContentNested<N> extends Nested<N>,HostSubnetFluent<ResourceAccessReviewFluent.HostSubnetContentNested<N>>{
    public N and();
    public N endHostSubnetContent();
    
  }
  public interface AppliedClusterResourceQuotaContentNested<N> extends Nested<N>,AppliedClusterResourceQuotaFluent<ResourceAccessReviewFluent.AppliedClusterResourceQuotaContentNested<N>>{
    public N and();
    public N endAppliedClusterResourceQuotaContent();
    
  }
  public interface SecurityContextConstraintsContentNested<N> extends Nested<N>,SecurityContextConstraintsFluent<ResourceAccessReviewFluent.SecurityContextConstraintsContentNested<N>>{
    public N and();
    public N endSecurityContextConstraintsContent();
    
  }
  public interface BuildRequestContentNested<N> extends Nested<N>,BuildRequestFluent<ResourceAccessReviewFluent.BuildRequestContentNested<N>>{
    public N and();
    public N endBuildRequestContent();
    
  }
  public interface EgressNetworkPolicyContentNested<N> extends Nested<N>,EgressNetworkPolicyFluent<ResourceAccessReviewFluent.EgressNetworkPolicyContentNested<N>>{
    public N and();
    public N endEgressNetworkPolicyContent();
    
  }
  public interface NetNamespaceContentNested<N> extends Nested<N>,NetNamespaceFluent<ResourceAccessReviewFluent.NetNamespaceContentNested<N>>{
    public N and();
    public N endNetNamespaceContent();
    
  }
  public interface UserIdentityMappingContentNested<N> extends Nested<N>,UserIdentityMappingFluent<ResourceAccessReviewFluent.UserIdentityMappingContentNested<N>>{
    public N and();
    public N endUserIdentityMappingContent();
    
  }
  public interface ImageStreamContentNested<N> extends Nested<N>,ImageStreamFluent<ResourceAccessReviewFluent.ImageStreamContentNested<N>>{
    public N and();
    public N endImageStreamContent();
    
  }
  public interface OAuthClientContentNested<N> extends Nested<N>,OAuthClientFluent<ResourceAccessReviewFluent.OAuthClientContentNested<N>>{
    public N and();
    public N endOAuthClientContent();
    
  }
  public interface IdentityContentNested<N> extends Nested<N>,IdentityFluent<ResourceAccessReviewFluent.IdentityContentNested<N>>{
    public N and();
    public N endIdentityContent();
    
  }
  
}