package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SourceControlUserBuilder extends SourceControlUserFluentImpl<SourceControlUserBuilder> implements VisitableBuilder<SourceControlUser,SourceControlUserBuilder>{
  public SourceControlUserBuilder() {
    this(false);
  }
  public SourceControlUserBuilder(Boolean validationEnabled) {
    this(new SourceControlUser(), validationEnabled);
  }
  public SourceControlUserBuilder(SourceControlUserFluent<?> fluent) {
    this(fluent, false);
  }
  public SourceControlUserBuilder(SourceControlUserFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SourceControlUser(), validationEnabled);
  }
  public SourceControlUserBuilder(SourceControlUserFluent<?> fluent,SourceControlUser instance) {
    this(fluent, instance, false);
  }
  public SourceControlUserBuilder(SourceControlUserFluent<?> fluent,SourceControlUser instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEmail(instance.getEmail()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SourceControlUserBuilder(SourceControlUser instance) {
    this(instance,false);
  }
  public SourceControlUserBuilder(SourceControlUser instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withEmail(instance.getEmail()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SourceControlUserFluent<?> fluent;
  Boolean validationEnabled;
  public SourceControlUser build() {
    SourceControlUser buildable = new SourceControlUser(fluent.getEmail(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}