package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Deprecated;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SubjectAccessReviewFluentImpl<A extends SubjectAccessReviewFluent<A>> extends BaseFluent<A> implements SubjectAccessReviewFluent<A>{
  public SubjectAccessReviewFluentImpl() {
  }
  public SubjectAccessReviewFluentImpl(SubjectAccessReview instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withContent(instance.getContent()); 
    this.withGroups(instance.getGroups()); 
    this.withIsNonResourceURL(instance.getIsNonResourceURL()); 
    this.withKind(instance.getKind()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPath(instance.getPath()); 
    this.withResource(instance.getResource()); 
    this.withResourceAPIGroup(instance.getResourceAPIGroup()); 
    this.withResourceAPIVersion(instance.getResourceAPIVersion()); 
    this.withResourceName(instance.getResourceName()); 
    this.withScopes(instance.getScopes()); 
    this.withUser(instance.getUser()); 
    this.withVerb(instance.getVerb()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private VisitableBuilder<? extends HasMetadata,?> content;
  private List<String> groups = new ArrayList<String>();
  private Boolean isNonResourceURL;
  private String kind;
  private String namespace;
  private String path;
  private String resource;
  private String resourceAPIGroup;
  private String resourceAPIVersion;
  private String resourceName;
  private List<String> scopes = new ArrayList<String>();
  private String user;
  private String verb;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * This method has been deprecated, please use method buildContent instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getContent() {
    return this.content!=null?this.content.build():null;
  }
  public HasMetadata buildContent() {
    return this.content!=null?this.content.build():null;
  }
  public A withContent(HasMetadata content) {
    if (content instanceof ImageStreamImport){ this.content= new ImageStreamImportBuilder((ImageStreamImport)content); _visitables.get("content").add(this.content);}
    if (content instanceof Project){ this.content= new ProjectBuilder((Project)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildConfig){ this.content= new BuildConfigBuilder((BuildConfig)content); _visitables.get("content").add(this.content);}
    if (content instanceof HelmChartRepository){ this.content= new HelmChartRepositoryBuilder((HelmChartRepository)content); _visitables.get("content").add(this.content);}
    if (content instanceof RangeAllocation){ this.content= new RangeAllocationBuilder((RangeAllocation)content); _visitables.get("content").add(this.content);}
    if (content instanceof Route){ this.content= new RouteBuilder((Route)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterNetwork){ this.content= new ClusterNetworkBuilder((ClusterNetwork)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthAuthorizeToken){ this.content= new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken)content); _visitables.get("content").add(this.content);}
    if (content instanceof UserOAuthAccessToken){ this.content= new UserOAuthAccessTokenBuilder((UserOAuthAccessToken)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterRoleBinding){ this.content= new ClusterRoleBindingBuilder((ClusterRoleBinding)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterResourceQuota){ this.content= new ClusterResourceQuotaBuilder((ClusterResourceQuota)content); _visitables.get("content").add(this.content);}
    if (content instanceof ProjectRequest){ this.content= new ProjectRequestBuilder((ProjectRequest)content); _visitables.get("content").add(this.content);}
    if (content instanceof Template){ this.content= new TemplateBuilder((Template)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthClientAuthorization){ this.content= new OAuthClientAuthorizationBuilder((OAuthClientAuthorization)content); _visitables.get("content").add(this.content);}
    if (content instanceof ClusterRole){ this.content= new ClusterRoleBuilder((ClusterRole)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageTag){ this.content= new ImageTagBuilder((ImageTag)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthAccessToken){ this.content= new OAuthAccessTokenBuilder((OAuthAccessToken)content); _visitables.get("content").add(this.content);}
    if (content instanceof DeploymentConfig){ this.content= new DeploymentConfigBuilder((DeploymentConfig)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoleBinding){ this.content= new RoleBindingBuilder((RoleBinding)content); _visitables.get("content").add(this.content);}
    if (content instanceof Image){ this.content= new ImageBuilder((Image)content); _visitables.get("content").add(this.content);}
    if (content instanceof PersistentVolumeClaim){ this.content= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamMapping){ this.content= new ImageStreamMappingBuilder((ImageStreamMapping)content); _visitables.get("content").add(this.content);}
    if (content instanceof Role){ this.content= new RoleBuilder((Role)content); _visitables.get("content").add(this.content);}
    if (content instanceof BrokerTemplateInstance){ this.content= new BrokerTemplateInstanceBuilder((BrokerTemplateInstance)content); _visitables.get("content").add(this.content);}
    if (content instanceof User){ this.content= new UserBuilder((User)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamImage){ this.content= new ImageStreamImageBuilder((ImageStreamImage)content); _visitables.get("content").add(this.content);}
    if (content instanceof TemplateInstance){ this.content= new TemplateInstanceBuilder((TemplateInstance)content); _visitables.get("content").add(this.content);}
    if (content instanceof Build){ this.content= new BuildBuilder((Build)content); _visitables.get("content").add(this.content);}
    if (content instanceof RoleBindingRestriction){ this.content= new RoleBindingRestrictionBuilder((RoleBindingRestriction)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStreamTag){ this.content= new ImageStreamTagBuilder((ImageStreamTag)content); _visitables.get("content").add(this.content);}
    if (content instanceof Group){ this.content= new GroupBuilder((Group)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageSignature){ this.content= new ImageSignatureBuilder((ImageSignature)content); _visitables.get("content").add(this.content);}
    if (content instanceof HostSubnet){ this.content= new HostSubnetBuilder((HostSubnet)content); _visitables.get("content").add(this.content);}
    if (content instanceof AppliedClusterResourceQuota){ this.content= new AppliedClusterResourceQuotaBuilder((AppliedClusterResourceQuota)content); _visitables.get("content").add(this.content);}
    if (content instanceof SecurityContextConstraints){ this.content= new SecurityContextConstraintsBuilder((SecurityContextConstraints)content); _visitables.get("content").add(this.content);}
    if (content instanceof BuildRequest){ this.content= new BuildRequestBuilder((BuildRequest)content); _visitables.get("content").add(this.content);}
    if (content instanceof EgressNetworkPolicy){ this.content= new EgressNetworkPolicyBuilder((EgressNetworkPolicy)content); _visitables.get("content").add(this.content);}
    if (content instanceof NetNamespace){ this.content= new NetNamespaceBuilder((NetNamespace)content); _visitables.get("content").add(this.content);}
    if (content instanceof UserIdentityMapping){ this.content= new UserIdentityMappingBuilder((UserIdentityMapping)content); _visitables.get("content").add(this.content);}
    if (content instanceof ImageStream){ this.content= new ImageStreamBuilder((ImageStream)content); _visitables.get("content").add(this.content);}
    if (content instanceof OAuthClient){ this.content= new OAuthClientBuilder((OAuthClient)content); _visitables.get("content").add(this.content);}
    if (content instanceof Identity){ this.content= new IdentityBuilder((Identity)content); _visitables.get("content").add(this.content);}
    return (A) this;
  }
  public Boolean hasContent() {
    return this.content != null;
  }
  public A withImageStreamImportContent(ImageStreamImport imageStreamImportContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamImportContent!=null){ this.content= new ImageStreamImportBuilder(imageStreamImportContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContent() {
    return new SubjectAccessReviewFluentImpl.ImageStreamImportContentNestedImpl();
  }
  public SubjectAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContentLike(ImageStreamImport item) {
    return new SubjectAccessReviewFluentImpl.ImageStreamImportContentNestedImpl(item);
  }
  public A withProjectContent(Project projectContent) {
    _visitables.get("content").remove(this.content);
    if (projectContent!=null){ this.content= new ProjectBuilder(projectContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.ProjectContentNested<A> withNewProjectContent() {
    return new SubjectAccessReviewFluentImpl.ProjectContentNestedImpl();
  }
  public SubjectAccessReviewFluent.ProjectContentNested<A> withNewProjectContentLike(Project item) {
    return new SubjectAccessReviewFluentImpl.ProjectContentNestedImpl(item);
  }
  public A withBuildConfigContent(BuildConfig buildConfigContent) {
    _visitables.get("content").remove(this.content);
    if (buildConfigContent!=null){ this.content= new BuildConfigBuilder(buildConfigContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContent() {
    return new SubjectAccessReviewFluentImpl.BuildConfigContentNestedImpl();
  }
  public SubjectAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContentLike(BuildConfig item) {
    return new SubjectAccessReviewFluentImpl.BuildConfigContentNestedImpl(item);
  }
  public A withHelmChartRepositoryContent(HelmChartRepository helmChartRepositoryContent) {
    _visitables.get("content").remove(this.content);
    if (helmChartRepositoryContent!=null){ this.content= new HelmChartRepositoryBuilder(helmChartRepositoryContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.HelmChartRepositoryContentNested<A> withNewHelmChartRepositoryContent() {
    return new SubjectAccessReviewFluentImpl.HelmChartRepositoryContentNestedImpl();
  }
  public SubjectAccessReviewFluent.HelmChartRepositoryContentNested<A> withNewHelmChartRepositoryContentLike(HelmChartRepository item) {
    return new SubjectAccessReviewFluentImpl.HelmChartRepositoryContentNestedImpl(item);
  }
  public A withRangeAllocationContent(RangeAllocation rangeAllocationContent) {
    _visitables.get("content").remove(this.content);
    if (rangeAllocationContent!=null){ this.content= new RangeAllocationBuilder(rangeAllocationContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.RangeAllocationContentNested<A> withNewRangeAllocationContent() {
    return new SubjectAccessReviewFluentImpl.RangeAllocationContentNestedImpl();
  }
  public SubjectAccessReviewFluent.RangeAllocationContentNested<A> withNewRangeAllocationContentLike(RangeAllocation item) {
    return new SubjectAccessReviewFluentImpl.RangeAllocationContentNestedImpl(item);
  }
  public A withRouteContent(Route routeContent) {
    _visitables.get("content").remove(this.content);
    if (routeContent!=null){ this.content= new RouteBuilder(routeContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.RouteContentNested<A> withNewRouteContent() {
    return new SubjectAccessReviewFluentImpl.RouteContentNestedImpl();
  }
  public SubjectAccessReviewFluent.RouteContentNested<A> withNewRouteContentLike(Route item) {
    return new SubjectAccessReviewFluentImpl.RouteContentNestedImpl(item);
  }
  public A withClusterNetworkContent(ClusterNetwork clusterNetworkContent) {
    _visitables.get("content").remove(this.content);
    if (clusterNetworkContent!=null){ this.content= new ClusterNetworkBuilder(clusterNetworkContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.ClusterNetworkContentNested<A> withNewClusterNetworkContent() {
    return new SubjectAccessReviewFluentImpl.ClusterNetworkContentNestedImpl();
  }
  public SubjectAccessReviewFluent.ClusterNetworkContentNested<A> withNewClusterNetworkContentLike(ClusterNetwork item) {
    return new SubjectAccessReviewFluentImpl.ClusterNetworkContentNestedImpl(item);
  }
  public A withOAuthAuthorizeTokenContent(OAuthAuthorizeToken oAuthAuthorizeTokenContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthAuthorizeTokenContent!=null){ this.content= new OAuthAuthorizeTokenBuilder(oAuthAuthorizeTokenContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContent() {
    return new SubjectAccessReviewFluentImpl.OAuthAuthorizeTokenContentNestedImpl();
  }
  public SubjectAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContentLike(OAuthAuthorizeToken item) {
    return new SubjectAccessReviewFluentImpl.OAuthAuthorizeTokenContentNestedImpl(item);
  }
  public A withUserOAuthAccessTokenContent(UserOAuthAccessToken userOAuthAccessTokenContent) {
    _visitables.get("content").remove(this.content);
    if (userOAuthAccessTokenContent!=null){ this.content= new UserOAuthAccessTokenBuilder(userOAuthAccessTokenContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.UserOAuthAccessTokenContentNested<A> withNewUserOAuthAccessTokenContent() {
    return new SubjectAccessReviewFluentImpl.UserOAuthAccessTokenContentNestedImpl();
  }
  public SubjectAccessReviewFluent.UserOAuthAccessTokenContentNested<A> withNewUserOAuthAccessTokenContentLike(UserOAuthAccessToken item) {
    return new SubjectAccessReviewFluentImpl.UserOAuthAccessTokenContentNestedImpl(item);
  }
  public A withClusterRoleBindingContent(ClusterRoleBinding clusterRoleBindingContent) {
    _visitables.get("content").remove(this.content);
    if (clusterRoleBindingContent!=null){ this.content= new ClusterRoleBindingBuilder(clusterRoleBindingContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContent() {
    return new SubjectAccessReviewFluentImpl.ClusterRoleBindingContentNestedImpl();
  }
  public SubjectAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContentLike(ClusterRoleBinding item) {
    return new SubjectAccessReviewFluentImpl.ClusterRoleBindingContentNestedImpl(item);
  }
  public A withClusterResourceQuotaContent(ClusterResourceQuota clusterResourceQuotaContent) {
    _visitables.get("content").remove(this.content);
    if (clusterResourceQuotaContent!=null){ this.content= new ClusterResourceQuotaBuilder(clusterResourceQuotaContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContent() {
    return new SubjectAccessReviewFluentImpl.ClusterResourceQuotaContentNestedImpl();
  }
  public SubjectAccessReviewFluent.ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContentLike(ClusterResourceQuota item) {
    return new SubjectAccessReviewFluentImpl.ClusterResourceQuotaContentNestedImpl(item);
  }
  public A withProjectRequestContent(ProjectRequest projectRequestContent) {
    _visitables.get("content").remove(this.content);
    if (projectRequestContent!=null){ this.content= new ProjectRequestBuilder(projectRequestContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContent() {
    return new SubjectAccessReviewFluentImpl.ProjectRequestContentNestedImpl();
  }
  public SubjectAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContentLike(ProjectRequest item) {
    return new SubjectAccessReviewFluentImpl.ProjectRequestContentNestedImpl(item);
  }
  public A withTemplateContent(Template templateContent) {
    _visitables.get("content").remove(this.content);
    if (templateContent!=null){ this.content= new TemplateBuilder(templateContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.TemplateContentNested<A> withNewTemplateContent() {
    return new SubjectAccessReviewFluentImpl.TemplateContentNestedImpl();
  }
  public SubjectAccessReviewFluent.TemplateContentNested<A> withNewTemplateContentLike(Template item) {
    return new SubjectAccessReviewFluentImpl.TemplateContentNestedImpl(item);
  }
  public A withOAuthClientAuthorizationContent(OAuthClientAuthorization oAuthClientAuthorizationContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthClientAuthorizationContent!=null){ this.content= new OAuthClientAuthorizationBuilder(oAuthClientAuthorizationContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContent() {
    return new SubjectAccessReviewFluentImpl.OAuthClientAuthorizationContentNestedImpl();
  }
  public SubjectAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContentLike(OAuthClientAuthorization item) {
    return new SubjectAccessReviewFluentImpl.OAuthClientAuthorizationContentNestedImpl(item);
  }
  public A withClusterRoleContent(ClusterRole clusterRoleContent) {
    _visitables.get("content").remove(this.content);
    if (clusterRoleContent!=null){ this.content= new ClusterRoleBuilder(clusterRoleContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContent() {
    return new SubjectAccessReviewFluentImpl.ClusterRoleContentNestedImpl();
  }
  public SubjectAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContentLike(ClusterRole item) {
    return new SubjectAccessReviewFluentImpl.ClusterRoleContentNestedImpl(item);
  }
  public A withImageTagContent(ImageTag imageTagContent) {
    _visitables.get("content").remove(this.content);
    if (imageTagContent!=null){ this.content= new ImageTagBuilder(imageTagContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.ImageTagContentNested<A> withNewImageTagContent() {
    return new SubjectAccessReviewFluentImpl.ImageTagContentNestedImpl();
  }
  public SubjectAccessReviewFluent.ImageTagContentNested<A> withNewImageTagContentLike(ImageTag item) {
    return new SubjectAccessReviewFluentImpl.ImageTagContentNestedImpl(item);
  }
  public A withOAuthAccessTokenContent(OAuthAccessToken oAuthAccessTokenContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthAccessTokenContent!=null){ this.content= new OAuthAccessTokenBuilder(oAuthAccessTokenContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContent() {
    return new SubjectAccessReviewFluentImpl.OAuthAccessTokenContentNestedImpl();
  }
  public SubjectAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContentLike(OAuthAccessToken item) {
    return new SubjectAccessReviewFluentImpl.OAuthAccessTokenContentNestedImpl(item);
  }
  public A withDeploymentConfigContent(DeploymentConfig deploymentConfigContent) {
    _visitables.get("content").remove(this.content);
    if (deploymentConfigContent!=null){ this.content= new DeploymentConfigBuilder(deploymentConfigContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContent() {
    return new SubjectAccessReviewFluentImpl.DeploymentConfigContentNestedImpl();
  }
  public SubjectAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContentLike(DeploymentConfig item) {
    return new SubjectAccessReviewFluentImpl.DeploymentConfigContentNestedImpl(item);
  }
  public A withRoleBindingContent(RoleBinding roleBindingContent) {
    _visitables.get("content").remove(this.content);
    if (roleBindingContent!=null){ this.content= new RoleBindingBuilder(roleBindingContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContent() {
    return new SubjectAccessReviewFluentImpl.RoleBindingContentNestedImpl();
  }
  public SubjectAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContentLike(RoleBinding item) {
    return new SubjectAccessReviewFluentImpl.RoleBindingContentNestedImpl(item);
  }
  public A withImageContent(Image imageContent) {
    _visitables.get("content").remove(this.content);
    if (imageContent!=null){ this.content= new ImageBuilder(imageContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.ImageContentNested<A> withNewImageContent() {
    return new SubjectAccessReviewFluentImpl.ImageContentNestedImpl();
  }
  public SubjectAccessReviewFluent.ImageContentNested<A> withNewImageContentLike(Image item) {
    return new SubjectAccessReviewFluentImpl.ImageContentNestedImpl(item);
  }
  public A withPersistentVolumeClaimContent(PersistentVolumeClaim persistentVolumeClaimContent) {
    _visitables.get("content").remove(this.content);
    if (persistentVolumeClaimContent!=null){ this.content= new PersistentVolumeClaimBuilder(persistentVolumeClaimContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContent() {
    return new SubjectAccessReviewFluentImpl.PersistentVolumeClaimContentNestedImpl();
  }
  public SubjectAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContentLike(PersistentVolumeClaim item) {
    return new SubjectAccessReviewFluentImpl.PersistentVolumeClaimContentNestedImpl(item);
  }
  public A withImageStreamMappingContent(ImageStreamMapping imageStreamMappingContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamMappingContent!=null){ this.content= new ImageStreamMappingBuilder(imageStreamMappingContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.ImageStreamMappingContentNested<A> withNewImageStreamMappingContent() {
    return new SubjectAccessReviewFluentImpl.ImageStreamMappingContentNestedImpl();
  }
  public SubjectAccessReviewFluent.ImageStreamMappingContentNested<A> withNewImageStreamMappingContentLike(ImageStreamMapping item) {
    return new SubjectAccessReviewFluentImpl.ImageStreamMappingContentNestedImpl(item);
  }
  public A withRoleContent(Role roleContent) {
    _visitables.get("content").remove(this.content);
    if (roleContent!=null){ this.content= new RoleBuilder(roleContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.RoleContentNested<A> withNewRoleContent() {
    return new SubjectAccessReviewFluentImpl.RoleContentNestedImpl();
  }
  public SubjectAccessReviewFluent.RoleContentNested<A> withNewRoleContentLike(Role item) {
    return new SubjectAccessReviewFluentImpl.RoleContentNestedImpl(item);
  }
  public A withBrokerTemplateInstanceContent(BrokerTemplateInstance brokerTemplateInstanceContent) {
    _visitables.get("content").remove(this.content);
    if (brokerTemplateInstanceContent!=null){ this.content= new BrokerTemplateInstanceBuilder(brokerTemplateInstanceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.BrokerTemplateInstanceContentNested<A> withNewBrokerTemplateInstanceContent() {
    return new SubjectAccessReviewFluentImpl.BrokerTemplateInstanceContentNestedImpl();
  }
  public SubjectAccessReviewFluent.BrokerTemplateInstanceContentNested<A> withNewBrokerTemplateInstanceContentLike(BrokerTemplateInstance item) {
    return new SubjectAccessReviewFluentImpl.BrokerTemplateInstanceContentNestedImpl(item);
  }
  public A withUserContent(User userContent) {
    _visitables.get("content").remove(this.content);
    if (userContent!=null){ this.content= new UserBuilder(userContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.UserContentNested<A> withNewUserContent() {
    return new SubjectAccessReviewFluentImpl.UserContentNestedImpl();
  }
  public SubjectAccessReviewFluent.UserContentNested<A> withNewUserContentLike(User item) {
    return new SubjectAccessReviewFluentImpl.UserContentNestedImpl(item);
  }
  public A withImageStreamImageContent(ImageStreamImage imageStreamImageContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamImageContent!=null){ this.content= new ImageStreamImageBuilder(imageStreamImageContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.ImageStreamImageContentNested<A> withNewImageStreamImageContent() {
    return new SubjectAccessReviewFluentImpl.ImageStreamImageContentNestedImpl();
  }
  public SubjectAccessReviewFluent.ImageStreamImageContentNested<A> withNewImageStreamImageContentLike(ImageStreamImage item) {
    return new SubjectAccessReviewFluentImpl.ImageStreamImageContentNestedImpl(item);
  }
  public A withTemplateInstanceContent(TemplateInstance templateInstanceContent) {
    _visitables.get("content").remove(this.content);
    if (templateInstanceContent!=null){ this.content= new TemplateInstanceBuilder(templateInstanceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.TemplateInstanceContentNested<A> withNewTemplateInstanceContent() {
    return new SubjectAccessReviewFluentImpl.TemplateInstanceContentNestedImpl();
  }
  public SubjectAccessReviewFluent.TemplateInstanceContentNested<A> withNewTemplateInstanceContentLike(TemplateInstance item) {
    return new SubjectAccessReviewFluentImpl.TemplateInstanceContentNestedImpl(item);
  }
  public A withBuildContent(Build buildContent) {
    _visitables.get("content").remove(this.content);
    if (buildContent!=null){ this.content= new BuildBuilder(buildContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.BuildContentNested<A> withNewBuildContent() {
    return new SubjectAccessReviewFluentImpl.BuildContentNestedImpl();
  }
  public SubjectAccessReviewFluent.BuildContentNested<A> withNewBuildContentLike(Build item) {
    return new SubjectAccessReviewFluentImpl.BuildContentNestedImpl(item);
  }
  public A withRoleBindingRestrictionContent(RoleBindingRestriction roleBindingRestrictionContent) {
    _visitables.get("content").remove(this.content);
    if (roleBindingRestrictionContent!=null){ this.content= new RoleBindingRestrictionBuilder(roleBindingRestrictionContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContent() {
    return new SubjectAccessReviewFluentImpl.RoleBindingRestrictionContentNestedImpl();
  }
  public SubjectAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContentLike(RoleBindingRestriction item) {
    return new SubjectAccessReviewFluentImpl.RoleBindingRestrictionContentNestedImpl(item);
  }
  public A withImageStreamTagContent(ImageStreamTag imageStreamTagContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamTagContent!=null){ this.content= new ImageStreamTagBuilder(imageStreamTagContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContent() {
    return new SubjectAccessReviewFluentImpl.ImageStreamTagContentNestedImpl();
  }
  public SubjectAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContentLike(ImageStreamTag item) {
    return new SubjectAccessReviewFluentImpl.ImageStreamTagContentNestedImpl(item);
  }
  public A withGroupContent(Group groupContent) {
    _visitables.get("content").remove(this.content);
    if (groupContent!=null){ this.content= new GroupBuilder(groupContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.GroupContentNested<A> withNewGroupContent() {
    return new SubjectAccessReviewFluentImpl.GroupContentNestedImpl();
  }
  public SubjectAccessReviewFluent.GroupContentNested<A> withNewGroupContentLike(Group item) {
    return new SubjectAccessReviewFluentImpl.GroupContentNestedImpl(item);
  }
  public A withImageSignatureContent(ImageSignature imageSignatureContent) {
    _visitables.get("content").remove(this.content);
    if (imageSignatureContent!=null){ this.content= new ImageSignatureBuilder(imageSignatureContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContent() {
    return new SubjectAccessReviewFluentImpl.ImageSignatureContentNestedImpl();
  }
  public SubjectAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContentLike(ImageSignature item) {
    return new SubjectAccessReviewFluentImpl.ImageSignatureContentNestedImpl(item);
  }
  public A withHostSubnetContent(HostSubnet hostSubnetContent) {
    _visitables.get("content").remove(this.content);
    if (hostSubnetContent!=null){ this.content= new HostSubnetBuilder(hostSubnetContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.HostSubnetContentNested<A> withNewHostSubnetContent() {
    return new SubjectAccessReviewFluentImpl.HostSubnetContentNestedImpl();
  }
  public SubjectAccessReviewFluent.HostSubnetContentNested<A> withNewHostSubnetContentLike(HostSubnet item) {
    return new SubjectAccessReviewFluentImpl.HostSubnetContentNestedImpl(item);
  }
  public A withAppliedClusterResourceQuotaContent(AppliedClusterResourceQuota appliedClusterResourceQuotaContent) {
    _visitables.get("content").remove(this.content);
    if (appliedClusterResourceQuotaContent!=null){ this.content= new AppliedClusterResourceQuotaBuilder(appliedClusterResourceQuotaContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContent() {
    return new SubjectAccessReviewFluentImpl.AppliedClusterResourceQuotaContentNestedImpl();
  }
  public SubjectAccessReviewFluent.AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContentLike(AppliedClusterResourceQuota item) {
    return new SubjectAccessReviewFluentImpl.AppliedClusterResourceQuotaContentNestedImpl(item);
  }
  public A withSecurityContextConstraintsContent(SecurityContextConstraints securityContextConstraintsContent) {
    _visitables.get("content").remove(this.content);
    if (securityContextConstraintsContent!=null){ this.content= new SecurityContextConstraintsBuilder(securityContextConstraintsContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContent() {
    return new SubjectAccessReviewFluentImpl.SecurityContextConstraintsContentNestedImpl();
  }
  public SubjectAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContentLike(SecurityContextConstraints item) {
    return new SubjectAccessReviewFluentImpl.SecurityContextConstraintsContentNestedImpl(item);
  }
  public A withBuildRequestContent(BuildRequest buildRequestContent) {
    _visitables.get("content").remove(this.content);
    if (buildRequestContent!=null){ this.content= new BuildRequestBuilder(buildRequestContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContent() {
    return new SubjectAccessReviewFluentImpl.BuildRequestContentNestedImpl();
  }
  public SubjectAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContentLike(BuildRequest item) {
    return new SubjectAccessReviewFluentImpl.BuildRequestContentNestedImpl(item);
  }
  public A withEgressNetworkPolicyContent(EgressNetworkPolicy egressNetworkPolicyContent) {
    _visitables.get("content").remove(this.content);
    if (egressNetworkPolicyContent!=null){ this.content= new EgressNetworkPolicyBuilder(egressNetworkPolicyContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContent() {
    return new SubjectAccessReviewFluentImpl.EgressNetworkPolicyContentNestedImpl();
  }
  public SubjectAccessReviewFluent.EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContentLike(EgressNetworkPolicy item) {
    return new SubjectAccessReviewFluentImpl.EgressNetworkPolicyContentNestedImpl(item);
  }
  public A withNetNamespaceContent(NetNamespace netNamespaceContent) {
    _visitables.get("content").remove(this.content);
    if (netNamespaceContent!=null){ this.content= new NetNamespaceBuilder(netNamespaceContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContent() {
    return new SubjectAccessReviewFluentImpl.NetNamespaceContentNestedImpl();
  }
  public SubjectAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContentLike(NetNamespace item) {
    return new SubjectAccessReviewFluentImpl.NetNamespaceContentNestedImpl(item);
  }
  public A withUserIdentityMappingContent(UserIdentityMapping userIdentityMappingContent) {
    _visitables.get("content").remove(this.content);
    if (userIdentityMappingContent!=null){ this.content= new UserIdentityMappingBuilder(userIdentityMappingContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.UserIdentityMappingContentNested<A> withNewUserIdentityMappingContent() {
    return new SubjectAccessReviewFluentImpl.UserIdentityMappingContentNestedImpl();
  }
  public SubjectAccessReviewFluent.UserIdentityMappingContentNested<A> withNewUserIdentityMappingContentLike(UserIdentityMapping item) {
    return new SubjectAccessReviewFluentImpl.UserIdentityMappingContentNestedImpl(item);
  }
  public A withImageStreamContent(ImageStream imageStreamContent) {
    _visitables.get("content").remove(this.content);
    if (imageStreamContent!=null){ this.content= new ImageStreamBuilder(imageStreamContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContent() {
    return new SubjectAccessReviewFluentImpl.ImageStreamContentNestedImpl();
  }
  public SubjectAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContentLike(ImageStream item) {
    return new SubjectAccessReviewFluentImpl.ImageStreamContentNestedImpl(item);
  }
  public A withOAuthClientContent(OAuthClient oAuthClientContent) {
    _visitables.get("content").remove(this.content);
    if (oAuthClientContent!=null){ this.content= new OAuthClientBuilder(oAuthClientContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContent() {
    return new SubjectAccessReviewFluentImpl.OAuthClientContentNestedImpl();
  }
  public SubjectAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContentLike(OAuthClient item) {
    return new SubjectAccessReviewFluentImpl.OAuthClientContentNestedImpl(item);
  }
  public A withIdentityContent(Identity identityContent) {
    _visitables.get("content").remove(this.content);
    if (identityContent!=null){ this.content= new IdentityBuilder(identityContent); _visitables.get("content").add(this.content);} else { this.content = null; _visitables.get("content").remove(this.content); } return (A) this;
  }
  public SubjectAccessReviewFluent.IdentityContentNested<A> withNewIdentityContent() {
    return new SubjectAccessReviewFluentImpl.IdentityContentNestedImpl();
  }
  public SubjectAccessReviewFluent.IdentityContentNested<A> withNewIdentityContentLike(Identity item) {
    return new SubjectAccessReviewFluentImpl.IdentityContentNestedImpl(item);
  }
  public A addToGroups(Integer index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.add(index, item);
    return (A)this;
  }
  public A setToGroups(Integer index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.set(index, item); return (A)this;
  }
  public A addToGroups(java.lang.String... items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A addAllToGroups(Collection<String> items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A removeFromGroups(java.lang.String... items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public A removeAllFromGroups(Collection<String> items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public List<String> getGroups() {
    return this.groups;
  }
  public String getGroup(Integer index) {
    return this.groups.get(index);
  }
  public String getFirstGroup() {
    return this.groups.get(0);
  }
  public String getLastGroup() {
    return this.groups.get(groups.size() - 1);
  }
  public String getMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroups(List<String> groups) {
    if (groups != null) {this.groups = new ArrayList(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
  }
  public A withGroups(java.lang.String... groups) {
    if (this.groups != null) {this.groups.clear();}
    if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
  }
  public Boolean hasGroups() {
    return groups != null && !groups.isEmpty();
  }
  public Boolean getIsNonResourceURL() {
    return this.isNonResourceURL;
  }
  public A withIsNonResourceURL(Boolean isNonResourceURL) {
    this.isNonResourceURL=isNonResourceURL; return (A) this;
  }
  public Boolean hasIsNonResourceURL() {
    return this.isNonResourceURL != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public String getNamespace() {
    return this.namespace;
  }
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  public Boolean hasNamespace() {
    return this.namespace != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  public String getResource() {
    return this.resource;
  }
  public A withResource(String resource) {
    this.resource=resource; return (A) this;
  }
  public Boolean hasResource() {
    return this.resource != null;
  }
  public String getResourceAPIGroup() {
    return this.resourceAPIGroup;
  }
  public A withResourceAPIGroup(String resourceAPIGroup) {
    this.resourceAPIGroup=resourceAPIGroup; return (A) this;
  }
  public Boolean hasResourceAPIGroup() {
    return this.resourceAPIGroup != null;
  }
  public String getResourceAPIVersion() {
    return this.resourceAPIVersion;
  }
  public A withResourceAPIVersion(String resourceAPIVersion) {
    this.resourceAPIVersion=resourceAPIVersion; return (A) this;
  }
  public Boolean hasResourceAPIVersion() {
    return this.resourceAPIVersion != null;
  }
  public String getResourceName() {
    return this.resourceName;
  }
  public A withResourceName(String resourceName) {
    this.resourceName=resourceName; return (A) this;
  }
  public Boolean hasResourceName() {
    return this.resourceName != null;
  }
  public A addToScopes(Integer index,String item) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    this.scopes.add(index, item);
    return (A)this;
  }
  public A setToScopes(Integer index,String item) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    this.scopes.set(index, item); return (A)this;
  }
  public A addToScopes(java.lang.String... items) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    for (String item : items) {this.scopes.add(item);} return (A)this;
  }
  public A addAllToScopes(Collection<String> items) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    for (String item : items) {this.scopes.add(item);} return (A)this;
  }
  public A removeFromScopes(java.lang.String... items) {
    for (String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
  }
  public A removeAllFromScopes(Collection<String> items) {
    for (String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
  }
  public List<String> getScopes() {
    return this.scopes;
  }
  public String getScope(Integer index) {
    return this.scopes.get(index);
  }
  public String getFirstScope() {
    return this.scopes.get(0);
  }
  public String getLastScope() {
    return this.scopes.get(scopes.size() - 1);
  }
  public String getMatchingScope(Predicate<String> predicate) {
    for (String item: scopes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingScope(Predicate<String> predicate) {
    for (String item: scopes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withScopes(List<String> scopes) {
    if (scopes != null) {this.scopes = new ArrayList(); for (String item : scopes){this.addToScopes(item);}} else { this.scopes = null;} return (A) this;
  }
  public A withScopes(java.lang.String... scopes) {
    if (this.scopes != null) {this.scopes.clear();}
    if (scopes != null) {for (String item :scopes){ this.addToScopes(item);}} return (A) this;
  }
  public Boolean hasScopes() {
    return scopes != null && !scopes.isEmpty();
  }
  public String getUser() {
    return this.user;
  }
  public A withUser(String user) {
    this.user=user; return (A) this;
  }
  public Boolean hasUser() {
    return this.user != null;
  }
  public String getVerb() {
    return this.verb;
  }
  public A withVerb(String verb) {
    this.verb=verb; return (A) this;
  }
  public Boolean hasVerb() {
    return this.verb != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SubjectAccessReviewFluentImpl that = (SubjectAccessReviewFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (content != null ? !content.equals(that.content) :that.content != null) return false;
    if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
    if (isNonResourceURL != null ? !isNonResourceURL.equals(that.isNonResourceURL) :that.isNonResourceURL != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
    if (resourceAPIGroup != null ? !resourceAPIGroup.equals(that.resourceAPIGroup) :that.resourceAPIGroup != null) return false;
    if (resourceAPIVersion != null ? !resourceAPIVersion.equals(that.resourceAPIVersion) :that.resourceAPIVersion != null) return false;
    if (resourceName != null ? !resourceName.equals(that.resourceName) :that.resourceName != null) return false;
    if (scopes != null ? !scopes.equals(that.scopes) :that.scopes != null) return false;
    if (user != null ? !user.equals(that.user) :that.user != null) return false;
    if (verb != null ? !verb.equals(that.verb) :that.verb != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  content,  groups,  isNonResourceURL,  kind,  namespace,  path,  resource,  resourceAPIGroup,  resourceAPIVersion,  resourceName,  scopes,  user,  verb,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (content != null) { sb.append("content:"); sb.append(content + ","); }
    if (groups != null && !groups.isEmpty()) { sb.append("groups:"); sb.append(groups + ","); }
    if (isNonResourceURL != null) { sb.append("isNonResourceURL:"); sb.append(isNonResourceURL + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (resourceAPIGroup != null) { sb.append("resourceAPIGroup:"); sb.append(resourceAPIGroup + ","); }
    if (resourceAPIVersion != null) { sb.append("resourceAPIVersion:"); sb.append(resourceAPIVersion + ","); }
    if (resourceName != null) { sb.append("resourceName:"); sb.append(resourceName + ","); }
    if (scopes != null && !scopes.isEmpty()) { sb.append("scopes:"); sb.append(scopes + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (verb != null) { sb.append("verb:"); sb.append(verb + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withIsNonResourceURL() {
    return withIsNonResourceURL(true);
  }
  class ImageStreamImportContentNestedImpl<N> extends ImageStreamImportFluentImpl<SubjectAccessReviewFluent.ImageStreamImportContentNested<N>> implements SubjectAccessReviewFluent.ImageStreamImportContentNested<N>,Nested<N>{
    ImageStreamImportContentNestedImpl(ImageStreamImport item) {
      this.builder = new ImageStreamImportBuilder(this, item);
    }
    ImageStreamImportContentNestedImpl() {
      this.builder = new ImageStreamImportBuilder(this);
    }
    ImageStreamImportBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamImportContent() {
      return and();
    }
    
  }
  class ProjectContentNestedImpl<N> extends ProjectFluentImpl<SubjectAccessReviewFluent.ProjectContentNested<N>> implements SubjectAccessReviewFluent.ProjectContentNested<N>,Nested<N>{
    ProjectContentNestedImpl(Project item) {
      this.builder = new ProjectBuilder(this, item);
    }
    ProjectContentNestedImpl() {
      this.builder = new ProjectBuilder(this);
    }
    ProjectBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endProjectContent() {
      return and();
    }
    
  }
  class BuildConfigContentNestedImpl<N> extends BuildConfigFluentImpl<SubjectAccessReviewFluent.BuildConfigContentNested<N>> implements SubjectAccessReviewFluent.BuildConfigContentNested<N>,Nested<N>{
    BuildConfigContentNestedImpl(BuildConfig item) {
      this.builder = new BuildConfigBuilder(this, item);
    }
    BuildConfigContentNestedImpl() {
      this.builder = new BuildConfigBuilder(this);
    }
    BuildConfigBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildConfigContent() {
      return and();
    }
    
  }
  class HelmChartRepositoryContentNestedImpl<N> extends HelmChartRepositoryFluentImpl<SubjectAccessReviewFluent.HelmChartRepositoryContentNested<N>> implements SubjectAccessReviewFluent.HelmChartRepositoryContentNested<N>,Nested<N>{
    HelmChartRepositoryContentNestedImpl(HelmChartRepository item) {
      this.builder = new HelmChartRepositoryBuilder(this, item);
    }
    HelmChartRepositoryContentNestedImpl() {
      this.builder = new HelmChartRepositoryBuilder(this);
    }
    HelmChartRepositoryBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endHelmChartRepositoryContent() {
      return and();
    }
    
  }
  class RangeAllocationContentNestedImpl<N> extends RangeAllocationFluentImpl<SubjectAccessReviewFluent.RangeAllocationContentNested<N>> implements SubjectAccessReviewFluent.RangeAllocationContentNested<N>,Nested<N>{
    RangeAllocationContentNestedImpl(RangeAllocation item) {
      this.builder = new RangeAllocationBuilder(this, item);
    }
    RangeAllocationContentNestedImpl() {
      this.builder = new RangeAllocationBuilder(this);
    }
    RangeAllocationBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRangeAllocationContent() {
      return and();
    }
    
  }
  class RouteContentNestedImpl<N> extends RouteFluentImpl<SubjectAccessReviewFluent.RouteContentNested<N>> implements SubjectAccessReviewFluent.RouteContentNested<N>,Nested<N>{
    RouteContentNestedImpl(Route item) {
      this.builder = new RouteBuilder(this, item);
    }
    RouteContentNestedImpl() {
      this.builder = new RouteBuilder(this);
    }
    RouteBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteContent() {
      return and();
    }
    
  }
  class ClusterNetworkContentNestedImpl<N> extends ClusterNetworkFluentImpl<SubjectAccessReviewFluent.ClusterNetworkContentNested<N>> implements SubjectAccessReviewFluent.ClusterNetworkContentNested<N>,Nested<N>{
    ClusterNetworkContentNestedImpl(ClusterNetwork item) {
      this.builder = new ClusterNetworkBuilder(this, item);
    }
    ClusterNetworkContentNestedImpl() {
      this.builder = new ClusterNetworkBuilder(this);
    }
    ClusterNetworkBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterNetworkContent() {
      return and();
    }
    
  }
  class OAuthAuthorizeTokenContentNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<SubjectAccessReviewFluent.OAuthAuthorizeTokenContentNested<N>> implements SubjectAccessReviewFluent.OAuthAuthorizeTokenContentNested<N>,Nested<N>{
    OAuthAuthorizeTokenContentNestedImpl(OAuthAuthorizeToken item) {
      this.builder = new OAuthAuthorizeTokenBuilder(this, item);
    }
    OAuthAuthorizeTokenContentNestedImpl() {
      this.builder = new OAuthAuthorizeTokenBuilder(this);
    }
    OAuthAuthorizeTokenBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthAuthorizeTokenContent() {
      return and();
    }
    
  }
  class UserOAuthAccessTokenContentNestedImpl<N> extends UserOAuthAccessTokenFluentImpl<SubjectAccessReviewFluent.UserOAuthAccessTokenContentNested<N>> implements SubjectAccessReviewFluent.UserOAuthAccessTokenContentNested<N>,Nested<N>{
    UserOAuthAccessTokenContentNestedImpl(UserOAuthAccessToken item) {
      this.builder = new UserOAuthAccessTokenBuilder(this, item);
    }
    UserOAuthAccessTokenContentNestedImpl() {
      this.builder = new UserOAuthAccessTokenBuilder(this);
    }
    UserOAuthAccessTokenBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserOAuthAccessTokenContent() {
      return and();
    }
    
  }
  class ClusterRoleBindingContentNestedImpl<N> extends ClusterRoleBindingFluentImpl<SubjectAccessReviewFluent.ClusterRoleBindingContentNested<N>> implements SubjectAccessReviewFluent.ClusterRoleBindingContentNested<N>,Nested<N>{
    ClusterRoleBindingContentNestedImpl(ClusterRoleBinding item) {
      this.builder = new ClusterRoleBindingBuilder(this, item);
    }
    ClusterRoleBindingContentNestedImpl() {
      this.builder = new ClusterRoleBindingBuilder(this);
    }
    ClusterRoleBindingBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterRoleBindingContent() {
      return and();
    }
    
  }
  class ClusterResourceQuotaContentNestedImpl<N> extends ClusterResourceQuotaFluentImpl<SubjectAccessReviewFluent.ClusterResourceQuotaContentNested<N>> implements SubjectAccessReviewFluent.ClusterResourceQuotaContentNested<N>,Nested<N>{
    ClusterResourceQuotaContentNestedImpl(ClusterResourceQuota item) {
      this.builder = new ClusterResourceQuotaBuilder(this, item);
    }
    ClusterResourceQuotaContentNestedImpl() {
      this.builder = new ClusterResourceQuotaBuilder(this);
    }
    ClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterResourceQuotaContent() {
      return and();
    }
    
  }
  class ProjectRequestContentNestedImpl<N> extends ProjectRequestFluentImpl<SubjectAccessReviewFluent.ProjectRequestContentNested<N>> implements SubjectAccessReviewFluent.ProjectRequestContentNested<N>,Nested<N>{
    ProjectRequestContentNestedImpl(ProjectRequest item) {
      this.builder = new ProjectRequestBuilder(this, item);
    }
    ProjectRequestContentNestedImpl() {
      this.builder = new ProjectRequestBuilder(this);
    }
    ProjectRequestBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endProjectRequestContent() {
      return and();
    }
    
  }
  class TemplateContentNestedImpl<N> extends TemplateFluentImpl<SubjectAccessReviewFluent.TemplateContentNested<N>> implements SubjectAccessReviewFluent.TemplateContentNested<N>,Nested<N>{
    TemplateContentNestedImpl(Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateContentNestedImpl() {
      this.builder = new TemplateBuilder(this);
    }
    TemplateBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateContent() {
      return and();
    }
    
  }
  class OAuthClientAuthorizationContentNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<SubjectAccessReviewFluent.OAuthClientAuthorizationContentNested<N>> implements SubjectAccessReviewFluent.OAuthClientAuthorizationContentNested<N>,Nested<N>{
    OAuthClientAuthorizationContentNestedImpl(OAuthClientAuthorization item) {
      this.builder = new OAuthClientAuthorizationBuilder(this, item);
    }
    OAuthClientAuthorizationContentNestedImpl() {
      this.builder = new OAuthClientAuthorizationBuilder(this);
    }
    OAuthClientAuthorizationBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthClientAuthorizationContent() {
      return and();
    }
    
  }
  class ClusterRoleContentNestedImpl<N> extends ClusterRoleFluentImpl<SubjectAccessReviewFluent.ClusterRoleContentNested<N>> implements SubjectAccessReviewFluent.ClusterRoleContentNested<N>,Nested<N>{
    ClusterRoleContentNestedImpl(ClusterRole item) {
      this.builder = new ClusterRoleBuilder(this, item);
    }
    ClusterRoleContentNestedImpl() {
      this.builder = new ClusterRoleBuilder(this);
    }
    ClusterRoleBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterRoleContent() {
      return and();
    }
    
  }
  class ImageTagContentNestedImpl<N> extends ImageTagFluentImpl<SubjectAccessReviewFluent.ImageTagContentNested<N>> implements SubjectAccessReviewFluent.ImageTagContentNested<N>,Nested<N>{
    ImageTagContentNestedImpl(ImageTag item) {
      this.builder = new ImageTagBuilder(this, item);
    }
    ImageTagContentNestedImpl() {
      this.builder = new ImageTagBuilder(this);
    }
    ImageTagBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageTagContent() {
      return and();
    }
    
  }
  class OAuthAccessTokenContentNestedImpl<N> extends OAuthAccessTokenFluentImpl<SubjectAccessReviewFluent.OAuthAccessTokenContentNested<N>> implements SubjectAccessReviewFluent.OAuthAccessTokenContentNested<N>,Nested<N>{
    OAuthAccessTokenContentNestedImpl(OAuthAccessToken item) {
      this.builder = new OAuthAccessTokenBuilder(this, item);
    }
    OAuthAccessTokenContentNestedImpl() {
      this.builder = new OAuthAccessTokenBuilder(this);
    }
    OAuthAccessTokenBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthAccessTokenContent() {
      return and();
    }
    
  }
  class DeploymentConfigContentNestedImpl<N> extends DeploymentConfigFluentImpl<SubjectAccessReviewFluent.DeploymentConfigContentNested<N>> implements SubjectAccessReviewFluent.DeploymentConfigContentNested<N>,Nested<N>{
    DeploymentConfigContentNestedImpl(DeploymentConfig item) {
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigContentNestedImpl() {
      this.builder = new DeploymentConfigBuilder(this);
    }
    DeploymentConfigBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentConfigContent() {
      return and();
    }
    
  }
  class RoleBindingContentNestedImpl<N> extends RoleBindingFluentImpl<SubjectAccessReviewFluent.RoleBindingContentNested<N>> implements SubjectAccessReviewFluent.RoleBindingContentNested<N>,Nested<N>{
    RoleBindingContentNestedImpl(RoleBinding item) {
      this.builder = new RoleBindingBuilder(this, item);
    }
    RoleBindingContentNestedImpl() {
      this.builder = new RoleBindingBuilder(this);
    }
    RoleBindingBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleBindingContent() {
      return and();
    }
    
  }
  class ImageContentNestedImpl<N> extends ImageFluentImpl<SubjectAccessReviewFluent.ImageContentNested<N>> implements SubjectAccessReviewFluent.ImageContentNested<N>,Nested<N>{
    ImageContentNestedImpl(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageContentNestedImpl() {
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageContent() {
      return and();
    }
    
  }
  class PersistentVolumeClaimContentNestedImpl<N> extends PersistentVolumeClaimFluentImpl<SubjectAccessReviewFluent.PersistentVolumeClaimContentNested<N>> implements SubjectAccessReviewFluent.PersistentVolumeClaimContentNested<N>,Nested<N>{
    PersistentVolumeClaimContentNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimContentNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPersistentVolumeClaimContent() {
      return and();
    }
    
  }
  class ImageStreamMappingContentNestedImpl<N> extends ImageStreamMappingFluentImpl<SubjectAccessReviewFluent.ImageStreamMappingContentNested<N>> implements SubjectAccessReviewFluent.ImageStreamMappingContentNested<N>,Nested<N>{
    ImageStreamMappingContentNestedImpl(ImageStreamMapping item) {
      this.builder = new ImageStreamMappingBuilder(this, item);
    }
    ImageStreamMappingContentNestedImpl() {
      this.builder = new ImageStreamMappingBuilder(this);
    }
    ImageStreamMappingBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamMappingContent() {
      return and();
    }
    
  }
  class RoleContentNestedImpl<N> extends RoleFluentImpl<SubjectAccessReviewFluent.RoleContentNested<N>> implements SubjectAccessReviewFluent.RoleContentNested<N>,Nested<N>{
    RoleContentNestedImpl(Role item) {
      this.builder = new RoleBuilder(this, item);
    }
    RoleContentNestedImpl() {
      this.builder = new RoleBuilder(this);
    }
    RoleBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleContent() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceContentNestedImpl<N> extends BrokerTemplateInstanceFluentImpl<SubjectAccessReviewFluent.BrokerTemplateInstanceContentNested<N>> implements SubjectAccessReviewFluent.BrokerTemplateInstanceContentNested<N>,Nested<N>{
    BrokerTemplateInstanceContentNestedImpl(BrokerTemplateInstance item) {
      this.builder = new BrokerTemplateInstanceBuilder(this, item);
    }
    BrokerTemplateInstanceContentNestedImpl() {
      this.builder = new BrokerTemplateInstanceBuilder(this);
    }
    BrokerTemplateInstanceBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBrokerTemplateInstanceContent() {
      return and();
    }
    
  }
  class UserContentNestedImpl<N> extends UserFluentImpl<SubjectAccessReviewFluent.UserContentNested<N>> implements SubjectAccessReviewFluent.UserContentNested<N>,Nested<N>{
    UserContentNestedImpl(User item) {
      this.builder = new UserBuilder(this, item);
    }
    UserContentNestedImpl() {
      this.builder = new UserBuilder(this);
    }
    UserBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserContent() {
      return and();
    }
    
  }
  class ImageStreamImageContentNestedImpl<N> extends ImageStreamImageFluentImpl<SubjectAccessReviewFluent.ImageStreamImageContentNested<N>> implements SubjectAccessReviewFluent.ImageStreamImageContentNested<N>,Nested<N>{
    ImageStreamImageContentNestedImpl(ImageStreamImage item) {
      this.builder = new ImageStreamImageBuilder(this, item);
    }
    ImageStreamImageContentNestedImpl() {
      this.builder = new ImageStreamImageBuilder(this);
    }
    ImageStreamImageBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamImageContent() {
      return and();
    }
    
  }
  class TemplateInstanceContentNestedImpl<N> extends TemplateInstanceFluentImpl<SubjectAccessReviewFluent.TemplateInstanceContentNested<N>> implements SubjectAccessReviewFluent.TemplateInstanceContentNested<N>,Nested<N>{
    TemplateInstanceContentNestedImpl(TemplateInstance item) {
      this.builder = new TemplateInstanceBuilder(this, item);
    }
    TemplateInstanceContentNestedImpl() {
      this.builder = new TemplateInstanceBuilder(this);
    }
    TemplateInstanceBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateInstanceContent() {
      return and();
    }
    
  }
  class BuildContentNestedImpl<N> extends BuildFluentImpl<SubjectAccessReviewFluent.BuildContentNested<N>> implements SubjectAccessReviewFluent.BuildContentNested<N>,Nested<N>{
    BuildContentNestedImpl(Build item) {
      this.builder = new BuildBuilder(this, item);
    }
    BuildContentNestedImpl() {
      this.builder = new BuildBuilder(this);
    }
    BuildBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildContent() {
      return and();
    }
    
  }
  class RoleBindingRestrictionContentNestedImpl<N> extends RoleBindingRestrictionFluentImpl<SubjectAccessReviewFluent.RoleBindingRestrictionContentNested<N>> implements SubjectAccessReviewFluent.RoleBindingRestrictionContentNested<N>,Nested<N>{
    RoleBindingRestrictionContentNestedImpl(RoleBindingRestriction item) {
      this.builder = new RoleBindingRestrictionBuilder(this, item);
    }
    RoleBindingRestrictionContentNestedImpl() {
      this.builder = new RoleBindingRestrictionBuilder(this);
    }
    RoleBindingRestrictionBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleBindingRestrictionContent() {
      return and();
    }
    
  }
  class ImageStreamTagContentNestedImpl<N> extends ImageStreamTagFluentImpl<SubjectAccessReviewFluent.ImageStreamTagContentNested<N>> implements SubjectAccessReviewFluent.ImageStreamTagContentNested<N>,Nested<N>{
    ImageStreamTagContentNestedImpl(ImageStreamTag item) {
      this.builder = new ImageStreamTagBuilder(this, item);
    }
    ImageStreamTagContentNestedImpl() {
      this.builder = new ImageStreamTagBuilder(this);
    }
    ImageStreamTagBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamTagContent() {
      return and();
    }
    
  }
  class GroupContentNestedImpl<N> extends GroupFluentImpl<SubjectAccessReviewFluent.GroupContentNested<N>> implements SubjectAccessReviewFluent.GroupContentNested<N>,Nested<N>{
    GroupContentNestedImpl(Group item) {
      this.builder = new GroupBuilder(this, item);
    }
    GroupContentNestedImpl() {
      this.builder = new GroupBuilder(this);
    }
    GroupBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGroupContent() {
      return and();
    }
    
  }
  class ImageSignatureContentNestedImpl<N> extends ImageSignatureFluentImpl<SubjectAccessReviewFluent.ImageSignatureContentNested<N>> implements SubjectAccessReviewFluent.ImageSignatureContentNested<N>,Nested<N>{
    ImageSignatureContentNestedImpl(ImageSignature item) {
      this.builder = new ImageSignatureBuilder(this, item);
    }
    ImageSignatureContentNestedImpl() {
      this.builder = new ImageSignatureBuilder(this);
    }
    ImageSignatureBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageSignatureContent() {
      return and();
    }
    
  }
  class HostSubnetContentNestedImpl<N> extends HostSubnetFluentImpl<SubjectAccessReviewFluent.HostSubnetContentNested<N>> implements SubjectAccessReviewFluent.HostSubnetContentNested<N>,Nested<N>{
    HostSubnetContentNestedImpl(HostSubnet item) {
      this.builder = new HostSubnetBuilder(this, item);
    }
    HostSubnetContentNestedImpl() {
      this.builder = new HostSubnetBuilder(this);
    }
    HostSubnetBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endHostSubnetContent() {
      return and();
    }
    
  }
  class AppliedClusterResourceQuotaContentNestedImpl<N> extends AppliedClusterResourceQuotaFluentImpl<SubjectAccessReviewFluent.AppliedClusterResourceQuotaContentNested<N>> implements SubjectAccessReviewFluent.AppliedClusterResourceQuotaContentNested<N>,Nested<N>{
    AppliedClusterResourceQuotaContentNestedImpl(AppliedClusterResourceQuota item) {
      this.builder = new AppliedClusterResourceQuotaBuilder(this, item);
    }
    AppliedClusterResourceQuotaContentNestedImpl() {
      this.builder = new AppliedClusterResourceQuotaBuilder(this);
    }
    AppliedClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endAppliedClusterResourceQuotaContent() {
      return and();
    }
    
  }
  class SecurityContextConstraintsContentNestedImpl<N> extends SecurityContextConstraintsFluentImpl<SubjectAccessReviewFluent.SecurityContextConstraintsContentNested<N>> implements SubjectAccessReviewFluent.SecurityContextConstraintsContentNested<N>,Nested<N>{
    SecurityContextConstraintsContentNestedImpl(SecurityContextConstraints item) {
      this.builder = new SecurityContextConstraintsBuilder(this, item);
    }
    SecurityContextConstraintsContentNestedImpl() {
      this.builder = new SecurityContextConstraintsBuilder(this);
    }
    SecurityContextConstraintsBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSecurityContextConstraintsContent() {
      return and();
    }
    
  }
  class BuildRequestContentNestedImpl<N> extends BuildRequestFluentImpl<SubjectAccessReviewFluent.BuildRequestContentNested<N>> implements SubjectAccessReviewFluent.BuildRequestContentNested<N>,Nested<N>{
    BuildRequestContentNestedImpl(BuildRequest item) {
      this.builder = new BuildRequestBuilder(this, item);
    }
    BuildRequestContentNestedImpl() {
      this.builder = new BuildRequestBuilder(this);
    }
    BuildRequestBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildRequestContent() {
      return and();
    }
    
  }
  class EgressNetworkPolicyContentNestedImpl<N> extends EgressNetworkPolicyFluentImpl<SubjectAccessReviewFluent.EgressNetworkPolicyContentNested<N>> implements SubjectAccessReviewFluent.EgressNetworkPolicyContentNested<N>,Nested<N>{
    EgressNetworkPolicyContentNestedImpl(EgressNetworkPolicy item) {
      this.builder = new EgressNetworkPolicyBuilder(this, item);
    }
    EgressNetworkPolicyContentNestedImpl() {
      this.builder = new EgressNetworkPolicyBuilder(this);
    }
    EgressNetworkPolicyBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endEgressNetworkPolicyContent() {
      return and();
    }
    
  }
  class NetNamespaceContentNestedImpl<N> extends NetNamespaceFluentImpl<SubjectAccessReviewFluent.NetNamespaceContentNested<N>> implements SubjectAccessReviewFluent.NetNamespaceContentNested<N>,Nested<N>{
    NetNamespaceContentNestedImpl(NetNamespace item) {
      this.builder = new NetNamespaceBuilder(this, item);
    }
    NetNamespaceContentNestedImpl() {
      this.builder = new NetNamespaceBuilder(this);
    }
    NetNamespaceBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endNetNamespaceContent() {
      return and();
    }
    
  }
  class UserIdentityMappingContentNestedImpl<N> extends UserIdentityMappingFluentImpl<SubjectAccessReviewFluent.UserIdentityMappingContentNested<N>> implements SubjectAccessReviewFluent.UserIdentityMappingContentNested<N>,Nested<N>{
    UserIdentityMappingContentNestedImpl(UserIdentityMapping item) {
      this.builder = new UserIdentityMappingBuilder(this, item);
    }
    UserIdentityMappingContentNestedImpl() {
      this.builder = new UserIdentityMappingBuilder(this);
    }
    UserIdentityMappingBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserIdentityMappingContent() {
      return and();
    }
    
  }
  class ImageStreamContentNestedImpl<N> extends ImageStreamFluentImpl<SubjectAccessReviewFluent.ImageStreamContentNested<N>> implements SubjectAccessReviewFluent.ImageStreamContentNested<N>,Nested<N>{
    ImageStreamContentNestedImpl(ImageStream item) {
      this.builder = new ImageStreamBuilder(this, item);
    }
    ImageStreamContentNestedImpl() {
      this.builder = new ImageStreamBuilder(this);
    }
    ImageStreamBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamContent() {
      return and();
    }
    
  }
  class OAuthClientContentNestedImpl<N> extends OAuthClientFluentImpl<SubjectAccessReviewFluent.OAuthClientContentNested<N>> implements SubjectAccessReviewFluent.OAuthClientContentNested<N>,Nested<N>{
    OAuthClientContentNestedImpl(OAuthClient item) {
      this.builder = new OAuthClientBuilder(this, item);
    }
    OAuthClientContentNestedImpl() {
      this.builder = new OAuthClientBuilder(this);
    }
    OAuthClientBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthClientContent() {
      return and();
    }
    
  }
  class IdentityContentNestedImpl<N> extends IdentityFluentImpl<SubjectAccessReviewFluent.IdentityContentNested<N>> implements SubjectAccessReviewFluent.IdentityContentNested<N>,Nested<N>{
    IdentityContentNestedImpl(Identity item) {
      this.builder = new IdentityBuilder(this, item);
    }
    IdentityContentNestedImpl() {
      this.builder = new IdentityBuilder(this);
    }
    IdentityBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endIdentityContent() {
      return and();
    }
    
  }
  
}