package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;

 /**
  * Generated
  */
public interface PolicyRuleFluent<A extends PolicyRuleFluent<A>> extends Fluent<A>{
  public A addToApiGroups(Integer index,String item);
  public A setToApiGroups(Integer index,String item);
  public A addToApiGroups(java.lang.String... items);
  public A addAllToApiGroups(Collection<String> items);
  public A removeFromApiGroups(java.lang.String... items);
  public A removeAllFromApiGroups(Collection<String> items);
  public List<String> getApiGroups();
  public String getApiGroup(Integer index);
  public String getFirstApiGroup();
  public String getLastApiGroup();
  public String getMatchingApiGroup(Predicate<String> predicate);
  public Boolean hasMatchingApiGroup(Predicate<String> predicate);
  public A withApiGroups(List<String> apiGroups);
  public A withApiGroups(java.lang.String... apiGroups);
  public Boolean hasApiGroups();
  
  /**
   * This method has been deprecated, please use method buildAttributeRestrictions instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getAttributeRestrictions();
  public HasMetadata buildAttributeRestrictions();
  public A withAttributeRestrictions(HasMetadata attributeRestrictions);
  public Boolean hasAttributeRestrictions();
  public A withImageStreamImportAttributeRestrictions(ImageStreamImport imageStreamImportAttributeRestrictions);
  public PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictions();
  public PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictionsLike(ImageStreamImport item);
  public A withProjectAttributeRestrictions(Project projectAttributeRestrictions);
  public PolicyRuleFluent.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictions();
  public PolicyRuleFluent.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictionsLike(Project item);
  public A withBuildConfigAttributeRestrictions(BuildConfig buildConfigAttributeRestrictions);
  public PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictions();
  public PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictionsLike(BuildConfig item);
  public A withHelmChartRepositoryAttributeRestrictions(HelmChartRepository helmChartRepositoryAttributeRestrictions);
  public PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<A> withNewHelmChartRepositoryAttributeRestrictions();
  public PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<A> withNewHelmChartRepositoryAttributeRestrictionsLike(HelmChartRepository item);
  public A withRangeAllocationAttributeRestrictions(RangeAllocation rangeAllocationAttributeRestrictions);
  public PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictions();
  public PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictionsLike(RangeAllocation item);
  public A withRouteAttributeRestrictions(Route routeAttributeRestrictions);
  public PolicyRuleFluent.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictions();
  public PolicyRuleFluent.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictionsLike(Route item);
  public A withClusterNetworkAttributeRestrictions(ClusterNetwork clusterNetworkAttributeRestrictions);
  public PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictions();
  public PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictionsLike(ClusterNetwork item);
  public A withOAuthAuthorizeTokenAttributeRestrictions(OAuthAuthorizeToken oAuthAuthorizeTokenAttributeRestrictions);
  public PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictions();
  public PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictionsLike(OAuthAuthorizeToken item);
  public A withUserOAuthAccessTokenAttributeRestrictions(UserOAuthAccessToken userOAuthAccessTokenAttributeRestrictions);
  public PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenAttributeRestrictions();
  public PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenAttributeRestrictionsLike(UserOAuthAccessToken item);
  public A withClusterRoleBindingAttributeRestrictions(ClusterRoleBinding clusterRoleBindingAttributeRestrictions);
  public PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictions();
  public PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictionsLike(ClusterRoleBinding item);
  public A withClusterResourceQuotaAttributeRestrictions(ClusterResourceQuota clusterResourceQuotaAttributeRestrictions);
  public PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictions();
  public PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictionsLike(ClusterResourceQuota item);
  public A withProjectRequestAttributeRestrictions(ProjectRequest projectRequestAttributeRestrictions);
  public PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictions();
  public PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictionsLike(ProjectRequest item);
  public A withTemplateAttributeRestrictions(Template templateAttributeRestrictions);
  public PolicyRuleFluent.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictions();
  public PolicyRuleFluent.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictionsLike(Template item);
  public A withOAuthClientAuthorizationAttributeRestrictions(OAuthClientAuthorization oAuthClientAuthorizationAttributeRestrictions);
  public PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictions();
  public PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictionsLike(OAuthClientAuthorization item);
  public A withClusterRoleAttributeRestrictions(ClusterRole clusterRoleAttributeRestrictions);
  public PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictions();
  public PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictionsLike(ClusterRole item);
  public A withImageTagAttributeRestrictions(ImageTag imageTagAttributeRestrictions);
  public PolicyRuleFluent.ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictions();
  public PolicyRuleFluent.ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictionsLike(ImageTag item);
  public A withOAuthAccessTokenAttributeRestrictions(OAuthAccessToken oAuthAccessTokenAttributeRestrictions);
  public PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictions();
  public PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictionsLike(OAuthAccessToken item);
  public A withDeploymentConfigAttributeRestrictions(DeploymentConfig deploymentConfigAttributeRestrictions);
  public PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictions();
  public PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictionsLike(DeploymentConfig item);
  public A withRoleBindingAttributeRestrictions(RoleBinding roleBindingAttributeRestrictions);
  public PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictions();
  public PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictionsLike(RoleBinding item);
  public A withImageAttributeRestrictions(Image imageAttributeRestrictions);
  public PolicyRuleFluent.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictions();
  public PolicyRuleFluent.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictionsLike(Image item);
  public A withPersistentVolumeClaimAttributeRestrictions(PersistentVolumeClaim persistentVolumeClaimAttributeRestrictions);
  public PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictions();
  public PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictionsLike(PersistentVolumeClaim item);
  public A withImageStreamMappingAttributeRestrictions(ImageStreamMapping imageStreamMappingAttributeRestrictions);
  public PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictions();
  public PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictionsLike(ImageStreamMapping item);
  public A withRoleAttributeRestrictions(Role roleAttributeRestrictions);
  public PolicyRuleFluent.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictions();
  public PolicyRuleFluent.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictionsLike(Role item);
  public A withBrokerTemplateInstanceAttributeRestrictions(BrokerTemplateInstance brokerTemplateInstanceAttributeRestrictions);
  public PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceAttributeRestrictions();
  public PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceAttributeRestrictionsLike(BrokerTemplateInstance item);
  public A withUserAttributeRestrictions(User userAttributeRestrictions);
  public PolicyRuleFluent.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictions();
  public PolicyRuleFluent.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictionsLike(User item);
  public A withImageStreamImageAttributeRestrictions(ImageStreamImage imageStreamImageAttributeRestrictions);
  public PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictions();
  public PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictionsLike(ImageStreamImage item);
  public A withTemplateInstanceAttributeRestrictions(TemplateInstance templateInstanceAttributeRestrictions);
  public PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<A> withNewTemplateInstanceAttributeRestrictions();
  public PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<A> withNewTemplateInstanceAttributeRestrictionsLike(TemplateInstance item);
  public A withBuildAttributeRestrictions(Build buildAttributeRestrictions);
  public PolicyRuleFluent.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictions();
  public PolicyRuleFluent.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictionsLike(Build item);
  public A withRoleBindingRestrictionAttributeRestrictions(RoleBindingRestriction roleBindingRestrictionAttributeRestrictions);
  public PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictions();
  public PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictionsLike(RoleBindingRestriction item);
  public A withImageStreamTagAttributeRestrictions(ImageStreamTag imageStreamTagAttributeRestrictions);
  public PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictions();
  public PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictionsLike(ImageStreamTag item);
  public A withGroupAttributeRestrictions(Group groupAttributeRestrictions);
  public PolicyRuleFluent.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictions();
  public PolicyRuleFluent.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictionsLike(Group item);
  public A withImageSignatureAttributeRestrictions(ImageSignature imageSignatureAttributeRestrictions);
  public PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictions();
  public PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictionsLike(ImageSignature item);
  public A withHostSubnetAttributeRestrictions(HostSubnet hostSubnetAttributeRestrictions);
  public PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<A> withNewHostSubnetAttributeRestrictions();
  public PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<A> withNewHostSubnetAttributeRestrictionsLike(HostSubnet item);
  public A withAppliedClusterResourceQuotaAttributeRestrictions(AppliedClusterResourceQuota appliedClusterResourceQuotaAttributeRestrictions);
  public PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictions();
  public PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictionsLike(AppliedClusterResourceQuota item);
  public A withSecurityContextConstraintsAttributeRestrictions(SecurityContextConstraints securityContextConstraintsAttributeRestrictions);
  public PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictions();
  public PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictionsLike(SecurityContextConstraints item);
  public A withBuildRequestAttributeRestrictions(BuildRequest buildRequestAttributeRestrictions);
  public PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictions();
  public PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictionsLike(BuildRequest item);
  public A withEgressNetworkPolicyAttributeRestrictions(EgressNetworkPolicy egressNetworkPolicyAttributeRestrictions);
  public PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictions();
  public PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictionsLike(EgressNetworkPolicy item);
  public A withNetNamespaceAttributeRestrictions(NetNamespace netNamespaceAttributeRestrictions);
  public PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictions();
  public PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictionsLike(NetNamespace item);
  public A withUserIdentityMappingAttributeRestrictions(UserIdentityMapping userIdentityMappingAttributeRestrictions);
  public PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<A> withNewUserIdentityMappingAttributeRestrictions();
  public PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<A> withNewUserIdentityMappingAttributeRestrictionsLike(UserIdentityMapping item);
  public A withImageStreamAttributeRestrictions(ImageStream imageStreamAttributeRestrictions);
  public PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictions();
  public PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictionsLike(ImageStream item);
  public A withOAuthClientAttributeRestrictions(OAuthClient oAuthClientAttributeRestrictions);
  public PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictions();
  public PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictionsLike(OAuthClient item);
  public A withIdentityAttributeRestrictions(Identity identityAttributeRestrictions);
  public PolicyRuleFluent.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictions();
  public PolicyRuleFluent.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictionsLike(Identity item);
  public A addToNonResourceURLs(Integer index,String item);
  public A setToNonResourceURLs(Integer index,String item);
  public A addToNonResourceURLs(java.lang.String... items);
  public A addAllToNonResourceURLs(Collection<String> items);
  public A removeFromNonResourceURLs(java.lang.String... items);
  public A removeAllFromNonResourceURLs(Collection<String> items);
  public List<String> getNonResourceURLs();
  public String getNonResourceURL(Integer index);
  public String getFirstNonResourceURL();
  public String getLastNonResourceURL();
  public String getMatchingNonResourceURL(Predicate<String> predicate);
  public Boolean hasMatchingNonResourceURL(Predicate<String> predicate);
  public A withNonResourceURLs(List<String> nonResourceURLs);
  public A withNonResourceURLs(java.lang.String... nonResourceURLs);
  public Boolean hasNonResourceURLs();
  public A addToResourceNames(Integer index,String item);
  public A setToResourceNames(Integer index,String item);
  public A addToResourceNames(java.lang.String... items);
  public A addAllToResourceNames(Collection<String> items);
  public A removeFromResourceNames(java.lang.String... items);
  public A removeAllFromResourceNames(Collection<String> items);
  public List<String> getResourceNames();
  public String getResourceName(Integer index);
  public String getFirstResourceName();
  public String getLastResourceName();
  public String getMatchingResourceName(Predicate<String> predicate);
  public Boolean hasMatchingResourceName(Predicate<String> predicate);
  public A withResourceNames(List<String> resourceNames);
  public A withResourceNames(java.lang.String... resourceNames);
  public Boolean hasResourceNames();
  public A addToResources(Integer index,String item);
  public A setToResources(Integer index,String item);
  public A addToResources(java.lang.String... items);
  public A addAllToResources(Collection<String> items);
  public A removeFromResources(java.lang.String... items);
  public A removeAllFromResources(Collection<String> items);
  public List<String> getResources();
  public String getResource(Integer index);
  public String getFirstResource();
  public String getLastResource();
  public String getMatchingResource(Predicate<String> predicate);
  public Boolean hasMatchingResource(Predicate<String> predicate);
  public A withResources(List<String> resources);
  public A withResources(java.lang.String... resources);
  public Boolean hasResources();
  public A addToVerbs(Integer index,String item);
  public A setToVerbs(Integer index,String item);
  public A addToVerbs(java.lang.String... items);
  public A addAllToVerbs(Collection<String> items);
  public A removeFromVerbs(java.lang.String... items);
  public A removeAllFromVerbs(Collection<String> items);
  public List<String> getVerbs();
  public String getVerb(Integer index);
  public String getFirstVerb();
  public String getLastVerb();
  public String getMatchingVerb(Predicate<String> predicate);
  public Boolean hasMatchingVerb(Predicate<String> predicate);
  public A withVerbs(List<String> verbs);
  public A withVerbs(java.lang.String... verbs);
  public Boolean hasVerbs();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ImageStreamImportAttributeRestrictionsNested<N> extends Nested<N>,ImageStreamImportFluent<PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<N>>{
    public N and();
    public N endImageStreamImportAttributeRestrictions();
    
  }
  public interface ProjectAttributeRestrictionsNested<N> extends Nested<N>,ProjectFluent<PolicyRuleFluent.ProjectAttributeRestrictionsNested<N>>{
    public N and();
    public N endProjectAttributeRestrictions();
    
  }
  public interface BuildConfigAttributeRestrictionsNested<N> extends Nested<N>,BuildConfigFluent<PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<N>>{
    public N and();
    public N endBuildConfigAttributeRestrictions();
    
  }
  public interface HelmChartRepositoryAttributeRestrictionsNested<N> extends Nested<N>,HelmChartRepositoryFluent<PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<N>>{
    public N and();
    public N endHelmChartRepositoryAttributeRestrictions();
    
  }
  public interface RangeAllocationAttributeRestrictionsNested<N> extends Nested<N>,RangeAllocationFluent<PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<N>>{
    public N and();
    public N endRangeAllocationAttributeRestrictions();
    
  }
  public interface RouteAttributeRestrictionsNested<N> extends Nested<N>,RouteFluent<PolicyRuleFluent.RouteAttributeRestrictionsNested<N>>{
    public N and();
    public N endRouteAttributeRestrictions();
    
  }
  public interface ClusterNetworkAttributeRestrictionsNested<N> extends Nested<N>,ClusterNetworkFluent<PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<N>>{
    public N and();
    public N endClusterNetworkAttributeRestrictions();
    
  }
  public interface OAuthAuthorizeTokenAttributeRestrictionsNested<N> extends Nested<N>,OAuthAuthorizeTokenFluent<PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<N>>{
    public N and();
    public N endOAuthAuthorizeTokenAttributeRestrictions();
    
  }
  public interface UserOAuthAccessTokenAttributeRestrictionsNested<N> extends Nested<N>,UserOAuthAccessTokenFluent<PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<N>>{
    public N and();
    public N endUserOAuthAccessTokenAttributeRestrictions();
    
  }
  public interface ClusterRoleBindingAttributeRestrictionsNested<N> extends Nested<N>,ClusterRoleBindingFluent<PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<N>>{
    public N and();
    public N endClusterRoleBindingAttributeRestrictions();
    
  }
  public interface ClusterResourceQuotaAttributeRestrictionsNested<N> extends Nested<N>,ClusterResourceQuotaFluent<PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<N>>{
    public N and();
    public N endClusterResourceQuotaAttributeRestrictions();
    
  }
  public interface ProjectRequestAttributeRestrictionsNested<N> extends Nested<N>,ProjectRequestFluent<PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<N>>{
    public N and();
    public N endProjectRequestAttributeRestrictions();
    
  }
  public interface TemplateAttributeRestrictionsNested<N> extends Nested<N>,TemplateFluent<PolicyRuleFluent.TemplateAttributeRestrictionsNested<N>>{
    public N and();
    public N endTemplateAttributeRestrictions();
    
  }
  public interface OAuthClientAuthorizationAttributeRestrictionsNested<N> extends Nested<N>,OAuthClientAuthorizationFluent<PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<N>>{
    public N and();
    public N endOAuthClientAuthorizationAttributeRestrictions();
    
  }
  public interface ClusterRoleAttributeRestrictionsNested<N> extends Nested<N>,ClusterRoleFluent<PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<N>>{
    public N and();
    public N endClusterRoleAttributeRestrictions();
    
  }
  public interface ImageTagAttributeRestrictionsNested<N> extends Nested<N>,ImageTagFluent<PolicyRuleFluent.ImageTagAttributeRestrictionsNested<N>>{
    public N and();
    public N endImageTagAttributeRestrictions();
    
  }
  public interface OAuthAccessTokenAttributeRestrictionsNested<N> extends Nested<N>,OAuthAccessTokenFluent<PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<N>>{
    public N and();
    public N endOAuthAccessTokenAttributeRestrictions();
    
  }
  public interface DeploymentConfigAttributeRestrictionsNested<N> extends Nested<N>,DeploymentConfigFluent<PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<N>>{
    public N and();
    public N endDeploymentConfigAttributeRestrictions();
    
  }
  public interface RoleBindingAttributeRestrictionsNested<N> extends Nested<N>,RoleBindingFluent<PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<N>>{
    public N and();
    public N endRoleBindingAttributeRestrictions();
    
  }
  public interface ImageAttributeRestrictionsNested<N> extends Nested<N>,ImageFluent<PolicyRuleFluent.ImageAttributeRestrictionsNested<N>>{
    public N and();
    public N endImageAttributeRestrictions();
    
  }
  public interface PersistentVolumeClaimAttributeRestrictionsNested<N> extends Nested<N>,PersistentVolumeClaimFluent<PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<N>>{
    public N and();
    public N endPersistentVolumeClaimAttributeRestrictions();
    
  }
  public interface ImageStreamMappingAttributeRestrictionsNested<N> extends Nested<N>,ImageStreamMappingFluent<PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<N>>{
    public N and();
    public N endImageStreamMappingAttributeRestrictions();
    
  }
  public interface RoleAttributeRestrictionsNested<N> extends Nested<N>,RoleFluent<PolicyRuleFluent.RoleAttributeRestrictionsNested<N>>{
    public N and();
    public N endRoleAttributeRestrictions();
    
  }
  public interface BrokerTemplateInstanceAttributeRestrictionsNested<N> extends Nested<N>,BrokerTemplateInstanceFluent<PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<N>>{
    public N and();
    public N endBrokerTemplateInstanceAttributeRestrictions();
    
  }
  public interface UserAttributeRestrictionsNested<N> extends Nested<N>,UserFluent<PolicyRuleFluent.UserAttributeRestrictionsNested<N>>{
    public N and();
    public N endUserAttributeRestrictions();
    
  }
  public interface ImageStreamImageAttributeRestrictionsNested<N> extends Nested<N>,ImageStreamImageFluent<PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<N>>{
    public N and();
    public N endImageStreamImageAttributeRestrictions();
    
  }
  public interface TemplateInstanceAttributeRestrictionsNested<N> extends Nested<N>,TemplateInstanceFluent<PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<N>>{
    public N and();
    public N endTemplateInstanceAttributeRestrictions();
    
  }
  public interface BuildAttributeRestrictionsNested<N> extends Nested<N>,BuildFluent<PolicyRuleFluent.BuildAttributeRestrictionsNested<N>>{
    public N and();
    public N endBuildAttributeRestrictions();
    
  }
  public interface RoleBindingRestrictionAttributeRestrictionsNested<N> extends Nested<N>,RoleBindingRestrictionFluent<PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<N>>{
    public N and();
    public N endRoleBindingRestrictionAttributeRestrictions();
    
  }
  public interface ImageStreamTagAttributeRestrictionsNested<N> extends Nested<N>,ImageStreamTagFluent<PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<N>>{
    public N and();
    public N endImageStreamTagAttributeRestrictions();
    
  }
  public interface GroupAttributeRestrictionsNested<N> extends Nested<N>,GroupFluent<PolicyRuleFluent.GroupAttributeRestrictionsNested<N>>{
    public N and();
    public N endGroupAttributeRestrictions();
    
  }
  public interface ImageSignatureAttributeRestrictionsNested<N> extends Nested<N>,ImageSignatureFluent<PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<N>>{
    public N and();
    public N endImageSignatureAttributeRestrictions();
    
  }
  public interface HostSubnetAttributeRestrictionsNested<N> extends Nested<N>,HostSubnetFluent<PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<N>>{
    public N and();
    public N endHostSubnetAttributeRestrictions();
    
  }
  public interface AppliedClusterResourceQuotaAttributeRestrictionsNested<N> extends Nested<N>,AppliedClusterResourceQuotaFluent<PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<N>>{
    public N and();
    public N endAppliedClusterResourceQuotaAttributeRestrictions();
    
  }
  public interface SecurityContextConstraintsAttributeRestrictionsNested<N> extends Nested<N>,SecurityContextConstraintsFluent<PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<N>>{
    public N and();
    public N endSecurityContextConstraintsAttributeRestrictions();
    
  }
  public interface BuildRequestAttributeRestrictionsNested<N> extends Nested<N>,BuildRequestFluent<PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<N>>{
    public N and();
    public N endBuildRequestAttributeRestrictions();
    
  }
  public interface EgressNetworkPolicyAttributeRestrictionsNested<N> extends Nested<N>,EgressNetworkPolicyFluent<PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<N>>{
    public N and();
    public N endEgressNetworkPolicyAttributeRestrictions();
    
  }
  public interface NetNamespaceAttributeRestrictionsNested<N> extends Nested<N>,NetNamespaceFluent<PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<N>>{
    public N and();
    public N endNetNamespaceAttributeRestrictions();
    
  }
  public interface UserIdentityMappingAttributeRestrictionsNested<N> extends Nested<N>,UserIdentityMappingFluent<PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<N>>{
    public N and();
    public N endUserIdentityMappingAttributeRestrictions();
    
  }
  public interface ImageStreamAttributeRestrictionsNested<N> extends Nested<N>,ImageStreamFluent<PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<N>>{
    public N and();
    public N endImageStreamAttributeRestrictions();
    
  }
  public interface OAuthClientAttributeRestrictionsNested<N> extends Nested<N>,OAuthClientFluent<PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<N>>{
    public N and();
    public N endOAuthClientAttributeRestrictions();
    
  }
  public interface IdentityAttributeRestrictionsNested<N> extends Nested<N>,IdentityFluent<PolicyRuleFluent.IdentityAttributeRestrictionsNested<N>>{
    public N and();
    public N endIdentityAttributeRestrictions();
    
  }
  
}