package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UserIdentityMappingBuilder extends UserIdentityMappingFluentImpl<UserIdentityMappingBuilder> implements VisitableBuilder<UserIdentityMapping,UserIdentityMappingBuilder>{
  public UserIdentityMappingBuilder() {
    this(false);
  }
  public UserIdentityMappingBuilder(Boolean validationEnabled) {
    this(new UserIdentityMapping(), validationEnabled);
  }
  public UserIdentityMappingBuilder(UserIdentityMappingFluent<?> fluent) {
    this(fluent, false);
  }
  public UserIdentityMappingBuilder(UserIdentityMappingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new UserIdentityMapping(), validationEnabled);
  }
  public UserIdentityMappingBuilder(UserIdentityMappingFluent<?> fluent,UserIdentityMapping instance) {
    this(fluent, instance, false);
  }
  public UserIdentityMappingBuilder(UserIdentityMappingFluent<?> fluent,UserIdentityMapping instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withIdentity(instance.getIdentity()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withUser(instance.getUser()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public UserIdentityMappingBuilder(UserIdentityMapping instance) {
    this(instance,false);
  }
  public UserIdentityMappingBuilder(UserIdentityMapping instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withIdentity(instance.getIdentity()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withUser(instance.getUser()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  UserIdentityMappingFluent<?> fluent;
  Boolean validationEnabled;
  public UserIdentityMapping build() {
    UserIdentityMapping buildable = new UserIdentityMapping(fluent.getApiVersion(),fluent.getIdentity(),fluent.getKind(),fluent.getMetadata(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}