package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ImageChangeTriggerStatusFluent<A extends ImageChangeTriggerStatusFluent<A>> extends BaseFluent<A>{
  public ImageChangeTriggerStatusFluent() {
  }
  
  public ImageChangeTriggerStatusFluent(ImageChangeTriggerStatus instance) {
    this.copyInstance(instance);
  }
  private ImageStreamTagReferenceBuilder from;
  private String lastTriggerTime;
  private String lastTriggeredImageID;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ImageChangeTriggerStatus instance) {
    instance = (instance != null ? instance : new ImageChangeTriggerStatus());
    if (instance != null) {
          this.withFrom(instance.getFrom());
          this.withLastTriggerTime(instance.getLastTriggerTime());
          this.withLastTriggeredImageID(instance.getLastTriggeredImageID());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ImageStreamTagReference buildFrom() {
    return this.from != null ? this.from.build() : null;
  }
  
  public A withFrom(ImageStreamTagReference from) {
    this._visitables.remove("from");
    if (from != null) {
        this.from = new ImageStreamTagReferenceBuilder(from);
        this._visitables.get("from").add(this.from);
    } else {
        this.from = null;
        this._visitables.get("from").remove(this.from);
    }
    return (A) this;
  }
  
  public boolean hasFrom() {
    return this.from != null;
  }
  
  public A withNewFrom(String name,String namespace) {
    return (A)withFrom(new ImageStreamTagReference(name, namespace));
  }
  
  public FromNested<A> withNewFrom() {
    return new FromNested(null);
  }
  
  public FromNested<A> withNewFromLike(ImageStreamTagReference item) {
    return new FromNested(item);
  }
  
  public FromNested<A> editFrom() {
    return withNewFromLike(java.util.Optional.ofNullable(buildFrom()).orElse(null));
  }
  
  public FromNested<A> editOrNewFrom() {
    return withNewFromLike(java.util.Optional.ofNullable(buildFrom()).orElse(new ImageStreamTagReferenceBuilder().build()));
  }
  
  public FromNested<A> editOrNewFromLike(ImageStreamTagReference item) {
    return withNewFromLike(java.util.Optional.ofNullable(buildFrom()).orElse(item));
  }
  
  public String getLastTriggerTime() {
    return this.lastTriggerTime;
  }
  
  public A withLastTriggerTime(String lastTriggerTime) {
    this.lastTriggerTime = lastTriggerTime;
    return (A) this;
  }
  
  public boolean hasLastTriggerTime() {
    return this.lastTriggerTime != null;
  }
  
  public String getLastTriggeredImageID() {
    return this.lastTriggeredImageID;
  }
  
  public A withLastTriggeredImageID(String lastTriggeredImageID) {
    this.lastTriggeredImageID = lastTriggeredImageID;
    return (A) this;
  }
  
  public boolean hasLastTriggeredImageID() {
    return this.lastTriggeredImageID != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageChangeTriggerStatusFluent that = (ImageChangeTriggerStatusFluent) o;
    if (!java.util.Objects.equals(from, that.from)) return false;
    if (!java.util.Objects.equals(lastTriggerTime, that.lastTriggerTime)) return false;
    if (!java.util.Objects.equals(lastTriggeredImageID, that.lastTriggeredImageID)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(from,  lastTriggerTime,  lastTriggeredImageID,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (from != null) { sb.append("from:"); sb.append(from + ","); }
    if (lastTriggerTime != null) { sb.append("lastTriggerTime:"); sb.append(lastTriggerTime + ","); }
    if (lastTriggeredImageID != null) { sb.append("lastTriggeredImageID:"); sb.append(lastTriggeredImageID + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FromNested<N> extends ImageStreamTagReferenceFluent<FromNested<N>> implements Nested<N>{
    FromNested(ImageStreamTagReference item) {
      this.builder = new ImageStreamTagReferenceBuilder(this, item);
    }
    ImageStreamTagReferenceBuilder builder;
    
    public N and() {
      return (N) ImageChangeTriggerStatusFluent.this.withFrom(builder.build());
    }
    
    public N endFrom() {
      return and();
    }
    
  
  }

}