package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WebHookTriggerBuilder extends WebHookTriggerFluent<WebHookTriggerBuilder> implements VisitableBuilder<WebHookTrigger,WebHookTriggerBuilder>{
  public WebHookTriggerBuilder() {
    this(new WebHookTrigger());
  }
  
  public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent) {
    this(fluent, new WebHookTrigger());
  }
  
  public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent,WebHookTrigger instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WebHookTriggerBuilder(WebHookTrigger instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WebHookTriggerFluent<?> fluent;
  
  public WebHookTrigger build() {
    WebHookTrigger buildable = new WebHookTrigger(fluent.getAllowEnv(),fluent.getSecret(),fluent.buildSecretReference());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}