package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GroupBuilder extends GroupFluent<GroupBuilder> implements VisitableBuilder<Group,GroupBuilder>{
  public GroupBuilder() {
    this(new Group());
  }
  
  public GroupBuilder(GroupFluent<?> fluent) {
    this(fluent, new Group());
  }
  
  public GroupBuilder(GroupFluent<?> fluent,Group instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GroupBuilder(Group instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GroupFluent<?> fluent;
  
  public Group build() {
    Group buildable = new Group(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.getUsers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}