package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DeploymentConfigSpecFluentImpl<A extends DeploymentConfigSpecFluent<A>> extends BaseFluent<A> implements DeploymentConfigSpecFluent<A>{
  public DeploymentConfigSpecFluentImpl() {
  }
  public DeploymentConfigSpecFluentImpl(DeploymentConfigSpec instance) {
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withPaused(instance.getPaused()); 
    this.withReplicas(instance.getReplicas()); 
    this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    this.withSelector(instance.getSelector()); 
    this.withStrategy(instance.getStrategy()); 
    this.withTemplate(instance.getTemplate()); 
    this.withTest(instance.getTest()); 
    this.withTriggers(instance.getTriggers()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer minReadySeconds;
  private Boolean paused;
  private Integer replicas;
  private Integer revisionHistoryLimit;
  private Map<String,String> selector;
  private DeploymentStrategyBuilder strategy;
  private PodTemplateSpecBuilder template;
  private Boolean test;
  private ArrayList<DeploymentTriggerPolicyBuilder> triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();
  private Map<String,Object> additionalProperties;
  public Integer getMinReadySeconds() {
    return this.minReadySeconds;
  }
  public A withMinReadySeconds(Integer minReadySeconds) {
    this.minReadySeconds=minReadySeconds; return (A) this;
  }
  public Boolean hasMinReadySeconds() {
    return this.minReadySeconds != null;
  }
  public Boolean getPaused() {
    return this.paused;
  }
  public A withPaused(Boolean paused) {
    this.paused=paused; return (A) this;
  }
  public Boolean hasPaused() {
    return this.paused != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  public Integer getRevisionHistoryLimit() {
    return this.revisionHistoryLimit;
  }
  public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
    this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
  }
  public Boolean hasRevisionHistoryLimit() {
    return this.revisionHistoryLimit != null;
  }
  public A addToSelector(String key,String value) {
    if(this.selector == null && key != null && value != null) { this.selector = new LinkedHashMap(); }
    if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
  }
  public A addToSelector(Map<String,String> map) {
    if(this.selector == null && map != null) { this.selector = new LinkedHashMap(); }
    if(map != null) { this.selector.putAll(map);} return (A)this;
  }
  public A removeFromSelector(String key) {
    if(this.selector == null) { return (A) this; }
    if(key != null && this.selector != null) {this.selector.remove(key);} return (A)this;
  }
  public A removeFromSelector(Map<String,String> map) {
    if(this.selector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.selector != null){this.selector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getSelector() {
    return this.selector;
  }
  public <K,V>A withSelector(Map<String,String> selector) {
    if (selector == null) { this.selector =  null;} else {this.selector = new LinkedHashMap(selector);} return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  
  /**
   * This method has been deprecated, please use method buildStrategy instead.
   * @return The buildable object.
   */
  @Deprecated
  public DeploymentStrategy getStrategy() {
    return this.strategy!=null ?this.strategy.build():null;
  }
  public DeploymentStrategy buildStrategy() {
    return this.strategy!=null ?this.strategy.build():null;
  }
  public A withStrategy(DeploymentStrategy strategy) {
    _visitables.get("strategy").remove(this.strategy);
    if (strategy!=null){ this.strategy= new DeploymentStrategyBuilder(strategy); _visitables.get("strategy").add(this.strategy);} else { this.strategy = null; _visitables.get("strategy").remove(this.strategy); } return (A) this;
  }
  public Boolean hasStrategy() {
    return this.strategy != null;
  }
  public DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategy() {
    return new DeploymentConfigSpecFluentImpl.StrategyNestedImpl();
  }
  public DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategyLike(DeploymentStrategy item) {
    return new DeploymentConfigSpecFluentImpl.StrategyNestedImpl(item);
  }
  public DeploymentConfigSpecFluent.StrategyNested<A> editStrategy() {
    return withNewStrategyLike(getStrategy());
  }
  public DeploymentConfigSpecFluent.StrategyNested<A> editOrNewStrategy() {
    return withNewStrategyLike(getStrategy() != null ? getStrategy(): new DeploymentStrategyBuilder().build());
  }
  public DeploymentConfigSpecFluent.StrategyNested<A> editOrNewStrategyLike(DeploymentStrategy item) {
    return withNewStrategyLike(getStrategy() != null ? getStrategy(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodTemplateSpec getTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public PodTemplateSpec buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(PodTemplateSpec template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public Boolean hasTemplate() {
    return this.template != null;
  }
  public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplate() {
    return new DeploymentConfigSpecFluentImpl.TemplateNestedImpl();
  }
  public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
    return new DeploymentConfigSpecFluentImpl.TemplateNestedImpl(item);
  }
  public DeploymentConfigSpecFluent.TemplateNested<A> editTemplate() {
    return withNewTemplateLike(getTemplate());
  }
  public DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): new PodTemplateSpecBuilder().build());
  }
  public DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
  }
  public Boolean getTest() {
    return this.test;
  }
  public A withTest(Boolean test) {
    this.test=test; return (A) this;
  }
  public Boolean hasTest() {
    return this.test != null;
  }
  public A addToTriggers(Integer index,DeploymentTriggerPolicy item) {
    if (this.triggers == null) {this.triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();}
    DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);_visitables.get("triggers").add(index >= 0 ? index : _visitables.get("triggers").size(), builder);this.triggers.add(index >= 0 ? index : triggers.size(), builder); return (A)this;
  }
  public A setToTriggers(Integer index,DeploymentTriggerPolicy item) {
    if (this.triggers == null) {this.triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();}
    DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
    if (index < 0 || index >= _visitables.get("triggers").size()) { _visitables.get("triggers").add(builder); } else { _visitables.get("triggers").set(index, builder);}
    if (index < 0 || index >= triggers.size()) { triggers.add(builder); } else { triggers.set(index, builder);}
     return (A)this;
  }
  public A addToTriggers(io.fabric8.openshift.api.model.DeploymentTriggerPolicy... items) {
    if (this.triggers == null) {this.triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();}
    for (DeploymentTriggerPolicy item : items) {DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
  }
  public A addAllToTriggers(Collection<DeploymentTriggerPolicy> items) {
    if (this.triggers == null) {this.triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();}
    for (DeploymentTriggerPolicy item : items) {DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
  }
  public A removeFromTriggers(io.fabric8.openshift.api.model.DeploymentTriggerPolicy... items) {
    for (DeploymentTriggerPolicy item : items) {DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
  }
  public A removeAllFromTriggers(Collection<DeploymentTriggerPolicy> items) {
    for (DeploymentTriggerPolicy item : items) {DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTriggers(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
    if (triggers == null) return (A) this;
    final Iterator<DeploymentTriggerPolicyBuilder> each = triggers.iterator();
    final List visitables = _visitables.get("triggers");
    while (each.hasNext()) {
      DeploymentTriggerPolicyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTriggers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<DeploymentTriggerPolicy> getTriggers() {
    return triggers != null ? build(triggers) : null;
  }
  public List<DeploymentTriggerPolicy> buildTriggers() {
    return triggers != null ? build(triggers) : null;
  }
  public DeploymentTriggerPolicy buildTrigger(Integer index) {
    return this.triggers.get(index).build();
  }
  public DeploymentTriggerPolicy buildFirstTrigger() {
    return this.triggers.get(0).build();
  }
  public DeploymentTriggerPolicy buildLastTrigger() {
    return this.triggers.get(triggers.size() - 1).build();
  }
  public DeploymentTriggerPolicy buildMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
    for (DeploymentTriggerPolicyBuilder item: triggers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
    for (DeploymentTriggerPolicyBuilder item: triggers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTriggers(List<DeploymentTriggerPolicy> triggers) {
    if (this.triggers != null) { _visitables.get("triggers").removeAll(this.triggers);}
    if (triggers != null) {this.triggers = new ArrayList(); for (DeploymentTriggerPolicy item : triggers){this.addToTriggers(item);}} else { this.triggers = null;} return (A) this;
  }
  public A withTriggers(io.fabric8.openshift.api.model.DeploymentTriggerPolicy... triggers) {
    if (this.triggers != null) {this.triggers.clear();}
    if (triggers != null) {for (DeploymentTriggerPolicy item :triggers){ this.addToTriggers(item);}} return (A) this;
  }
  public Boolean hasTriggers() {
    return triggers != null && !triggers.isEmpty();
  }
  public DeploymentConfigSpecFluent.TriggersNested<A> addNewTrigger() {
    return new DeploymentConfigSpecFluentImpl.TriggersNestedImpl();
  }
  public DeploymentConfigSpecFluent.TriggersNested<A> addNewTriggerLike(DeploymentTriggerPolicy item) {
    return new DeploymentConfigSpecFluentImpl.TriggersNestedImpl(-1, item);
  }
  public DeploymentConfigSpecFluent.TriggersNested<A> setNewTriggerLike(Integer index,DeploymentTriggerPolicy item) {
    return new DeploymentConfigSpecFluentImpl.TriggersNestedImpl(index, item);
  }
  public DeploymentConfigSpecFluent.TriggersNested<A> editTrigger(Integer index) {
    if (triggers.size() <= index) throw new RuntimeException("Can't edit triggers. Index exceeds size.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public DeploymentConfigSpecFluent.TriggersNested<A> editFirstTrigger() {
    if (triggers.size() == 0) throw new RuntimeException("Can't edit first triggers. The list is empty.");
    return setNewTriggerLike(0, buildTrigger(0));
  }
  public DeploymentConfigSpecFluent.TriggersNested<A> editLastTrigger() {
    int index = triggers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last triggers. The list is empty.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public DeploymentConfigSpecFluent.TriggersNested<A> editMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<triggers.size();i++) { 
    if (predicate.test(triggers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching triggers. No match found.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DeploymentConfigSpecFluentImpl that = (DeploymentConfigSpecFluentImpl) o;
    if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
    if (paused != null ? !paused.equals(that.paused) :that.paused != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
    if (template != null ? !template.equals(that.template) :that.template != null) return false;
    if (test != null ? !test.equals(that.test) :that.test != null) return false;
    if (triggers != null ? !triggers.equals(that.triggers) :that.triggers != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(minReadySeconds,  paused,  replicas,  revisionHistoryLimit,  selector,  strategy,  template,  test,  triggers,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (minReadySeconds != null) { sb.append("minReadySeconds:"); sb.append(minReadySeconds + ","); }
    if (paused != null) { sb.append("paused:"); sb.append(paused + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (revisionHistoryLimit != null) { sb.append("revisionHistoryLimit:"); sb.append(revisionHistoryLimit + ","); }
    if (selector != null && !selector.isEmpty()) { sb.append("selector:"); sb.append(selector + ","); }
    if (strategy != null) { sb.append("strategy:"); sb.append(strategy + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (test != null) { sb.append("test:"); sb.append(test + ","); }
    if (triggers != null && !triggers.isEmpty()) { sb.append("triggers:"); sb.append(triggers + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withPaused() {
    return withPaused(true);
  }
  public A withTest() {
    return withTest(true);
  }
  class StrategyNestedImpl<N> extends DeploymentStrategyFluentImpl<DeploymentConfigSpecFluent.StrategyNested<N>> implements DeploymentConfigSpecFluent.StrategyNested<N>,Nested<N>{
    StrategyNestedImpl(DeploymentStrategy item) {
      this.builder = new DeploymentStrategyBuilder(this, item);
    }
    StrategyNestedImpl() {
      this.builder = new DeploymentStrategyBuilder(this);
    }
    DeploymentStrategyBuilder builder;
    public N and() {
      return (N) DeploymentConfigSpecFluentImpl.this.withStrategy(builder.build());
    }
    public N endStrategy() {
      return and();
    }
    
  }
  class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<DeploymentConfigSpecFluent.TemplateNested<N>> implements DeploymentConfigSpecFluent.TemplateNested<N>,Nested<N>{
    TemplateNestedImpl(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    TemplateNestedImpl() {
      this.builder = new PodTemplateSpecBuilder(this);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) DeploymentConfigSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  class TriggersNestedImpl<N> extends DeploymentTriggerPolicyFluentImpl<DeploymentConfigSpecFluent.TriggersNested<N>> implements DeploymentConfigSpecFluent.TriggersNested<N>,Nested<N>{
    TriggersNestedImpl(Integer index,DeploymentTriggerPolicy item) {
      this.index = index;
      this.builder = new DeploymentTriggerPolicyBuilder(this, item);
    }
    TriggersNestedImpl() {
      this.index = -1;
      this.builder = new DeploymentTriggerPolicyBuilder(this);
    }
    DeploymentTriggerPolicyBuilder builder;
    Integer index;
    public N and() {
      return (N) DeploymentConfigSpecFluentImpl.this.setToTriggers(index,builder.build());
    }
    public N endTrigger() {
      return and();
    }
    
  }
  
}