package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamListBuilder extends ImageStreamListFluentImpl<ImageStreamListBuilder> implements VisitableBuilder<ImageStreamList,ImageStreamListBuilder>{
  public ImageStreamListBuilder() {
    this(false);
  }
  public ImageStreamListBuilder(Boolean validationEnabled) {
    this(new ImageStreamList(), validationEnabled);
  }
  public ImageStreamListBuilder(ImageStreamListFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamListBuilder(ImageStreamListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageStreamList(), validationEnabled);
  }
  public ImageStreamListBuilder(ImageStreamListFluent<?> fluent,ImageStreamList instance) {
    this(fluent, instance, false);
  }
  public ImageStreamListBuilder(ImageStreamListFluent<?> fluent,ImageStreamList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamListBuilder(ImageStreamList instance) {
    this(instance,false);
  }
  public ImageStreamListBuilder(ImageStreamList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImageStreamListFluent<?> fluent;
  Boolean validationEnabled;
  public ImageStreamList build() {
    ImageStreamList buildable = new ImageStreamList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}