package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProjectFluentImpl<A extends ProjectFluent<A>> extends BaseFluent<A> implements ProjectFluent<A>{
  public ProjectFluentImpl() {
  }
  public ProjectFluentImpl(Project instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ProjectSpecBuilder spec;
  private ProjectStatusBuilder status;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ProjectFluent.MetadataNested<A> withNewMetadata() {
    return new ProjectFluentImpl.MetadataNestedImpl();
  }
  public ProjectFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ProjectFluentImpl.MetadataNestedImpl(item);
  }
  public ProjectFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ProjectFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ProjectFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ProjectSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ProjectSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ProjectSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ProjectSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ProjectFluent.SpecNested<A> withNewSpec() {
    return new ProjectFluentImpl.SpecNestedImpl();
  }
  public ProjectFluent.SpecNested<A> withNewSpecLike(ProjectSpec item) {
    return new ProjectFluentImpl.SpecNestedImpl(item);
  }
  public ProjectFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ProjectFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ProjectSpecBuilder().build());
  }
  public ProjectFluent.SpecNested<A> editOrNewSpecLike(ProjectSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ProjectStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public ProjectStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(ProjectStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new ProjectStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public ProjectFluent.StatusNested<A> withNewStatus() {
    return new ProjectFluentImpl.StatusNestedImpl();
  }
  public ProjectFluent.StatusNested<A> withNewStatusLike(ProjectStatus item) {
    return new ProjectFluentImpl.StatusNestedImpl(item);
  }
  public ProjectFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ProjectFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new ProjectStatusBuilder().build());
  }
  public ProjectFluent.StatusNested<A> editOrNewStatusLike(ProjectStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProjectFluentImpl that = (ProjectFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ProjectFluent.MetadataNested<N>> implements ProjectFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ProjectFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ProjectSpecFluentImpl<ProjectFluent.SpecNested<N>> implements ProjectFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ProjectSpec item) {
      this.builder = new ProjectSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ProjectSpecBuilder(this);
    }
    ProjectSpecBuilder builder;
    public N and() {
      return (N) ProjectFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends ProjectStatusFluentImpl<ProjectFluent.StatusNested<N>> implements ProjectFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(ProjectStatus item) {
      this.builder = new ProjectStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new ProjectStatusBuilder(this);
    }
    ProjectStatusBuilder builder;
    public N and() {
      return (N) ProjectFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}