package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamSpecBuilder extends ImageStreamSpecFluentImpl<ImageStreamSpecBuilder> implements VisitableBuilder<ImageStreamSpec,ImageStreamSpecBuilder>{
  public ImageStreamSpecBuilder() {
    this(false);
  }
  public ImageStreamSpecBuilder(Boolean validationEnabled) {
    this(new ImageStreamSpec(), validationEnabled);
  }
  public ImageStreamSpecBuilder(ImageStreamSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamSpecBuilder(ImageStreamSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageStreamSpec(), validationEnabled);
  }
  public ImageStreamSpecBuilder(ImageStreamSpecFluent<?> fluent,ImageStreamSpec instance) {
    this(fluent, instance, false);
  }
  public ImageStreamSpecBuilder(ImageStreamSpecFluent<?> fluent,ImageStreamSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDockerImageRepository(instance.getDockerImageRepository()); 
    fluent.withLookupPolicy(instance.getLookupPolicy()); 
    fluent.withTags(instance.getTags()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamSpecBuilder(ImageStreamSpec instance) {
    this(instance,false);
  }
  public ImageStreamSpecBuilder(ImageStreamSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDockerImageRepository(instance.getDockerImageRepository()); 
    this.withLookupPolicy(instance.getLookupPolicy()); 
    this.withTags(instance.getTags()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImageStreamSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ImageStreamSpec build() {
    ImageStreamSpec buildable = new ImageStreamSpec(fluent.getDockerImageRepository(),fluent.getLookupPolicy(),fluent.getTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}