package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ProjectListFluent<A extends ProjectListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,Project item);
  public A setToItems(Integer index,Project item);
  public A addToItems(io.fabric8.openshift.api.model.Project... items);
  public A addAllToItems(Collection<Project> items);
  public A removeFromItems(io.fabric8.openshift.api.model.Project... items);
  public A removeAllFromItems(Collection<Project> items);
  public A removeMatchingFromItems(Predicate<ProjectBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Project> getItems();
  public List<Project> buildItems();
  public Project buildItem(Integer index);
  public Project buildFirstItem();
  public Project buildLastItem();
  public Project buildMatchingItem(Predicate<ProjectBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<ProjectBuilder> predicate);
  public A withItems(List<Project> items);
  public A withItems(io.fabric8.openshift.api.model.Project... items);
  public Boolean hasItems();
  public ProjectListFluent.ItemsNested<A> addNewItem();
  public ProjectListFluent.ItemsNested<A> addNewItemLike(Project item);
  public ProjectListFluent.ItemsNested<A> setNewItemLike(Integer index,Project item);
  public ProjectListFluent.ItemsNested<A> editItem(Integer index);
  public ProjectListFluent.ItemsNested<A> editFirstItem();
  public ProjectListFluent.ItemsNested<A> editLastItem();
  public ProjectListFluent.ItemsNested<A> editMatchingItem(Predicate<ProjectBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,ProjectFluent<ProjectListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}