package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class UserFluentImpl<A extends UserFluent<A>> extends BaseFluent<A> implements UserFluent<A>{
  public UserFluentImpl() {
  }
  public UserFluentImpl(User instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withFullName(instance.getFullName()); 
    this.withGroups(instance.getGroups()); 
    this.withIdentities(instance.getIdentities()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private String fullName;
  private List<String> groups = new ArrayList<String>();
  private List<String> identities = new ArrayList<String>();
  private String kind;
  private ObjectMetaBuilder metadata;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getFullName() {
    return this.fullName;
  }
  public A withFullName(String fullName) {
    this.fullName=fullName; return (A) this;
  }
  public Boolean hasFullName() {
    return this.fullName != null;
  }
  public A addToGroups(Integer index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.add(index, item);
    return (A)this;
  }
  public A setToGroups(Integer index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.set(index, item); return (A)this;
  }
  public A addToGroups(java.lang.String... items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A addAllToGroups(Collection<String> items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A removeFromGroups(java.lang.String... items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public A removeAllFromGroups(Collection<String> items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public List<String> getGroups() {
    return this.groups;
  }
  public String getGroup(Integer index) {
    return this.groups.get(index);
  }
  public String getFirstGroup() {
    return this.groups.get(0);
  }
  public String getLastGroup() {
    return this.groups.get(groups.size() - 1);
  }
  public String getMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroups(List<String> groups) {
    if (groups != null) {this.groups = new ArrayList(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
  }
  public A withGroups(java.lang.String... groups) {
    if (this.groups != null) {this.groups.clear();}
    if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
  }
  public Boolean hasGroups() {
    return groups != null && !groups.isEmpty();
  }
  public A addToIdentities(Integer index,String item) {
    if (this.identities == null) {this.identities = new ArrayList<String>();}
    this.identities.add(index, item);
    return (A)this;
  }
  public A setToIdentities(Integer index,String item) {
    if (this.identities == null) {this.identities = new ArrayList<String>();}
    this.identities.set(index, item); return (A)this;
  }
  public A addToIdentities(java.lang.String... items) {
    if (this.identities == null) {this.identities = new ArrayList<String>();}
    for (String item : items) {this.identities.add(item);} return (A)this;
  }
  public A addAllToIdentities(Collection<String> items) {
    if (this.identities == null) {this.identities = new ArrayList<String>();}
    for (String item : items) {this.identities.add(item);} return (A)this;
  }
  public A removeFromIdentities(java.lang.String... items) {
    for (String item : items) {if (this.identities!= null){ this.identities.remove(item);}} return (A)this;
  }
  public A removeAllFromIdentities(Collection<String> items) {
    for (String item : items) {if (this.identities!= null){ this.identities.remove(item);}} return (A)this;
  }
  public List<String> getIdentities() {
    return this.identities;
  }
  public String getIdentity(Integer index) {
    return this.identities.get(index);
  }
  public String getFirstIdentity() {
    return this.identities.get(0);
  }
  public String getLastIdentity() {
    return this.identities.get(identities.size() - 1);
  }
  public String getMatchingIdentity(Predicate<String> predicate) {
    for (String item: identities) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingIdentity(Predicate<String> predicate) {
    for (String item: identities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIdentities(List<String> identities) {
    if (identities != null) {this.identities = new ArrayList(); for (String item : identities){this.addToIdentities(item);}} else { this.identities = null;} return (A) this;
  }
  public A withIdentities(java.lang.String... identities) {
    if (this.identities != null) {this.identities.clear();}
    if (identities != null) {for (String item :identities){ this.addToIdentities(item);}} return (A) this;
  }
  public Boolean hasIdentities() {
    return identities != null && !identities.isEmpty();
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public UserFluent.MetadataNested<A> withNewMetadata() {
    return new UserFluentImpl.MetadataNestedImpl();
  }
  public UserFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new UserFluentImpl.MetadataNestedImpl(item);
  }
  public UserFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public UserFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public UserFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UserFluentImpl that = (UserFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (fullName != null ? !fullName.equals(that.fullName) :that.fullName != null) return false;
    if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
    if (identities != null ? !identities.equals(that.identities) :that.identities != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  fullName,  groups,  identities,  kind,  metadata,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (fullName != null) { sb.append("fullName:"); sb.append(fullName + ","); }
    if (groups != null && !groups.isEmpty()) { sb.append("groups:"); sb.append(groups + ","); }
    if (identities != null && !identities.isEmpty()) { sb.append("identities:"); sb.append(identities + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<UserFluent.MetadataNested<N>> implements UserFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) UserFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}