package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OAuthClientFluentImpl<A extends OAuthClientFluent<A>> extends BaseFluent<A> implements OAuthClientFluent<A>{
  public OAuthClientFluentImpl() {
  }
  public OAuthClientFluentImpl(OAuthClient instance) {
    this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds()); 
    this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds()); 
    this.withAdditionalSecrets(instance.getAdditionalSecrets()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withGrantMethod(instance.getGrantMethod()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRedirectURIs(instance.getRedirectURIs()); 
    this.withRespondWithChallenges(instance.getRespondWithChallenges()); 
    this.withScopeRestrictions(instance.getScopeRestrictions()); 
    this.withSecret(instance.getSecret()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer accessTokenInactivityTimeoutSeconds;
  private Integer accessTokenMaxAgeSeconds;
  private List<String> additionalSecrets = new ArrayList<String>();
  private String apiVersion;
  private String grantMethod;
  private String kind;
  private ObjectMetaBuilder metadata;
  private List<String> redirectURIs = new ArrayList<String>();
  private Boolean respondWithChallenges;
  private ArrayList<ScopeRestrictionBuilder> scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();
  private String secret;
  private Map<String,Object> additionalProperties;
  public Integer getAccessTokenInactivityTimeoutSeconds() {
    return this.accessTokenInactivityTimeoutSeconds;
  }
  public A withAccessTokenInactivityTimeoutSeconds(Integer accessTokenInactivityTimeoutSeconds) {
    this.accessTokenInactivityTimeoutSeconds=accessTokenInactivityTimeoutSeconds; return (A) this;
  }
  public Boolean hasAccessTokenInactivityTimeoutSeconds() {
    return this.accessTokenInactivityTimeoutSeconds != null;
  }
  public Integer getAccessTokenMaxAgeSeconds() {
    return this.accessTokenMaxAgeSeconds;
  }
  public A withAccessTokenMaxAgeSeconds(Integer accessTokenMaxAgeSeconds) {
    this.accessTokenMaxAgeSeconds=accessTokenMaxAgeSeconds; return (A) this;
  }
  public Boolean hasAccessTokenMaxAgeSeconds() {
    return this.accessTokenMaxAgeSeconds != null;
  }
  public A addToAdditionalSecrets(Integer index,String item) {
    if (this.additionalSecrets == null) {this.additionalSecrets = new ArrayList<String>();}
    this.additionalSecrets.add(index, item);
    return (A)this;
  }
  public A setToAdditionalSecrets(Integer index,String item) {
    if (this.additionalSecrets == null) {this.additionalSecrets = new ArrayList<String>();}
    this.additionalSecrets.set(index, item); return (A)this;
  }
  public A addToAdditionalSecrets(java.lang.String... items) {
    if (this.additionalSecrets == null) {this.additionalSecrets = new ArrayList<String>();}
    for (String item : items) {this.additionalSecrets.add(item);} return (A)this;
  }
  public A addAllToAdditionalSecrets(Collection<String> items) {
    if (this.additionalSecrets == null) {this.additionalSecrets = new ArrayList<String>();}
    for (String item : items) {this.additionalSecrets.add(item);} return (A)this;
  }
  public A removeFromAdditionalSecrets(java.lang.String... items) {
    for (String item : items) {if (this.additionalSecrets!= null){ this.additionalSecrets.remove(item);}} return (A)this;
  }
  public A removeAllFromAdditionalSecrets(Collection<String> items) {
    for (String item : items) {if (this.additionalSecrets!= null){ this.additionalSecrets.remove(item);}} return (A)this;
  }
  public List<String> getAdditionalSecrets() {
    return this.additionalSecrets;
  }
  public String getAdditionalSecret(Integer index) {
    return this.additionalSecrets.get(index);
  }
  public String getFirstAdditionalSecret() {
    return this.additionalSecrets.get(0);
  }
  public String getLastAdditionalSecret() {
    return this.additionalSecrets.get(additionalSecrets.size() - 1);
  }
  public String getMatchingAdditionalSecret(Predicate<String> predicate) {
    for (String item: additionalSecrets) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAdditionalSecret(Predicate<String> predicate) {
    for (String item: additionalSecrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalSecrets(List<String> additionalSecrets) {
    if (additionalSecrets != null) {this.additionalSecrets = new ArrayList(); for (String item : additionalSecrets){this.addToAdditionalSecrets(item);}} else { this.additionalSecrets = null;} return (A) this;
  }
  public A withAdditionalSecrets(java.lang.String... additionalSecrets) {
    if (this.additionalSecrets != null) {this.additionalSecrets.clear();}
    if (additionalSecrets != null) {for (String item :additionalSecrets){ this.addToAdditionalSecrets(item);}} return (A) this;
  }
  public Boolean hasAdditionalSecrets() {
    return additionalSecrets != null && !additionalSecrets.isEmpty();
  }
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getGrantMethod() {
    return this.grantMethod;
  }
  public A withGrantMethod(String grantMethod) {
    this.grantMethod=grantMethod; return (A) this;
  }
  public Boolean hasGrantMethod() {
    return this.grantMethod != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public OAuthClientFluent.MetadataNested<A> withNewMetadata() {
    return new OAuthClientFluentImpl.MetadataNestedImpl();
  }
  public OAuthClientFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new OAuthClientFluentImpl.MetadataNestedImpl(item);
  }
  public OAuthClientFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public OAuthClientFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public OAuthClientFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToRedirectURIs(Integer index,String item) {
    if (this.redirectURIs == null) {this.redirectURIs = new ArrayList<String>();}
    this.redirectURIs.add(index, item);
    return (A)this;
  }
  public A setToRedirectURIs(Integer index,String item) {
    if (this.redirectURIs == null) {this.redirectURIs = new ArrayList<String>();}
    this.redirectURIs.set(index, item); return (A)this;
  }
  public A addToRedirectURIs(java.lang.String... items) {
    if (this.redirectURIs == null) {this.redirectURIs = new ArrayList<String>();}
    for (String item : items) {this.redirectURIs.add(item);} return (A)this;
  }
  public A addAllToRedirectURIs(Collection<String> items) {
    if (this.redirectURIs == null) {this.redirectURIs = new ArrayList<String>();}
    for (String item : items) {this.redirectURIs.add(item);} return (A)this;
  }
  public A removeFromRedirectURIs(java.lang.String... items) {
    for (String item : items) {if (this.redirectURIs!= null){ this.redirectURIs.remove(item);}} return (A)this;
  }
  public A removeAllFromRedirectURIs(Collection<String> items) {
    for (String item : items) {if (this.redirectURIs!= null){ this.redirectURIs.remove(item);}} return (A)this;
  }
  public List<String> getRedirectURIs() {
    return this.redirectURIs;
  }
  public String getRedirectURI(Integer index) {
    return this.redirectURIs.get(index);
  }
  public String getFirstRedirectURI() {
    return this.redirectURIs.get(0);
  }
  public String getLastRedirectURI() {
    return this.redirectURIs.get(redirectURIs.size() - 1);
  }
  public String getMatchingRedirectURI(Predicate<String> predicate) {
    for (String item: redirectURIs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRedirectURI(Predicate<String> predicate) {
    for (String item: redirectURIs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRedirectURIs(List<String> redirectURIs) {
    if (redirectURIs != null) {this.redirectURIs = new ArrayList(); for (String item : redirectURIs){this.addToRedirectURIs(item);}} else { this.redirectURIs = null;} return (A) this;
  }
  public A withRedirectURIs(java.lang.String... redirectURIs) {
    if (this.redirectURIs != null) {this.redirectURIs.clear();}
    if (redirectURIs != null) {for (String item :redirectURIs){ this.addToRedirectURIs(item);}} return (A) this;
  }
  public Boolean hasRedirectURIs() {
    return redirectURIs != null && !redirectURIs.isEmpty();
  }
  public Boolean getRespondWithChallenges() {
    return this.respondWithChallenges;
  }
  public A withRespondWithChallenges(Boolean respondWithChallenges) {
    this.respondWithChallenges=respondWithChallenges; return (A) this;
  }
  public Boolean hasRespondWithChallenges() {
    return this.respondWithChallenges != null;
  }
  public A addToScopeRestrictions(Integer index,ScopeRestriction item) {
    if (this.scopeRestrictions == null) {this.scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();}
    ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);_visitables.get("scopeRestrictions").add(index >= 0 ? index : _visitables.get("scopeRestrictions").size(), builder);this.scopeRestrictions.add(index >= 0 ? index : scopeRestrictions.size(), builder); return (A)this;
  }
  public A setToScopeRestrictions(Integer index,ScopeRestriction item) {
    if (this.scopeRestrictions == null) {this.scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();}
    ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
    if (index < 0 || index >= _visitables.get("scopeRestrictions").size()) { _visitables.get("scopeRestrictions").add(builder); } else { _visitables.get("scopeRestrictions").set(index, builder);}
    if (index < 0 || index >= scopeRestrictions.size()) { scopeRestrictions.add(builder); } else { scopeRestrictions.set(index, builder);}
     return (A)this;
  }
  public A addToScopeRestrictions(io.fabric8.openshift.api.model.ScopeRestriction... items) {
    if (this.scopeRestrictions == null) {this.scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();}
    for (ScopeRestriction item : items) {ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);_visitables.get("scopeRestrictions").add(builder);this.scopeRestrictions.add(builder);} return (A)this;
  }
  public A addAllToScopeRestrictions(Collection<ScopeRestriction> items) {
    if (this.scopeRestrictions == null) {this.scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();}
    for (ScopeRestriction item : items) {ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);_visitables.get("scopeRestrictions").add(builder);this.scopeRestrictions.add(builder);} return (A)this;
  }
  public A removeFromScopeRestrictions(io.fabric8.openshift.api.model.ScopeRestriction... items) {
    for (ScopeRestriction item : items) {ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);_visitables.get("scopeRestrictions").remove(builder);if (this.scopeRestrictions != null) {this.scopeRestrictions.remove(builder);}} return (A)this;
  }
  public A removeAllFromScopeRestrictions(Collection<ScopeRestriction> items) {
    for (ScopeRestriction item : items) {ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);_visitables.get("scopeRestrictions").remove(builder);if (this.scopeRestrictions != null) {this.scopeRestrictions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromScopeRestrictions(Predicate<ScopeRestrictionBuilder> predicate) {
    if (scopeRestrictions == null) return (A) this;
    final Iterator<ScopeRestrictionBuilder> each = scopeRestrictions.iterator();
    final List visitables = _visitables.get("scopeRestrictions");
    while (each.hasNext()) {
      ScopeRestrictionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildScopeRestrictions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ScopeRestriction> getScopeRestrictions() {
    return scopeRestrictions != null ? build(scopeRestrictions) : null;
  }
  public List<ScopeRestriction> buildScopeRestrictions() {
    return scopeRestrictions != null ? build(scopeRestrictions) : null;
  }
  public ScopeRestriction buildScopeRestriction(Integer index) {
    return this.scopeRestrictions.get(index).build();
  }
  public ScopeRestriction buildFirstScopeRestriction() {
    return this.scopeRestrictions.get(0).build();
  }
  public ScopeRestriction buildLastScopeRestriction() {
    return this.scopeRestrictions.get(scopeRestrictions.size() - 1).build();
  }
  public ScopeRestriction buildMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate) {
    for (ScopeRestrictionBuilder item: scopeRestrictions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate) {
    for (ScopeRestrictionBuilder item: scopeRestrictions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withScopeRestrictions(List<ScopeRestriction> scopeRestrictions) {
    if (this.scopeRestrictions != null) { _visitables.get("scopeRestrictions").removeAll(this.scopeRestrictions);}
    if (scopeRestrictions != null) {this.scopeRestrictions = new ArrayList(); for (ScopeRestriction item : scopeRestrictions){this.addToScopeRestrictions(item);}} else { this.scopeRestrictions = null;} return (A) this;
  }
  public A withScopeRestrictions(io.fabric8.openshift.api.model.ScopeRestriction... scopeRestrictions) {
    if (this.scopeRestrictions != null) {this.scopeRestrictions.clear();}
    if (scopeRestrictions != null) {for (ScopeRestriction item :scopeRestrictions){ this.addToScopeRestrictions(item);}} return (A) this;
  }
  public Boolean hasScopeRestrictions() {
    return scopeRestrictions != null && !scopeRestrictions.isEmpty();
  }
  public OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestriction() {
    return new OAuthClientFluentImpl.ScopeRestrictionsNestedImpl();
  }
  public OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestrictionLike(ScopeRestriction item) {
    return new OAuthClientFluentImpl.ScopeRestrictionsNestedImpl(-1, item);
  }
  public OAuthClientFluent.ScopeRestrictionsNested<A> setNewScopeRestrictionLike(Integer index,ScopeRestriction item) {
    return new OAuthClientFluentImpl.ScopeRestrictionsNestedImpl(index, item);
  }
  public OAuthClientFluent.ScopeRestrictionsNested<A> editScopeRestriction(Integer index) {
    if (scopeRestrictions.size() <= index) throw new RuntimeException("Can't edit scopeRestrictions. Index exceeds size.");
    return setNewScopeRestrictionLike(index, buildScopeRestriction(index));
  }
  public OAuthClientFluent.ScopeRestrictionsNested<A> editFirstScopeRestriction() {
    if (scopeRestrictions.size() == 0) throw new RuntimeException("Can't edit first scopeRestrictions. The list is empty.");
    return setNewScopeRestrictionLike(0, buildScopeRestriction(0));
  }
  public OAuthClientFluent.ScopeRestrictionsNested<A> editLastScopeRestriction() {
    int index = scopeRestrictions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last scopeRestrictions. The list is empty.");
    return setNewScopeRestrictionLike(index, buildScopeRestriction(index));
  }
  public OAuthClientFluent.ScopeRestrictionsNested<A> editMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<scopeRestrictions.size();i++) { 
    if (predicate.test(scopeRestrictions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching scopeRestrictions. No match found.");
    return setNewScopeRestrictionLike(index, buildScopeRestriction(index));
  }
  public String getSecret() {
    return this.secret;
  }
  public A withSecret(String secret) {
    this.secret=secret; return (A) this;
  }
  public Boolean hasSecret() {
    return this.secret != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuthClientFluentImpl that = (OAuthClientFluentImpl) o;
    if (accessTokenInactivityTimeoutSeconds != null ? !accessTokenInactivityTimeoutSeconds.equals(that.accessTokenInactivityTimeoutSeconds) :that.accessTokenInactivityTimeoutSeconds != null) return false;
    if (accessTokenMaxAgeSeconds != null ? !accessTokenMaxAgeSeconds.equals(that.accessTokenMaxAgeSeconds) :that.accessTokenMaxAgeSeconds != null) return false;
    if (additionalSecrets != null ? !additionalSecrets.equals(that.additionalSecrets) :that.additionalSecrets != null) return false;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (grantMethod != null ? !grantMethod.equals(that.grantMethod) :that.grantMethod != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (redirectURIs != null ? !redirectURIs.equals(that.redirectURIs) :that.redirectURIs != null) return false;
    if (respondWithChallenges != null ? !respondWithChallenges.equals(that.respondWithChallenges) :that.respondWithChallenges != null) return false;
    if (scopeRestrictions != null ? !scopeRestrictions.equals(that.scopeRestrictions) :that.scopeRestrictions != null) return false;
    if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(accessTokenInactivityTimeoutSeconds,  accessTokenMaxAgeSeconds,  additionalSecrets,  apiVersion,  grantMethod,  kind,  metadata,  redirectURIs,  respondWithChallenges,  scopeRestrictions,  secret,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessTokenInactivityTimeoutSeconds != null) { sb.append("accessTokenInactivityTimeoutSeconds:"); sb.append(accessTokenInactivityTimeoutSeconds + ","); }
    if (accessTokenMaxAgeSeconds != null) { sb.append("accessTokenMaxAgeSeconds:"); sb.append(accessTokenMaxAgeSeconds + ","); }
    if (additionalSecrets != null && !additionalSecrets.isEmpty()) { sb.append("additionalSecrets:"); sb.append(additionalSecrets + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (grantMethod != null) { sb.append("grantMethod:"); sb.append(grantMethod + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (redirectURIs != null && !redirectURIs.isEmpty()) { sb.append("redirectURIs:"); sb.append(redirectURIs + ","); }
    if (respondWithChallenges != null) { sb.append("respondWithChallenges:"); sb.append(respondWithChallenges + ","); }
    if (scopeRestrictions != null && !scopeRestrictions.isEmpty()) { sb.append("scopeRestrictions:"); sb.append(scopeRestrictions + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withRespondWithChallenges() {
    return withRespondWithChallenges(true);
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<OAuthClientFluent.MetadataNested<N>> implements OAuthClientFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) OAuthClientFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class ScopeRestrictionsNestedImpl<N> extends ScopeRestrictionFluentImpl<OAuthClientFluent.ScopeRestrictionsNested<N>> implements OAuthClientFluent.ScopeRestrictionsNested<N>,Nested<N>{
    ScopeRestrictionsNestedImpl(Integer index,ScopeRestriction item) {
      this.index = index;
      this.builder = new ScopeRestrictionBuilder(this, item);
    }
    ScopeRestrictionsNestedImpl() {
      this.index = -1;
      this.builder = new ScopeRestrictionBuilder(this);
    }
    ScopeRestrictionBuilder builder;
    Integer index;
    public N and() {
      return (N) OAuthClientFluentImpl.this.setToScopeRestrictions(index,builder.build());
    }
    public N endScopeRestriction() {
      return and();
    }
    
  }
  
}