package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExecNewPodHookBuilder extends ExecNewPodHookFluentImpl<ExecNewPodHookBuilder> implements VisitableBuilder<ExecNewPodHook,ExecNewPodHookBuilder>{
  public ExecNewPodHookBuilder() {
    this(false);
  }
  public ExecNewPodHookBuilder(Boolean validationEnabled) {
    this(new ExecNewPodHook(), validationEnabled);
  }
  public ExecNewPodHookBuilder(ExecNewPodHookFluent<?> fluent) {
    this(fluent, false);
  }
  public ExecNewPodHookBuilder(ExecNewPodHookFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExecNewPodHook(), validationEnabled);
  }
  public ExecNewPodHookBuilder(ExecNewPodHookFluent<?> fluent,ExecNewPodHook instance) {
    this(fluent, instance, false);
  }
  public ExecNewPodHookBuilder(ExecNewPodHookFluent<?> fluent,ExecNewPodHook instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCommand(instance.getCommand()); 
    fluent.withContainerName(instance.getContainerName()); 
    fluent.withEnv(instance.getEnv()); 
    fluent.withVolumes(instance.getVolumes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ExecNewPodHookBuilder(ExecNewPodHook instance) {
    this(instance,false);
  }
  public ExecNewPodHookBuilder(ExecNewPodHook instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCommand(instance.getCommand()); 
    this.withContainerName(instance.getContainerName()); 
    this.withEnv(instance.getEnv()); 
    this.withVolumes(instance.getVolumes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ExecNewPodHookFluent<?> fluent;
  Boolean validationEnabled;
  public ExecNewPodHook build() {
    ExecNewPodHook buildable = new ExecNewPodHook(fluent.getCommand(),fluent.getContainerName(),fluent.getEnv(),fluent.getVolumes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}