package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthClientBuilder extends OAuthClientFluentImpl<OAuthClientBuilder> implements VisitableBuilder<OAuthClient,OAuthClientBuilder>{
  public OAuthClientBuilder() {
    this(false);
  }
  public OAuthClientBuilder(Boolean validationEnabled) {
    this(new OAuthClient(), validationEnabled);
  }
  public OAuthClientBuilder(OAuthClientFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthClientBuilder(OAuthClientFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OAuthClient(), validationEnabled);
  }
  public OAuthClientBuilder(OAuthClientFluent<?> fluent,OAuthClient instance) {
    this(fluent, instance, false);
  }
  public OAuthClientBuilder(OAuthClientFluent<?> fluent,OAuthClient instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds()); 
    fluent.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds()); 
    fluent.withAdditionalSecrets(instance.getAdditionalSecrets()); 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withGrantMethod(instance.getGrantMethod()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withRedirectURIs(instance.getRedirectURIs()); 
    fluent.withRespondWithChallenges(instance.getRespondWithChallenges()); 
    fluent.withScopeRestrictions(instance.getScopeRestrictions()); 
    fluent.withSecret(instance.getSecret()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthClientBuilder(OAuthClient instance) {
    this(instance,false);
  }
  public OAuthClientBuilder(OAuthClient instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds()); 
    this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds()); 
    this.withAdditionalSecrets(instance.getAdditionalSecrets()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withGrantMethod(instance.getGrantMethod()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRedirectURIs(instance.getRedirectURIs()); 
    this.withRespondWithChallenges(instance.getRespondWithChallenges()); 
    this.withScopeRestrictions(instance.getScopeRestrictions()); 
    this.withSecret(instance.getSecret()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OAuthClientFluent<?> fluent;
  Boolean validationEnabled;
  public OAuthClient build() {
    OAuthClient buildable = new OAuthClient(fluent.getAccessTokenInactivityTimeoutSeconds(),fluent.getAccessTokenMaxAgeSeconds(),fluent.getAdditionalSecrets(),fluent.getApiVersion(),fluent.getGrantMethod(),fluent.getKind(),fluent.getMetadata(),fluent.getRedirectURIs(),fluent.getRespondWithChallenges(),fluent.getScopeRestrictions(),fluent.getSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}