package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildBuilder extends BuildFluentImpl<BuildBuilder> implements VisitableBuilder<Build,BuildBuilder>{
  public BuildBuilder() {
    this(false);
  }
  public BuildBuilder(Boolean validationEnabled) {
    this(new Build(), validationEnabled);
  }
  public BuildBuilder(BuildFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildBuilder(BuildFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Build(), validationEnabled);
  }
  public BuildBuilder(BuildFluent<?> fluent,Build instance) {
    this(fluent, instance, false);
  }
  public BuildBuilder(BuildFluent<?> fluent,Build instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildBuilder(Build instance) {
    this(instance,false);
  }
  public BuildBuilder(Build instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  BuildFluent<?> fluent;
  Boolean validationEnabled;
  public Build build() {
    Build buildable = new Build(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}