package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageSignatureBuilder extends ImageSignatureFluentImpl<ImageSignatureBuilder> implements VisitableBuilder<ImageSignature,ImageSignatureBuilder>{
  public ImageSignatureBuilder() {
    this(false);
  }
  public ImageSignatureBuilder(Boolean validationEnabled) {
    this(new ImageSignature(), validationEnabled);
  }
  public ImageSignatureBuilder(ImageSignatureFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageSignatureBuilder(ImageSignatureFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageSignature(), validationEnabled);
  }
  public ImageSignatureBuilder(ImageSignatureFluent<?> fluent,ImageSignature instance) {
    this(fluent, instance, false);
  }
  public ImageSignatureBuilder(ImageSignatureFluent<?> fluent,ImageSignature instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withContent(instance.getContent()); 
    fluent.withCreated(instance.getCreated()); 
    fluent.withImageIdentity(instance.getImageIdentity()); 
    fluent.withIssuedBy(instance.getIssuedBy()); 
    fluent.withIssuedTo(instance.getIssuedTo()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSignedClaims(instance.getSignedClaims()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageSignatureBuilder(ImageSignature instance) {
    this(instance,false);
  }
  public ImageSignatureBuilder(ImageSignature instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withConditions(instance.getConditions()); 
    this.withContent(instance.getContent()); 
    this.withCreated(instance.getCreated()); 
    this.withImageIdentity(instance.getImageIdentity()); 
    this.withIssuedBy(instance.getIssuedBy()); 
    this.withIssuedTo(instance.getIssuedTo()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSignedClaims(instance.getSignedClaims()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImageSignatureFluent<?> fluent;
  Boolean validationEnabled;
  public ImageSignature build() {
    ImageSignature buildable = new ImageSignature(fluent.getApiVersion(),fluent.getConditions(),fluent.getContent(),fluent.getCreated(),fluent.getImageIdentity(),fluent.getIssuedBy(),fluent.getIssuedTo(),fluent.getKind(),fluent.getMetadata(),fluent.getSignedClaims(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}