package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface NetNamespaceFluent<A extends NetNamespaceFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToEgressIPs(Integer index,String item);
  public A setToEgressIPs(Integer index,String item);
  public A addToEgressIPs(java.lang.String... items);
  public A addAllToEgressIPs(Collection<String> items);
  public A removeFromEgressIPs(java.lang.String... items);
  public A removeAllFromEgressIPs(Collection<String> items);
  public List<String> getEgressIPs();
  public String getEgressIP(Integer index);
  public String getFirstEgressIP();
  public String getLastEgressIP();
  public String getMatchingEgressIP(Predicate<String> predicate);
  public Boolean hasMatchingEgressIP(Predicate<String> predicate);
  public A withEgressIPs(List<String> egressIPs);
  public A withEgressIPs(java.lang.String... egressIPs);
  public Boolean hasEgressIPs();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public NetNamespaceFluent.MetadataNested<A> withNewMetadata();
  public NetNamespaceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public NetNamespaceFluent.MetadataNested<A> editMetadata();
  public NetNamespaceFluent.MetadataNested<A> editOrNewMetadata();
  public NetNamespaceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public Integer getNetid();
  public A withNetid(Integer netid);
  public Boolean hasNetid();
  public String getNetname();
  public A withNetname(String netname);
  public Boolean hasNetname();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<NetNamespaceFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}