package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface OAuthClientAuthorizationFluent<A extends OAuthClientAuthorizationFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getClientName();
  public A withClientName(String clientName);
  public Boolean hasClientName();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public OAuthClientAuthorizationFluent.MetadataNested<A> withNewMetadata();
  public OAuthClientAuthorizationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public OAuthClientAuthorizationFluent.MetadataNested<A> editMetadata();
  public OAuthClientAuthorizationFluent.MetadataNested<A> editOrNewMetadata();
  public OAuthClientAuthorizationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public A addToScopes(Integer index,String item);
  public A setToScopes(Integer index,String item);
  public A addToScopes(java.lang.String... items);
  public A addAllToScopes(Collection<String> items);
  public A removeFromScopes(java.lang.String... items);
  public A removeAllFromScopes(Collection<String> items);
  public List<String> getScopes();
  public String getScope(Integer index);
  public String getFirstScope();
  public String getLastScope();
  public String getMatchingScope(Predicate<String> predicate);
  public Boolean hasMatchingScope(Predicate<String> predicate);
  public A withScopes(List<String> scopes);
  public A withScopes(java.lang.String... scopes);
  public Boolean hasScopes();
  public String getUserName();
  public A withUserName(String userName);
  public Boolean hasUserName();
  public String getUserUID();
  public A withUserUID(String userUID);
  public Boolean hasUserUID();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<OAuthClientAuthorizationFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}