package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SourceRevisionBuilder extends SourceRevisionFluentImpl<SourceRevisionBuilder> implements VisitableBuilder<SourceRevision,SourceRevisionBuilder>{
  public SourceRevisionBuilder() {
    this(false);
  }
  public SourceRevisionBuilder(Boolean validationEnabled) {
    this(new SourceRevision(), validationEnabled);
  }
  public SourceRevisionBuilder(SourceRevisionFluent<?> fluent) {
    this(fluent, false);
  }
  public SourceRevisionBuilder(SourceRevisionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SourceRevision(), validationEnabled);
  }
  public SourceRevisionBuilder(SourceRevisionFluent<?> fluent,SourceRevision instance) {
    this(fluent, instance, false);
  }
  public SourceRevisionBuilder(SourceRevisionFluent<?> fluent,SourceRevision instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGit(instance.getGit()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SourceRevisionBuilder(SourceRevision instance) {
    this(instance,false);
  }
  public SourceRevisionBuilder(SourceRevision instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withGit(instance.getGit()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SourceRevisionFluent<?> fluent;
  Boolean validationEnabled;
  public SourceRevision build() {
    SourceRevision buildable = new SourceRevision(fluent.getGit(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}