package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BinaryBuildSourceBuilder extends BinaryBuildSourceFluentImpl<BinaryBuildSourceBuilder> implements VisitableBuilder<BinaryBuildSource,BinaryBuildSourceBuilder>{
  public BinaryBuildSourceBuilder() {
    this(false);
  }
  public BinaryBuildSourceBuilder(Boolean validationEnabled) {
    this(new BinaryBuildSource(), validationEnabled);
  }
  public BinaryBuildSourceBuilder(BinaryBuildSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public BinaryBuildSourceBuilder(BinaryBuildSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BinaryBuildSource(), validationEnabled);
  }
  public BinaryBuildSourceBuilder(BinaryBuildSourceFluent<?> fluent,BinaryBuildSource instance) {
    this(fluent, instance, false);
  }
  public BinaryBuildSourceBuilder(BinaryBuildSourceFluent<?> fluent,BinaryBuildSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAsFile(instance.getAsFile());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BinaryBuildSourceBuilder(BinaryBuildSource instance) {
    this(instance,false);
  }
  public BinaryBuildSourceBuilder(BinaryBuildSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAsFile(instance.getAsFile());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BinaryBuildSourceFluent<?> fluent;
  Boolean validationEnabled;
  public BinaryBuildSource build() {
    BinaryBuildSource buildable = new BinaryBuildSource(fluent.getAsFile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}