package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BuildVolumeFluentImpl<A extends BuildVolumeFluent<A>> extends BaseFluent<A> implements BuildVolumeFluent<A>{
  public BuildVolumeFluentImpl() {
  }
  public BuildVolumeFluentImpl(BuildVolume instance) {
    if (instance != null) {
      this.withMounts(instance.getMounts());
      this.withName(instance.getName());
      this.withSource(instance.getSource());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<BuildVolumeMountBuilder> mounts = new ArrayList<BuildVolumeMountBuilder>();
  private String name;
  private BuildVolumeSourceBuilder source;
  private Map<String,Object> additionalProperties;
  public A addToMounts(int index,BuildVolumeMount item) {
    if (this.mounts == null) {this.mounts = new ArrayList<BuildVolumeMountBuilder>();}
    BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);
    if (index < 0 || index >= mounts.size()) { _visitables.get("mounts").add(builder); mounts.add(builder); } else { _visitables.get("mounts").add(index, builder); mounts.add(index, builder);}
    return (A)this;
  }
  public A setToMounts(int index,BuildVolumeMount item) {
    if (this.mounts == null) {this.mounts = new ArrayList<BuildVolumeMountBuilder>();}
    BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);
    if (index < 0 || index >= mounts.size()) { _visitables.get("mounts").add(builder); mounts.add(builder); } else { _visitables.get("mounts").set(index, builder); mounts.set(index, builder);}
    return (A)this;
  }
  public A addToMounts(io.fabric8.openshift.api.model.BuildVolumeMount... items) {
    if (this.mounts == null) {this.mounts = new ArrayList<BuildVolumeMountBuilder>();}
    for (BuildVolumeMount item : items) {BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);_visitables.get("mounts").add(builder);this.mounts.add(builder);} return (A)this;
  }
  public A addAllToMounts(Collection<BuildVolumeMount> items) {
    if (this.mounts == null) {this.mounts = new ArrayList<BuildVolumeMountBuilder>();}
    for (BuildVolumeMount item : items) {BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);_visitables.get("mounts").add(builder);this.mounts.add(builder);} return (A)this;
  }
  public A removeFromMounts(io.fabric8.openshift.api.model.BuildVolumeMount... items) {
    for (BuildVolumeMount item : items) {BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);_visitables.get("mounts").remove(builder);if (this.mounts != null) {this.mounts.remove(builder);}} return (A)this;
  }
  public A removeAllFromMounts(Collection<BuildVolumeMount> items) {
    for (BuildVolumeMount item : items) {BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);_visitables.get("mounts").remove(builder);if (this.mounts != null) {this.mounts.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMounts(Predicate<BuildVolumeMountBuilder> predicate) {
    if (mounts == null) return (A) this;
    final Iterator<BuildVolumeMountBuilder> each = mounts.iterator();
    final List visitables = _visitables.get("mounts");
    while (each.hasNext()) {
      BuildVolumeMountBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMounts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<BuildVolumeMount> getMounts() {
    return mounts != null ? build(mounts) : null;
  }
  public List<BuildVolumeMount> buildMounts() {
    return mounts != null ? build(mounts) : null;
  }
  public BuildVolumeMount buildMount(int index) {
    return this.mounts.get(index).build();
  }
  public BuildVolumeMount buildFirstMount() {
    return this.mounts.get(0).build();
  }
  public BuildVolumeMount buildLastMount() {
    return this.mounts.get(mounts.size() - 1).build();
  }
  public BuildVolumeMount buildMatchingMount(Predicate<BuildVolumeMountBuilder> predicate) {
    for (BuildVolumeMountBuilder item: mounts) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMount(Predicate<BuildVolumeMountBuilder> predicate) {
    for (BuildVolumeMountBuilder item: mounts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMounts(List<BuildVolumeMount> mounts) {
    if (this.mounts != null) { _visitables.get("mounts").clear();}
    if (mounts != null) {this.mounts = new ArrayList(); for (BuildVolumeMount item : mounts){this.addToMounts(item);}} else { this.mounts = null;} return (A) this;
  }
  public A withMounts(io.fabric8.openshift.api.model.BuildVolumeMount... mounts) {
    if (this.mounts != null) {this.mounts.clear(); _visitables.remove("mounts"); }
    if (mounts != null) {for (BuildVolumeMount item :mounts){ this.addToMounts(item);}} return (A) this;
  }
  public Boolean hasMounts() {
    return mounts != null && !mounts.isEmpty();
  }
  public A addNewMount(String destinationPath) {
    return (A)addToMounts(new BuildVolumeMount(destinationPath));
  }
  public BuildVolumeFluentImpl.MountsNested<A> addNewMount() {
    return new BuildVolumeFluentImpl.MountsNestedImpl();
  }
  public BuildVolumeFluentImpl.MountsNested<A> addNewMountLike(BuildVolumeMount item) {
    return new BuildVolumeFluentImpl.MountsNestedImpl(-1, item);
  }
  public BuildVolumeFluentImpl.MountsNested<A> setNewMountLike(int index,BuildVolumeMount item) {
    return new BuildVolumeFluentImpl.MountsNestedImpl(index, item);
  }
  public BuildVolumeFluentImpl.MountsNested<A> editMount(int index) {
    if (mounts.size() <= index) throw new RuntimeException("Can't edit mounts. Index exceeds size.");
    return setNewMountLike(index, buildMount(index));
  }
  public BuildVolumeFluentImpl.MountsNested<A> editFirstMount() {
    if (mounts.size() == 0) throw new RuntimeException("Can't edit first mounts. The list is empty.");
    return setNewMountLike(0, buildMount(0));
  }
  public BuildVolumeFluentImpl.MountsNested<A> editLastMount() {
    int index = mounts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last mounts. The list is empty.");
    return setNewMountLike(index, buildMount(index));
  }
  public BuildVolumeFluentImpl.MountsNested<A> editMatchingMount(Predicate<BuildVolumeMountBuilder> predicate) {
    int index = -1;
    for (int i=0;i<mounts.size();i++) { 
    if (predicate.test(mounts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching mounts. No match found.");
    return setNewMountLike(index, buildMount(index));
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSource instead.
   * @return The buildable object.
   */
  @Deprecated
  public BuildVolumeSource getSource() {
    return this.source!=null ?this.source.build():null;
  }
  public BuildVolumeSource buildSource() {
    return this.source!=null ?this.source.build():null;
  }
  public A withSource(BuildVolumeSource source) {
    _visitables.get("source").remove(this.source);
    if (source!=null){ this.source= new BuildVolumeSourceBuilder(source); _visitables.get("source").add(this.source);} else { this.source = null; _visitables.get("source").remove(this.source); } return (A) this;
  }
  public Boolean hasSource() {
    return this.source != null;
  }
  public BuildVolumeFluentImpl.SourceNested<A> withNewSource() {
    return new BuildVolumeFluentImpl.SourceNestedImpl();
  }
  public BuildVolumeFluentImpl.SourceNested<A> withNewSourceLike(BuildVolumeSource item) {
    return new BuildVolumeFluentImpl.SourceNestedImpl(item);
  }
  public BuildVolumeFluentImpl.SourceNested<A> editSource() {
    return withNewSourceLike(getSource());
  }
  public BuildVolumeFluentImpl.SourceNested<A> editOrNewSource() {
    return withNewSourceLike(getSource() != null ? getSource(): new BuildVolumeSourceBuilder().build());
  }
  public BuildVolumeFluentImpl.SourceNested<A> editOrNewSourceLike(BuildVolumeSource item) {
    return withNewSourceLike(getSource() != null ? getSource(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildVolumeFluentImpl that = (BuildVolumeFluentImpl) o;
    if (!java.util.Objects.equals(mounts, that.mounts)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(source, that.source)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(mounts,  name,  source,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mounts != null && !mounts.isEmpty()) { sb.append("mounts:"); sb.append(mounts + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MountsNestedImpl<N> extends BuildVolumeMountFluentImpl<BuildVolumeFluentImpl.MountsNested<N>> implements BuildVolumeFluentImpl.MountsNested<N>,Nested<N>{
    MountsNestedImpl(int index,BuildVolumeMount item) {
      this.index = index;
      this.builder = new BuildVolumeMountBuilder(this, item);
    }
    MountsNestedImpl() {
      this.index = -1;
      this.builder = new BuildVolumeMountBuilder(this);
    }
    BuildVolumeMountBuilder builder;
    int index;
    public N and() {
      return (N) BuildVolumeFluentImpl.this.setToMounts(index,builder.build());
    }
    public N endMount() {
      return and();
    }
    
  }
  class SourceNestedImpl<N> extends BuildVolumeSourceFluentImpl<BuildVolumeFluentImpl.SourceNested<N>> implements BuildVolumeFluentImpl.SourceNested<N>,Nested<N>{
    SourceNestedImpl(BuildVolumeSource item) {
      this.builder = new BuildVolumeSourceBuilder(this, item);
    }
    SourceNestedImpl() {
      this.builder = new BuildVolumeSourceBuilder(this);
    }
    BuildVolumeSourceBuilder builder;
    public N and() {
      return (N) BuildVolumeFluentImpl.this.withSource(builder.build());
    }
    public N endSource() {
      return and();
    }
    
  }
  
}