package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildVolumeSourceBuilder extends BuildVolumeSourceFluentImpl<BuildVolumeSourceBuilder> implements VisitableBuilder<BuildVolumeSource,BuildVolumeSourceBuilder>{
  public BuildVolumeSourceBuilder() {
    this(false);
  }
  public BuildVolumeSourceBuilder(Boolean validationEnabled) {
    this(new BuildVolumeSource(), validationEnabled);
  }
  public BuildVolumeSourceBuilder(BuildVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildVolumeSourceBuilder(BuildVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildVolumeSource(), validationEnabled);
  }
  public BuildVolumeSourceBuilder(BuildVolumeSourceFluent<?> fluent,BuildVolumeSource instance) {
    this(fluent, instance, false);
  }
  public BuildVolumeSourceBuilder(BuildVolumeSourceFluent<?> fluent,BuildVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConfigMap(instance.getConfigMap());
      fluent.withSecret(instance.getSecret());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BuildVolumeSourceBuilder(BuildVolumeSource instance) {
    this(instance,false);
  }
  public BuildVolumeSourceBuilder(BuildVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConfigMap(instance.getConfigMap());
      this.withSecret(instance.getSecret());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BuildVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public BuildVolumeSource build() {
    BuildVolumeSource buildable = new BuildVolumeSource(fluent.getConfigMap(),fluent.getSecret(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}