package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EgressNetworkPolicyPeerBuilder extends EgressNetworkPolicyPeerFluentImpl<EgressNetworkPolicyPeerBuilder> implements VisitableBuilder<EgressNetworkPolicyPeer,EgressNetworkPolicyPeerBuilder>{
  public EgressNetworkPolicyPeerBuilder() {
    this(false);
  }
  public EgressNetworkPolicyPeerBuilder(Boolean validationEnabled) {
    this(new EgressNetworkPolicyPeer(), validationEnabled);
  }
  public EgressNetworkPolicyPeerBuilder(EgressNetworkPolicyPeerFluent<?> fluent) {
    this(fluent, false);
  }
  public EgressNetworkPolicyPeerBuilder(EgressNetworkPolicyPeerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EgressNetworkPolicyPeer(), validationEnabled);
  }
  public EgressNetworkPolicyPeerBuilder(EgressNetworkPolicyPeerFluent<?> fluent,EgressNetworkPolicyPeer instance) {
    this(fluent, instance, false);
  }
  public EgressNetworkPolicyPeerBuilder(EgressNetworkPolicyPeerFluent<?> fluent,EgressNetworkPolicyPeer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCidrSelector(instance.getCidrSelector());
      fluent.withDnsName(instance.getDnsName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EgressNetworkPolicyPeerBuilder(EgressNetworkPolicyPeer instance) {
    this(instance,false);
  }
  public EgressNetworkPolicyPeerBuilder(EgressNetworkPolicyPeer instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCidrSelector(instance.getCidrSelector());
      this.withDnsName(instance.getDnsName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EgressNetworkPolicyPeerFluent<?> fluent;
  Boolean validationEnabled;
  public EgressNetworkPolicyPeer build() {
    EgressNetworkPolicyPeer buildable = new EgressNetworkPolicyPeer(fluent.getCidrSelector(),fluent.getDnsName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}