package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageLookupPolicyBuilder extends ImageLookupPolicyFluentImpl<ImageLookupPolicyBuilder> implements VisitableBuilder<ImageLookupPolicy,ImageLookupPolicyBuilder>{
  public ImageLookupPolicyBuilder() {
    this(false);
  }
  public ImageLookupPolicyBuilder(Boolean validationEnabled) {
    this(new ImageLookupPolicy(), validationEnabled);
  }
  public ImageLookupPolicyBuilder(ImageLookupPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageLookupPolicyBuilder(ImageLookupPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageLookupPolicy(), validationEnabled);
  }
  public ImageLookupPolicyBuilder(ImageLookupPolicyFluent<?> fluent,ImageLookupPolicy instance) {
    this(fluent, instance, false);
  }
  public ImageLookupPolicyBuilder(ImageLookupPolicyFluent<?> fluent,ImageLookupPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLocal(instance.getLocal());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageLookupPolicyBuilder(ImageLookupPolicy instance) {
    this(instance,false);
  }
  public ImageLookupPolicyBuilder(ImageLookupPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLocal(instance.getLocal());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageLookupPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public ImageLookupPolicy build() {
    ImageLookupPolicy buildable = new ImageLookupPolicy(fluent.getLocal());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}