package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LocalResourceAccessReviewBuilder extends LocalResourceAccessReviewFluentImpl<LocalResourceAccessReviewBuilder> implements VisitableBuilder<LocalResourceAccessReview,LocalResourceAccessReviewBuilder>{
  public LocalResourceAccessReviewBuilder() {
    this(false);
  }
  public LocalResourceAccessReviewBuilder(Boolean validationEnabled) {
    this(new LocalResourceAccessReview(), validationEnabled);
  }
  public LocalResourceAccessReviewBuilder(LocalResourceAccessReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public LocalResourceAccessReviewBuilder(LocalResourceAccessReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LocalResourceAccessReview(), validationEnabled);
  }
  public LocalResourceAccessReviewBuilder(LocalResourceAccessReviewFluent<?> fluent,LocalResourceAccessReview instance) {
    this(fluent, instance, false);
  }
  public LocalResourceAccessReviewBuilder(LocalResourceAccessReviewFluent<?> fluent,LocalResourceAccessReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withContent(instance.getContent());
      fluent.withIsNonResourceURL(instance.getIsNonResourceURL());
      fluent.withKind(instance.getKind());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPath(instance.getPath());
      fluent.withResource(instance.getResource());
      fluent.withResourceAPIGroup(instance.getResourceAPIGroup());
      fluent.withResourceAPIVersion(instance.getResourceAPIVersion());
      fluent.withResourceName(instance.getResourceName());
      fluent.withVerb(instance.getVerb());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LocalResourceAccessReviewBuilder(LocalResourceAccessReview instance) {
    this(instance,false);
  }
  public LocalResourceAccessReviewBuilder(LocalResourceAccessReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withContent(instance.getContent());
      this.withIsNonResourceURL(instance.getIsNonResourceURL());
      this.withKind(instance.getKind());
      this.withNamespace(instance.getNamespace());
      this.withPath(instance.getPath());
      this.withResource(instance.getResource());
      this.withResourceAPIGroup(instance.getResourceAPIGroup());
      this.withResourceAPIVersion(instance.getResourceAPIVersion());
      this.withResourceName(instance.getResourceName());
      this.withVerb(instance.getVerb());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LocalResourceAccessReviewFluent<?> fluent;
  Boolean validationEnabled;
  public LocalResourceAccessReview build() {
    LocalResourceAccessReview buildable = new LocalResourceAccessReview(fluent.getApiVersion(),fluent.getContent(),fluent.getIsNonResourceURL(),fluent.getKind(),fluent.getNamespace(),fluent.getPath(),fluent.getResource(),fluent.getResourceAPIGroup(),fluent.getResourceAPIVersion(),fluent.getResourceName(),fluent.getVerb());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}