package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NamedTagEventListFluentImpl<A extends NamedTagEventListFluent<A>> extends BaseFluent<A> implements NamedTagEventListFluent<A>{
  public NamedTagEventListFluentImpl() {
  }
  public NamedTagEventListFluentImpl(NamedTagEventList instance) {
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withItems(instance.getItems());
      this.withTag(instance.getTag());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<TagEventConditionBuilder> conditions = new ArrayList<TagEventConditionBuilder>();
  private ArrayList<TagEventBuilder> items = new ArrayList<TagEventBuilder>();
  private String tag;
  private Map<String,Object> additionalProperties;
  public A addToConditions(int index,TagEventCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<TagEventConditionBuilder>();}
    TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,TagEventCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<TagEventConditionBuilder>();}
    TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.TagEventCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<TagEventConditionBuilder>();}
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<TagEventCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<TagEventConditionBuilder>();}
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.TagEventCondition... items) {
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<TagEventCondition> items) {
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<TagEventConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<TagEventConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      TagEventConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TagEventCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<TagEventCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public TagEventCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public TagEventCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public TagEventCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public TagEventCondition buildMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
    for (TagEventConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
    for (TagEventConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<TagEventCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (TagEventCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.TagEventCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (TagEventCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public NamedTagEventListFluentImpl.ConditionsNested<A> addNewCondition() {
    return new NamedTagEventListFluentImpl.ConditionsNestedImpl();
  }
  public NamedTagEventListFluentImpl.ConditionsNested<A> addNewConditionLike(TagEventCondition item) {
    return new NamedTagEventListFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public NamedTagEventListFluentImpl.ConditionsNested<A> setNewConditionLike(int index,TagEventCondition item) {
    return new NamedTagEventListFluentImpl.ConditionsNestedImpl(index, item);
  }
  public NamedTagEventListFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public NamedTagEventListFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public NamedTagEventListFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public NamedTagEventListFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public A addToItems(int index,TagEvent item) {
    if (this.items == null) {this.items = new ArrayList<TagEventBuilder>();}
    TagEventBuilder builder = new TagEventBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToItems(int index,TagEvent item) {
    if (this.items == null) {this.items = new ArrayList<TagEventBuilder>();}
    TagEventBuilder builder = new TagEventBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToItems(io.fabric8.openshift.api.model.TagEvent... items) {
    if (this.items == null) {this.items = new ArrayList<TagEventBuilder>();}
    for (TagEvent item : items) {TagEventBuilder builder = new TagEventBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToItems(Collection<TagEvent> items) {
    if (this.items == null) {this.items = new ArrayList<TagEventBuilder>();}
    for (TagEvent item : items) {TagEventBuilder builder = new TagEventBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromItems(io.fabric8.openshift.api.model.TagEvent... items) {
    for (TagEvent item : items) {TagEventBuilder builder = new TagEventBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromItems(Collection<TagEvent> items) {
    for (TagEvent item : items) {TagEventBuilder builder = new TagEventBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromItems(Predicate<TagEventBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<TagEventBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      TagEventBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TagEvent> getItems() {
    return items != null ? build(items) : null;
  }
  public List<TagEvent> buildItems() {
    return items != null ? build(items) : null;
  }
  public TagEvent buildItem(int index) {
    return this.items.get(index).build();
  }
  public TagEvent buildFirstItem() {
    return this.items.get(0).build();
  }
  public TagEvent buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public TagEvent buildMatchingItem(Predicate<TagEventBuilder> predicate) {
    for (TagEventBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingItem(Predicate<TagEventBuilder> predicate) {
    for (TagEventBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(List<TagEvent> items) {
    if (this.items != null) { _visitables.get("items").clear();}
    if (items != null) {this.items = new ArrayList(); for (TagEvent item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.openshift.api.model.TagEvent... items) {
    if (this.items != null) {this.items.clear(); _visitables.remove("items"); }
    if (items != null) {for (TagEvent item :items){ this.addToItems(item);}} return (A) this;
  }
  public Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public A addNewItem(String created,String dockerImageReference,Long generation,String image) {
    return (A)addToItems(new TagEvent(created, dockerImageReference, generation, image));
  }
  public NamedTagEventListFluentImpl.ItemsNested<A> addNewItem() {
    return new NamedTagEventListFluentImpl.ItemsNestedImpl();
  }
  public NamedTagEventListFluentImpl.ItemsNested<A> addNewItemLike(TagEvent item) {
    return new NamedTagEventListFluentImpl.ItemsNestedImpl(-1, item);
  }
  public NamedTagEventListFluentImpl.ItemsNested<A> setNewItemLike(int index,TagEvent item) {
    return new NamedTagEventListFluentImpl.ItemsNestedImpl(index, item);
  }
  public NamedTagEventListFluentImpl.ItemsNested<A> editItem(int index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  public NamedTagEventListFluentImpl.ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  public NamedTagEventListFluentImpl.ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  public NamedTagEventListFluentImpl.ItemsNested<A> editMatchingItem(Predicate<TagEventBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  public String getTag() {
    return this.tag;
  }
  public A withTag(String tag) {
    this.tag=tag; return (A) this;
  }
  public Boolean hasTag() {
    return this.tag != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NamedTagEventListFluentImpl that = (NamedTagEventListFluentImpl) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(items, that.items)) return false;

    if (!java.util.Objects.equals(tag, that.tag)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  items,  tag,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items + ","); }
    if (tag != null) { sb.append("tag:"); sb.append(tag + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends TagEventConditionFluentImpl<NamedTagEventListFluentImpl.ConditionsNested<N>> implements NamedTagEventListFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,TagEventCondition item) {
      this.index = index;
      this.builder = new TagEventConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new TagEventConditionBuilder(this);
    }
    TagEventConditionBuilder builder;
    int index;
    public N and() {
      return (N) NamedTagEventListFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ItemsNestedImpl<N> extends TagEventFluentImpl<NamedTagEventListFluentImpl.ItemsNested<N>> implements NamedTagEventListFluentImpl.ItemsNested<N>,Nested<N>{
    ItemsNestedImpl(int index,TagEvent item) {
      this.index = index;
      this.builder = new TagEventBuilder(this, item);
    }
    ItemsNestedImpl() {
      this.index = -1;
      this.builder = new TagEventBuilder(this);
    }
    TagEventBuilder builder;
    int index;
    public N and() {
      return (N) NamedTagEventListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endItem() {
      return and();
    }
    
  }
  
}