package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface RoleFluent<A extends RoleFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public RoleFluent.MetadataNested<A> withNewMetadata();
  public RoleFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public RoleFluent.MetadataNested<A> editMetadata();
  public RoleFluent.MetadataNested<A> editOrNewMetadata();
  public RoleFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public A addToRules(int index,PolicyRule item);
  public A setToRules(int index,PolicyRule item);
  public A addToRules(io.fabric8.openshift.api.model.PolicyRule... items);
  public A addAllToRules(Collection<PolicyRule> items);
  public A removeFromRules(io.fabric8.openshift.api.model.PolicyRule... items);
  public A removeAllFromRules(Collection<PolicyRule> items);
  public A removeMatchingFromRules(Predicate<PolicyRuleBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PolicyRule> getRules();
  public List<PolicyRule> buildRules();
  public PolicyRule buildRule(int index);
  public PolicyRule buildFirstRule();
  public PolicyRule buildLastRule();
  public PolicyRule buildMatchingRule(Predicate<PolicyRuleBuilder> predicate);
  public Boolean hasMatchingRule(Predicate<PolicyRuleBuilder> predicate);
  public A withRules(List<PolicyRule> rules);
  public A withRules(io.fabric8.openshift.api.model.PolicyRule... rules);
  public Boolean hasRules();
  public RoleFluent.RulesNested<A> addNewRule();
  public RoleFluent.RulesNested<A> addNewRuleLike(PolicyRule item);
  public RoleFluent.RulesNested<A> setNewRuleLike(int index,PolicyRule item);
  public RoleFluent.RulesNested<A> editRule(int index);
  public RoleFluent.RulesNested<A> editFirstRule();
  public RoleFluent.RulesNested<A> editLastRule();
  public RoleFluent.RulesNested<A> editMatchingRule(Predicate<PolicyRuleBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<RoleFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface RulesNested<N> extends Nested<N>,PolicyRuleFluent<RoleFluent.RulesNested<N>>{
    public N and();
    public N endRule();
    
  }
  
}