package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SecretBuildSourceFluentImpl<A extends SecretBuildSourceFluent<A>> extends BaseFluent<A> implements SecretBuildSourceFluent<A>{
  public SecretBuildSourceFluentImpl() {
  }
  public SecretBuildSourceFluentImpl(SecretBuildSource instance) {
    if (instance != null) {
      this.withDestinationDir(instance.getDestinationDir());
      this.withSecret(instance.getSecret());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String destinationDir;
  private LocalObjectReferenceBuilder secret;
  private Map<String,Object> additionalProperties;
  public String getDestinationDir() {
    return this.destinationDir;
  }
  public A withDestinationDir(String destinationDir) {
    this.destinationDir=destinationDir; return (A) this;
  }
  public Boolean hasDestinationDir() {
    return this.destinationDir != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public LocalObjectReference buildSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public A withSecret(LocalObjectReference secret) {
    _visitables.get("secret").remove(this.secret);
    if (secret!=null){ this.secret= new LocalObjectReferenceBuilder(secret); _visitables.get("secret").add(this.secret);} else { this.secret = null; _visitables.get("secret").remove(this.secret); } return (A) this;
  }
  public Boolean hasSecret() {
    return this.secret != null;
  }
  public A withNewSecret(String name) {
    return (A)withSecret(new LocalObjectReference(name));
  }
  public SecretBuildSourceFluentImpl.SecretNested<A> withNewSecret() {
    return new SecretBuildSourceFluentImpl.SecretNestedImpl();
  }
  public SecretBuildSourceFluentImpl.SecretNested<A> withNewSecretLike(LocalObjectReference item) {
    return new SecretBuildSourceFluentImpl.SecretNestedImpl(item);
  }
  public SecretBuildSourceFluentImpl.SecretNested<A> editSecret() {
    return withNewSecretLike(getSecret());
  }
  public SecretBuildSourceFluentImpl.SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(getSecret() != null ? getSecret(): new LocalObjectReferenceBuilder().build());
  }
  public SecretBuildSourceFluentImpl.SecretNested<A> editOrNewSecretLike(LocalObjectReference item) {
    return withNewSecretLike(getSecret() != null ? getSecret(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecretBuildSourceFluentImpl that = (SecretBuildSourceFluentImpl) o;
    if (!java.util.Objects.equals(destinationDir, that.destinationDir)) return false;

    if (!java.util.Objects.equals(secret, that.secret)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(destinationDir,  secret,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (destinationDir != null) { sb.append("destinationDir:"); sb.append(destinationDir + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<SecretBuildSourceFluentImpl.SecretNested<N>> implements SecretBuildSourceFluentImpl.SecretNested<N>,Nested<N>{
    SecretNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    SecretNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) SecretBuildSourceFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret() {
      return and();
    }
    
  }
  
}