/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.config.v1.TokenConfig;
import io.fabric8.openshift.api.model.config.v1.TokenConfigFluent;
import io.fabric8.openshift.api.model.config.v1.TokenConfigFluentImpl;

public class TokenConfigBuilder
extends TokenConfigFluentImpl<TokenConfigBuilder>
implements VisitableBuilder<TokenConfig, TokenConfigBuilder> {
    TokenConfigFluent<?> fluent;
    Boolean validationEnabled;

    public TokenConfigBuilder() {
        this(false);
    }

    public TokenConfigBuilder(Boolean validationEnabled) {
        this(new TokenConfig(), validationEnabled);
    }

    public TokenConfigBuilder(TokenConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public TokenConfigBuilder(TokenConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TokenConfig(), validationEnabled);
    }

    public TokenConfigBuilder(TokenConfigFluent<?> fluent, TokenConfig instance) {
        this(fluent, instance, false);
    }

    public TokenConfigBuilder(TokenConfigFluent<?> fluent, TokenConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withAccessTokenInactivityTimeout(instance.getAccessTokenInactivityTimeout());
            fluent.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
            fluent.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public TokenConfigBuilder(TokenConfig instance) {
        this(instance, (Boolean)false);
    }

    public TokenConfigBuilder(TokenConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withAccessTokenInactivityTimeout(instance.getAccessTokenInactivityTimeout());
            this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
            this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public TokenConfig build() {
        TokenConfig buildable = new TokenConfig(this.fluent.getAccessTokenInactivityTimeout(), this.fluent.getAccessTokenInactivityTimeoutSeconds(), this.fluent.getAccessTokenMaxAgeSeconds());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

