package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BuildRequestFluentImpl<A extends BuildRequestFluent<A>> extends BaseFluent<A> implements BuildRequestFluent<A>{
  public BuildRequestFluentImpl() {
  }
  public BuildRequestFluentImpl(BuildRequest instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withBinary(instance.getBinary());
      this.withDockerStrategyOptions(instance.getDockerStrategyOptions());
      this.withEnv(instance.getEnv());
      this.withFrom(instance.getFrom());
      this.withKind(instance.getKind());
      this.withLastVersion(instance.getLastVersion());
      this.withMetadata(instance.getMetadata());
      this.withRevision(instance.getRevision());
      this.withSourceStrategyOptions(instance.getSourceStrategyOptions());
      this.withTriggeredBy(instance.getTriggeredBy());
      this.withTriggeredByImage(instance.getTriggeredByImage());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private BinaryBuildSourceBuilder binary;
  private DockerStrategyOptionsBuilder dockerStrategyOptions;
  private List<EnvVar> env = new ArrayList<EnvVar>();
  private ObjectReferenceBuilder from;
  private String kind;
  private Long lastVersion;
  private ObjectMetaBuilder metadata;
  private SourceRevisionBuilder revision;
  private SourceStrategyOptionsBuilder sourceStrategyOptions;
  private ArrayList<BuildTriggerCauseBuilder> triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();
  private ObjectReferenceBuilder triggeredByImage;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * This method has been deprecated, please use method buildBinary instead.
   * @return The buildable object.
   */
  @Deprecated
  public BinaryBuildSource getBinary() {
    return this.binary!=null ?this.binary.build():null;
  }
  public BinaryBuildSource buildBinary() {
    return this.binary!=null ?this.binary.build():null;
  }
  public A withBinary(BinaryBuildSource binary) {
    _visitables.get("binary").remove(this.binary);
    if (binary!=null){ this.binary= new BinaryBuildSourceBuilder(binary); _visitables.get("binary").add(this.binary);} else { this.binary = null; _visitables.get("binary").remove(this.binary); } return (A) this;
  }
  public Boolean hasBinary() {
    return this.binary != null;
  }
  public A withNewBinary(String asFile) {
    return (A)withBinary(new BinaryBuildSource(asFile));
  }
  public BuildRequestFluentImpl.BinaryNested<A> withNewBinary() {
    return new BuildRequestFluentImpl.BinaryNestedImpl();
  }
  public BuildRequestFluentImpl.BinaryNested<A> withNewBinaryLike(BinaryBuildSource item) {
    return new BuildRequestFluentImpl.BinaryNestedImpl(item);
  }
  public BuildRequestFluentImpl.BinaryNested<A> editBinary() {
    return withNewBinaryLike(getBinary());
  }
  public BuildRequestFluentImpl.BinaryNested<A> editOrNewBinary() {
    return withNewBinaryLike(getBinary() != null ? getBinary(): new BinaryBuildSourceBuilder().build());
  }
  public BuildRequestFluentImpl.BinaryNested<A> editOrNewBinaryLike(BinaryBuildSource item) {
    return withNewBinaryLike(getBinary() != null ? getBinary(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDockerStrategyOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public DockerStrategyOptions getDockerStrategyOptions() {
    return this.dockerStrategyOptions!=null ?this.dockerStrategyOptions.build():null;
  }
  public DockerStrategyOptions buildDockerStrategyOptions() {
    return this.dockerStrategyOptions!=null ?this.dockerStrategyOptions.build():null;
  }
  public A withDockerStrategyOptions(DockerStrategyOptions dockerStrategyOptions) {
    _visitables.get("dockerStrategyOptions").remove(this.dockerStrategyOptions);
    if (dockerStrategyOptions!=null){ this.dockerStrategyOptions= new DockerStrategyOptionsBuilder(dockerStrategyOptions); _visitables.get("dockerStrategyOptions").add(this.dockerStrategyOptions);} else { this.dockerStrategyOptions = null; _visitables.get("dockerStrategyOptions").remove(this.dockerStrategyOptions); } return (A) this;
  }
  public Boolean hasDockerStrategyOptions() {
    return this.dockerStrategyOptions != null;
  }
  public BuildRequestFluentImpl.DockerStrategyOptionsNested<A> withNewDockerStrategyOptions() {
    return new BuildRequestFluentImpl.DockerStrategyOptionsNestedImpl();
  }
  public BuildRequestFluentImpl.DockerStrategyOptionsNested<A> withNewDockerStrategyOptionsLike(DockerStrategyOptions item) {
    return new BuildRequestFluentImpl.DockerStrategyOptionsNestedImpl(item);
  }
  public BuildRequestFluentImpl.DockerStrategyOptionsNested<A> editDockerStrategyOptions() {
    return withNewDockerStrategyOptionsLike(getDockerStrategyOptions());
  }
  public BuildRequestFluentImpl.DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptions() {
    return withNewDockerStrategyOptionsLike(getDockerStrategyOptions() != null ? getDockerStrategyOptions(): new DockerStrategyOptionsBuilder().build());
  }
  public BuildRequestFluentImpl.DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptionsLike(DockerStrategyOptions item) {
    return withNewDockerStrategyOptionsLike(getDockerStrategyOptions() != null ? getDockerStrategyOptions(): item);
  }
  public A addToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.add(index, item);
    return (A)this;
  }
  public A setToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.set(index, item); return (A)this;
  }
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A addAllToEnv(Collection<EnvVar> items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public A removeAllFromEnv(Collection<EnvVar> items) {
    for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public List<EnvVar> getEnv() {
    return this.env;
  }
  public EnvVar getEnv(int index) {
    return this.env.get(index);
  }
  public EnvVar getFirstEnv() {
    return this.env.get(0);
  }
  public EnvVar getLastEnv() {
    return this.env.get(env.size() - 1);
  }
  public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
    for (EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
    for (EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(List<EnvVar> env) {
    if (env != null) {this.env = new ArrayList(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {this.env.clear(); _visitables.remove("env"); }
    if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  public Boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public ObjectReference buildFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public A withFrom(ObjectReference from) {
    _visitables.get("from").remove(this.from);
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} else { this.from = null; _visitables.get("from").remove(this.from); } return (A) this;
  }
  public Boolean hasFrom() {
    return this.from != null;
  }
  public BuildRequestFluentImpl.FromNested<A> withNewFrom() {
    return new BuildRequestFluentImpl.FromNestedImpl();
  }
  public BuildRequestFluentImpl.FromNested<A> withNewFromLike(ObjectReference item) {
    return new BuildRequestFluentImpl.FromNestedImpl(item);
  }
  public BuildRequestFluentImpl.FromNested<A> editFrom() {
    return withNewFromLike(getFrom());
  }
  public BuildRequestFluentImpl.FromNested<A> editOrNewFrom() {
    return withNewFromLike(getFrom() != null ? getFrom(): new ObjectReferenceBuilder().build());
  }
  public BuildRequestFluentImpl.FromNested<A> editOrNewFromLike(ObjectReference item) {
    return withNewFromLike(getFrom() != null ? getFrom(): item);
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public Long getLastVersion() {
    return this.lastVersion;
  }
  public A withLastVersion(Long lastVersion) {
    this.lastVersion=lastVersion; return (A) this;
  }
  public Boolean hasLastVersion() {
    return this.lastVersion != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public BuildRequestFluentImpl.MetadataNested<A> withNewMetadata() {
    return new BuildRequestFluentImpl.MetadataNestedImpl();
  }
  public BuildRequestFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new BuildRequestFluentImpl.MetadataNestedImpl(item);
  }
  public BuildRequestFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public BuildRequestFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public BuildRequestFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRevision instead.
   * @return The buildable object.
   */
  @Deprecated
  public SourceRevision getRevision() {
    return this.revision!=null ?this.revision.build():null;
  }
  public SourceRevision buildRevision() {
    return this.revision!=null ?this.revision.build():null;
  }
  public A withRevision(SourceRevision revision) {
    _visitables.get("revision").remove(this.revision);
    if (revision!=null){ this.revision= new SourceRevisionBuilder(revision); _visitables.get("revision").add(this.revision);} else { this.revision = null; _visitables.get("revision").remove(this.revision); } return (A) this;
  }
  public Boolean hasRevision() {
    return this.revision != null;
  }
  public BuildRequestFluentImpl.RevisionNested<A> withNewRevision() {
    return new BuildRequestFluentImpl.RevisionNestedImpl();
  }
  public BuildRequestFluentImpl.RevisionNested<A> withNewRevisionLike(SourceRevision item) {
    return new BuildRequestFluentImpl.RevisionNestedImpl(item);
  }
  public BuildRequestFluentImpl.RevisionNested<A> editRevision() {
    return withNewRevisionLike(getRevision());
  }
  public BuildRequestFluentImpl.RevisionNested<A> editOrNewRevision() {
    return withNewRevisionLike(getRevision() != null ? getRevision(): new SourceRevisionBuilder().build());
  }
  public BuildRequestFluentImpl.RevisionNested<A> editOrNewRevisionLike(SourceRevision item) {
    return withNewRevisionLike(getRevision() != null ? getRevision(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSourceStrategyOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public SourceStrategyOptions getSourceStrategyOptions() {
    return this.sourceStrategyOptions!=null ?this.sourceStrategyOptions.build():null;
  }
  public SourceStrategyOptions buildSourceStrategyOptions() {
    return this.sourceStrategyOptions!=null ?this.sourceStrategyOptions.build():null;
  }
  public A withSourceStrategyOptions(SourceStrategyOptions sourceStrategyOptions) {
    _visitables.get("sourceStrategyOptions").remove(this.sourceStrategyOptions);
    if (sourceStrategyOptions!=null){ this.sourceStrategyOptions= new SourceStrategyOptionsBuilder(sourceStrategyOptions); _visitables.get("sourceStrategyOptions").add(this.sourceStrategyOptions);} else { this.sourceStrategyOptions = null; _visitables.get("sourceStrategyOptions").remove(this.sourceStrategyOptions); } return (A) this;
  }
  public Boolean hasSourceStrategyOptions() {
    return this.sourceStrategyOptions != null;
  }
  public A withNewSourceStrategyOptions(Boolean incremental) {
    return (A)withSourceStrategyOptions(new SourceStrategyOptions(incremental));
  }
  public BuildRequestFluentImpl.SourceStrategyOptionsNested<A> withNewSourceStrategyOptions() {
    return new BuildRequestFluentImpl.SourceStrategyOptionsNestedImpl();
  }
  public BuildRequestFluentImpl.SourceStrategyOptionsNested<A> withNewSourceStrategyOptionsLike(SourceStrategyOptions item) {
    return new BuildRequestFluentImpl.SourceStrategyOptionsNestedImpl(item);
  }
  public BuildRequestFluentImpl.SourceStrategyOptionsNested<A> editSourceStrategyOptions() {
    return withNewSourceStrategyOptionsLike(getSourceStrategyOptions());
  }
  public BuildRequestFluentImpl.SourceStrategyOptionsNested<A> editOrNewSourceStrategyOptions() {
    return withNewSourceStrategyOptionsLike(getSourceStrategyOptions() != null ? getSourceStrategyOptions(): new SourceStrategyOptionsBuilder().build());
  }
  public BuildRequestFluentImpl.SourceStrategyOptionsNested<A> editOrNewSourceStrategyOptionsLike(SourceStrategyOptions item) {
    return withNewSourceStrategyOptionsLike(getSourceStrategyOptions() != null ? getSourceStrategyOptions(): item);
  }
  public A addToTriggeredBy(int index,BuildTriggerCause item) {
    if (this.triggeredBy == null) {this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();}
    BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
    if (index < 0 || index >= triggeredBy.size()) { _visitables.get("triggeredBy").add(builder); triggeredBy.add(builder); } else { _visitables.get("triggeredBy").add(index, builder); triggeredBy.add(index, builder);}
    return (A)this;
  }
  public A setToTriggeredBy(int index,BuildTriggerCause item) {
    if (this.triggeredBy == null) {this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();}
    BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
    if (index < 0 || index >= triggeredBy.size()) { _visitables.get("triggeredBy").add(builder); triggeredBy.add(builder); } else { _visitables.get("triggeredBy").set(index, builder); triggeredBy.set(index, builder);}
    return (A)this;
  }
  public A addToTriggeredBy(io.fabric8.openshift.api.model.BuildTriggerCause... items) {
    if (this.triggeredBy == null) {this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();}
    for (BuildTriggerCause item : items) {BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").add(builder);this.triggeredBy.add(builder);} return (A)this;
  }
  public A addAllToTriggeredBy(Collection<BuildTriggerCause> items) {
    if (this.triggeredBy == null) {this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();}
    for (BuildTriggerCause item : items) {BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").add(builder);this.triggeredBy.add(builder);} return (A)this;
  }
  public A removeFromTriggeredBy(io.fabric8.openshift.api.model.BuildTriggerCause... items) {
    for (BuildTriggerCause item : items) {BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").remove(builder);if (this.triggeredBy != null) {this.triggeredBy.remove(builder);}} return (A)this;
  }
  public A removeAllFromTriggeredBy(Collection<BuildTriggerCause> items) {
    for (BuildTriggerCause item : items) {BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").remove(builder);if (this.triggeredBy != null) {this.triggeredBy.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
    if (triggeredBy == null) return (A) this;
    final Iterator<BuildTriggerCauseBuilder> each = triggeredBy.iterator();
    final List visitables = _visitables.get("triggeredBy");
    while (each.hasNext()) {
      BuildTriggerCauseBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTriggeredBy instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<BuildTriggerCause> getTriggeredBy() {
    return triggeredBy != null ? build(triggeredBy) : null;
  }
  public List<BuildTriggerCause> buildTriggeredBy() {
    return triggeredBy != null ? build(triggeredBy) : null;
  }
  public BuildTriggerCause buildTriggeredBy(int index) {
    return this.triggeredBy.get(index).build();
  }
  public BuildTriggerCause buildFirstTriggeredBy() {
    return this.triggeredBy.get(0).build();
  }
  public BuildTriggerCause buildLastTriggeredBy() {
    return this.triggeredBy.get(triggeredBy.size() - 1).build();
  }
  public BuildTriggerCause buildMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
    for (BuildTriggerCauseBuilder item: triggeredBy) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
    for (BuildTriggerCauseBuilder item: triggeredBy) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTriggeredBy(List<BuildTriggerCause> triggeredBy) {
    if (this.triggeredBy != null) { _visitables.get("triggeredBy").clear();}
    if (triggeredBy != null) {this.triggeredBy = new ArrayList(); for (BuildTriggerCause item : triggeredBy){this.addToTriggeredBy(item);}} else { this.triggeredBy = null;} return (A) this;
  }
  public A withTriggeredBy(io.fabric8.openshift.api.model.BuildTriggerCause... triggeredBy) {
    if (this.triggeredBy != null) {this.triggeredBy.clear(); _visitables.remove("triggeredBy"); }
    if (triggeredBy != null) {for (BuildTriggerCause item :triggeredBy){ this.addToTriggeredBy(item);}} return (A) this;
  }
  public Boolean hasTriggeredBy() {
    return triggeredBy != null && !triggeredBy.isEmpty();
  }
  public BuildRequestFluentImpl.TriggeredByNested<A> addNewTriggeredBy() {
    return new BuildRequestFluentImpl.TriggeredByNestedImpl();
  }
  public BuildRequestFluentImpl.TriggeredByNested<A> addNewTriggeredByLike(BuildTriggerCause item) {
    return new BuildRequestFluentImpl.TriggeredByNestedImpl(-1, item);
  }
  public BuildRequestFluentImpl.TriggeredByNested<A> setNewTriggeredByLike(int index,BuildTriggerCause item) {
    return new BuildRequestFluentImpl.TriggeredByNestedImpl(index, item);
  }
  public BuildRequestFluentImpl.TriggeredByNested<A> editTriggeredBy(int index) {
    if (triggeredBy.size() <= index) throw new RuntimeException("Can't edit triggeredBy. Index exceeds size.");
    return setNewTriggeredByLike(index, buildTriggeredBy(index));
  }
  public BuildRequestFluentImpl.TriggeredByNested<A> editFirstTriggeredBy() {
    if (triggeredBy.size() == 0) throw new RuntimeException("Can't edit first triggeredBy. The list is empty.");
    return setNewTriggeredByLike(0, buildTriggeredBy(0));
  }
  public BuildRequestFluentImpl.TriggeredByNested<A> editLastTriggeredBy() {
    int index = triggeredBy.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last triggeredBy. The list is empty.");
    return setNewTriggeredByLike(index, buildTriggeredBy(index));
  }
  public BuildRequestFluentImpl.TriggeredByNested<A> editMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
    int index = -1;
    for (int i=0;i<triggeredBy.size();i++) { 
    if (predicate.test(triggeredBy.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching triggeredBy. No match found.");
    return setNewTriggeredByLike(index, buildTriggeredBy(index));
  }
  
  /**
   * This method has been deprecated, please use method buildTriggeredByImage instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getTriggeredByImage() {
    return this.triggeredByImage!=null ?this.triggeredByImage.build():null;
  }
  public ObjectReference buildTriggeredByImage() {
    return this.triggeredByImage!=null ?this.triggeredByImage.build():null;
  }
  public A withTriggeredByImage(ObjectReference triggeredByImage) {
    _visitables.get("triggeredByImage").remove(this.triggeredByImage);
    if (triggeredByImage!=null){ this.triggeredByImage= new ObjectReferenceBuilder(triggeredByImage); _visitables.get("triggeredByImage").add(this.triggeredByImage);} else { this.triggeredByImage = null; _visitables.get("triggeredByImage").remove(this.triggeredByImage); } return (A) this;
  }
  public Boolean hasTriggeredByImage() {
    return this.triggeredByImage != null;
  }
  public BuildRequestFluentImpl.TriggeredByImageNested<A> withNewTriggeredByImage() {
    return new BuildRequestFluentImpl.TriggeredByImageNestedImpl();
  }
  public BuildRequestFluentImpl.TriggeredByImageNested<A> withNewTriggeredByImageLike(ObjectReference item) {
    return new BuildRequestFluentImpl.TriggeredByImageNestedImpl(item);
  }
  public BuildRequestFluentImpl.TriggeredByImageNested<A> editTriggeredByImage() {
    return withNewTriggeredByImageLike(getTriggeredByImage());
  }
  public BuildRequestFluentImpl.TriggeredByImageNested<A> editOrNewTriggeredByImage() {
    return withNewTriggeredByImageLike(getTriggeredByImage() != null ? getTriggeredByImage(): new ObjectReferenceBuilder().build());
  }
  public BuildRequestFluentImpl.TriggeredByImageNested<A> editOrNewTriggeredByImageLike(ObjectReference item) {
    return withNewTriggeredByImageLike(getTriggeredByImage() != null ? getTriggeredByImage(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildRequestFluentImpl that = (BuildRequestFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(binary, that.binary)) return false;

    if (!java.util.Objects.equals(dockerStrategyOptions, that.dockerStrategyOptions)) return false;

    if (!java.util.Objects.equals(env, that.env)) return false;

    if (!java.util.Objects.equals(from, that.from)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(lastVersion, that.lastVersion)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(revision, that.revision)) return false;

    if (!java.util.Objects.equals(sourceStrategyOptions, that.sourceStrategyOptions)) return false;

    if (!java.util.Objects.equals(triggeredBy, that.triggeredBy)) return false;

    if (!java.util.Objects.equals(triggeredByImage, that.triggeredByImage)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  binary,  dockerStrategyOptions,  env,  from,  kind,  lastVersion,  metadata,  revision,  sourceStrategyOptions,  triggeredBy,  triggeredByImage,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (binary != null) { sb.append("binary:"); sb.append(binary + ","); }
    if (dockerStrategyOptions != null) { sb.append("dockerStrategyOptions:"); sb.append(dockerStrategyOptions + ","); }
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (from != null) { sb.append("from:"); sb.append(from + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (lastVersion != null) { sb.append("lastVersion:"); sb.append(lastVersion + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (revision != null) { sb.append("revision:"); sb.append(revision + ","); }
    if (sourceStrategyOptions != null) { sb.append("sourceStrategyOptions:"); sb.append(sourceStrategyOptions + ","); }
    if (triggeredBy != null && !triggeredBy.isEmpty()) { sb.append("triggeredBy:"); sb.append(triggeredBy + ","); }
    if (triggeredByImage != null) { sb.append("triggeredByImage:"); sb.append(triggeredByImage + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class BinaryNestedImpl<N> extends BinaryBuildSourceFluentImpl<BuildRequestFluentImpl.BinaryNested<N>> implements BuildRequestFluentImpl.BinaryNested<N>,Nested<N>{
    BinaryNestedImpl(BinaryBuildSource item) {
      this.builder = new BinaryBuildSourceBuilder(this, item);
    }
    BinaryNestedImpl() {
      this.builder = new BinaryBuildSourceBuilder(this);
    }
    BinaryBuildSourceBuilder builder;
    public N and() {
      return (N) BuildRequestFluentImpl.this.withBinary(builder.build());
    }
    public N endBinary() {
      return and();
    }
    
  }
  class DockerStrategyOptionsNestedImpl<N> extends DockerStrategyOptionsFluentImpl<BuildRequestFluentImpl.DockerStrategyOptionsNested<N>> implements BuildRequestFluentImpl.DockerStrategyOptionsNested<N>,Nested<N>{
    DockerStrategyOptionsNestedImpl(DockerStrategyOptions item) {
      this.builder = new DockerStrategyOptionsBuilder(this, item);
    }
    DockerStrategyOptionsNestedImpl() {
      this.builder = new DockerStrategyOptionsBuilder(this);
    }
    DockerStrategyOptionsBuilder builder;
    public N and() {
      return (N) BuildRequestFluentImpl.this.withDockerStrategyOptions(builder.build());
    }
    public N endDockerStrategyOptions() {
      return and();
    }
    
  }
  class FromNestedImpl<N> extends ObjectReferenceFluentImpl<BuildRequestFluentImpl.FromNested<N>> implements BuildRequestFluentImpl.FromNested<N>,Nested<N>{
    FromNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    FromNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) BuildRequestFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<BuildRequestFluentImpl.MetadataNested<N>> implements BuildRequestFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) BuildRequestFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class RevisionNestedImpl<N> extends SourceRevisionFluentImpl<BuildRequestFluentImpl.RevisionNested<N>> implements BuildRequestFluentImpl.RevisionNested<N>,Nested<N>{
    RevisionNestedImpl(SourceRevision item) {
      this.builder = new SourceRevisionBuilder(this, item);
    }
    RevisionNestedImpl() {
      this.builder = new SourceRevisionBuilder(this);
    }
    SourceRevisionBuilder builder;
    public N and() {
      return (N) BuildRequestFluentImpl.this.withRevision(builder.build());
    }
    public N endRevision() {
      return and();
    }
    
  }
  class SourceStrategyOptionsNestedImpl<N> extends SourceStrategyOptionsFluentImpl<BuildRequestFluentImpl.SourceStrategyOptionsNested<N>> implements BuildRequestFluentImpl.SourceStrategyOptionsNested<N>,Nested<N>{
    SourceStrategyOptionsNestedImpl(SourceStrategyOptions item) {
      this.builder = new SourceStrategyOptionsBuilder(this, item);
    }
    SourceStrategyOptionsNestedImpl() {
      this.builder = new SourceStrategyOptionsBuilder(this);
    }
    SourceStrategyOptionsBuilder builder;
    public N and() {
      return (N) BuildRequestFluentImpl.this.withSourceStrategyOptions(builder.build());
    }
    public N endSourceStrategyOptions() {
      return and();
    }
    
  }
  class TriggeredByNestedImpl<N> extends BuildTriggerCauseFluentImpl<BuildRequestFluentImpl.TriggeredByNested<N>> implements BuildRequestFluentImpl.TriggeredByNested<N>,Nested<N>{
    TriggeredByNestedImpl(int index,BuildTriggerCause item) {
      this.index = index;
      this.builder = new BuildTriggerCauseBuilder(this, item);
    }
    TriggeredByNestedImpl() {
      this.index = -1;
      this.builder = new BuildTriggerCauseBuilder(this);
    }
    BuildTriggerCauseBuilder builder;
    int index;
    public N and() {
      return (N) BuildRequestFluentImpl.this.setToTriggeredBy(index,builder.build());
    }
    public N endTriggeredBy() {
      return and();
    }
    
  }
  class TriggeredByImageNestedImpl<N> extends ObjectReferenceFluentImpl<BuildRequestFluentImpl.TriggeredByImageNested<N>> implements BuildRequestFluentImpl.TriggeredByImageNested<N>,Nested<N>{
    TriggeredByImageNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    TriggeredByImageNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) BuildRequestFluentImpl.this.withTriggeredByImage(builder.build());
    }
    public N endTriggeredByImage() {
      return and();
    }
    
  }
  
}