package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface BuildStatusFluent<A extends BuildStatusFluent<A>> extends Fluent<A>{
  public Boolean getCancelled();
  public A withCancelled(Boolean cancelled);
  public Boolean hasCancelled();
  public String getCompletionTimestamp();
  public A withCompletionTimestamp(String completionTimestamp);
  public Boolean hasCompletionTimestamp();
  public A addToConditions(int index,BuildCondition item);
  public A setToConditions(int index,BuildCondition item);
  public A addToConditions(io.fabric8.openshift.api.model.BuildCondition... items);
  public A addAllToConditions(Collection<BuildCondition> items);
  public A removeFromConditions(io.fabric8.openshift.api.model.BuildCondition... items);
  public A removeAllFromConditions(Collection<BuildCondition> items);
  public A removeMatchingFromConditions(Predicate<BuildConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<BuildCondition> getConditions();
  public List<BuildCondition> buildConditions();
  public BuildCondition buildCondition(int index);
  public BuildCondition buildFirstCondition();
  public BuildCondition buildLastCondition();
  public BuildCondition buildMatchingCondition(Predicate<BuildConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<BuildConditionBuilder> predicate);
  public A withConditions(List<BuildCondition> conditions);
  public A withConditions(io.fabric8.openshift.api.model.BuildCondition... conditions);
  public Boolean hasConditions();
  public BuildStatusFluent.ConditionsNested<A> addNewCondition();
  public BuildStatusFluent.ConditionsNested<A> addNewConditionLike(BuildCondition item);
  public BuildStatusFluent.ConditionsNested<A> setNewConditionLike(int index,BuildCondition item);
  public BuildStatusFluent.ConditionsNested<A> editCondition(int index);
  public BuildStatusFluent.ConditionsNested<A> editFirstCondition();
  public BuildStatusFluent.ConditionsNested<A> editLastCondition();
  public BuildStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<BuildConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getConfig();
  public ObjectReference buildConfig();
  public A withConfig(ObjectReference config);
  public Boolean hasConfig();
  public BuildStatusFluent.ConfigNested<A> withNewConfig();
  public BuildStatusFluent.ConfigNested<A> withNewConfigLike(ObjectReference item);
  public BuildStatusFluent.ConfigNested<A> editConfig();
  public BuildStatusFluent.ConfigNested<A> editOrNewConfig();
  public BuildStatusFluent.ConfigNested<A> editOrNewConfigLike(ObjectReference item);
  public Long getDuration();
  public A withDuration(Long duration);
  public Boolean hasDuration();
  public String getLogSnippet();
  public A withLogSnippet(String logSnippet);
  public Boolean hasLogSnippet();
  public String getMessage();
  public A withMessage(String message);
  public Boolean hasMessage();
  
  /**
   * This method has been deprecated, please use method buildOutput instead.
   * @return The buildable object.
   */
  @Deprecated
  public BuildStatusOutput getOutput();
  public BuildStatusOutput buildOutput();
  public A withOutput(BuildStatusOutput output);
  public Boolean hasOutput();
  public BuildStatusFluent.OutputNested<A> withNewOutput();
  public BuildStatusFluent.OutputNested<A> withNewOutputLike(BuildStatusOutput item);
  public BuildStatusFluent.OutputNested<A> editOutput();
  public BuildStatusFluent.OutputNested<A> editOrNewOutput();
  public BuildStatusFluent.OutputNested<A> editOrNewOutputLike(BuildStatusOutput item);
  public String getOutputDockerImageReference();
  public A withOutputDockerImageReference(String outputDockerImageReference);
  public Boolean hasOutputDockerImageReference();
  public String getPhase();
  public A withPhase(String phase);
  public Boolean hasPhase();
  public String getReason();
  public A withReason(String reason);
  public Boolean hasReason();
  public A addToStages(int index,StageInfo item);
  public A setToStages(int index,StageInfo item);
  public A addToStages(io.fabric8.openshift.api.model.StageInfo... items);
  public A addAllToStages(Collection<StageInfo> items);
  public A removeFromStages(io.fabric8.openshift.api.model.StageInfo... items);
  public A removeAllFromStages(Collection<StageInfo> items);
  public A removeMatchingFromStages(Predicate<StageInfoBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildStages instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<StageInfo> getStages();
  public List<StageInfo> buildStages();
  public StageInfo buildStage(int index);
  public StageInfo buildFirstStage();
  public StageInfo buildLastStage();
  public StageInfo buildMatchingStage(Predicate<StageInfoBuilder> predicate);
  public Boolean hasMatchingStage(Predicate<StageInfoBuilder> predicate);
  public A withStages(List<StageInfo> stages);
  public A withStages(io.fabric8.openshift.api.model.StageInfo... stages);
  public Boolean hasStages();
  public BuildStatusFluent.StagesNested<A> addNewStage();
  public BuildStatusFluent.StagesNested<A> addNewStageLike(StageInfo item);
  public BuildStatusFluent.StagesNested<A> setNewStageLike(int index,StageInfo item);
  public BuildStatusFluent.StagesNested<A> editStage(int index);
  public BuildStatusFluent.StagesNested<A> editFirstStage();
  public BuildStatusFluent.StagesNested<A> editLastStage();
  public BuildStatusFluent.StagesNested<A> editMatchingStage(Predicate<StageInfoBuilder> predicate);
  public String getStartTimestamp();
  public A withStartTimestamp(String startTimestamp);
  public Boolean hasStartTimestamp();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withCancelled();
  public interface ConditionsNested<N> extends Nested<N>,BuildConditionFluent<BuildStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface ConfigNested<N> extends Nested<N>,ObjectReferenceFluent<BuildStatusFluent.ConfigNested<N>>{
    public N and();
    public N endConfig();
    
  }
  public interface OutputNested<N> extends Nested<N>,BuildStatusOutputFluent<BuildStatusFluent.OutputNested<N>>{
    public N and();
    public N endOutput();
    
  }
  public interface StagesNested<N> extends Nested<N>,StageInfoFluent<BuildStatusFluent.StagesNested<N>>{
    public N and();
    public N endStage();
    
  }
  
}