package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface DeploymentConfigSpecFluent<A extends DeploymentConfigSpecFluent<A>> extends Fluent<A>{
  public Integer getMinReadySeconds();
  public A withMinReadySeconds(Integer minReadySeconds);
  public Boolean hasMinReadySeconds();
  public Boolean getPaused();
  public A withPaused(Boolean paused);
  public Boolean hasPaused();
  public Integer getReplicas();
  public A withReplicas(Integer replicas);
  public Boolean hasReplicas();
  public Integer getRevisionHistoryLimit();
  public A withRevisionHistoryLimit(Integer revisionHistoryLimit);
  public Boolean hasRevisionHistoryLimit();
  public A addToSelector(String key,String value);
  public A addToSelector(Map<String,String> map);
  public A removeFromSelector(String key);
  public A removeFromSelector(Map<String,String> map);
  public Map<String,String> getSelector();
  public <K,V>A withSelector(Map<String,String> selector);
  public Boolean hasSelector();
  
  /**
   * This method has been deprecated, please use method buildStrategy instead.
   * @return The buildable object.
   */
  @Deprecated
  public DeploymentStrategy getStrategy();
  public DeploymentStrategy buildStrategy();
  public A withStrategy(DeploymentStrategy strategy);
  public Boolean hasStrategy();
  public DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategy();
  public DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategyLike(DeploymentStrategy item);
  public DeploymentConfigSpecFluent.StrategyNested<A> editStrategy();
  public DeploymentConfigSpecFluent.StrategyNested<A> editOrNewStrategy();
  public DeploymentConfigSpecFluent.StrategyNested<A> editOrNewStrategyLike(DeploymentStrategy item);
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodTemplateSpec getTemplate();
  public PodTemplateSpec buildTemplate();
  public A withTemplate(PodTemplateSpec template);
  public Boolean hasTemplate();
  public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplate();
  public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
  public DeploymentConfigSpecFluent.TemplateNested<A> editTemplate();
  public DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplate();
  public DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item);
  public Boolean getTest();
  public A withTest(Boolean test);
  public Boolean hasTest();
  public A addToTriggers(int index,DeploymentTriggerPolicy item);
  public A setToTriggers(int index,DeploymentTriggerPolicy item);
  public A addToTriggers(io.fabric8.openshift.api.model.DeploymentTriggerPolicy... items);
  public A addAllToTriggers(Collection<DeploymentTriggerPolicy> items);
  public A removeFromTriggers(io.fabric8.openshift.api.model.DeploymentTriggerPolicy... items);
  public A removeAllFromTriggers(Collection<DeploymentTriggerPolicy> items);
  public A removeMatchingFromTriggers(Predicate<DeploymentTriggerPolicyBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildTriggers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<DeploymentTriggerPolicy> getTriggers();
  public List<DeploymentTriggerPolicy> buildTriggers();
  public DeploymentTriggerPolicy buildTrigger(int index);
  public DeploymentTriggerPolicy buildFirstTrigger();
  public DeploymentTriggerPolicy buildLastTrigger();
  public DeploymentTriggerPolicy buildMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate);
  public Boolean hasMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate);
  public A withTriggers(List<DeploymentTriggerPolicy> triggers);
  public A withTriggers(io.fabric8.openshift.api.model.DeploymentTriggerPolicy... triggers);
  public Boolean hasTriggers();
  public DeploymentConfigSpecFluent.TriggersNested<A> addNewTrigger();
  public DeploymentConfigSpecFluent.TriggersNested<A> addNewTriggerLike(DeploymentTriggerPolicy item);
  public DeploymentConfigSpecFluent.TriggersNested<A> setNewTriggerLike(int index,DeploymentTriggerPolicy item);
  public DeploymentConfigSpecFluent.TriggersNested<A> editTrigger(int index);
  public DeploymentConfigSpecFluent.TriggersNested<A> editFirstTrigger();
  public DeploymentConfigSpecFluent.TriggersNested<A> editLastTrigger();
  public DeploymentConfigSpecFluent.TriggersNested<A> editMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withPaused();
  public A withTest();
  public interface StrategyNested<N> extends Nested<N>,DeploymentStrategyFluent<DeploymentConfigSpecFluent.StrategyNested<N>>{
    public N and();
    public N endStrategy();
    
  }
  public interface TemplateNested<N> extends Nested<N>,PodTemplateSpecFluent<DeploymentConfigSpecFluent.TemplateNested<N>>{
    public N and();
    public N endTemplate();
    
  }
  public interface TriggersNested<N> extends Nested<N>,DeploymentTriggerPolicyFluent<DeploymentConfigSpecFluent.TriggersNested<N>>{
    public N and();
    public N endTrigger();
    
  }
  
}