package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthAuthorizeTokenListBuilder extends OAuthAuthorizeTokenListFluentImpl<OAuthAuthorizeTokenListBuilder> implements VisitableBuilder<OAuthAuthorizeTokenList,OAuthAuthorizeTokenListBuilder>{
  public OAuthAuthorizeTokenListBuilder() {
    this(false);
  }
  public OAuthAuthorizeTokenListBuilder(Boolean validationEnabled) {
    this(new OAuthAuthorizeTokenList(), validationEnabled);
  }
  public OAuthAuthorizeTokenListBuilder(OAuthAuthorizeTokenListFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthAuthorizeTokenListBuilder(OAuthAuthorizeTokenListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OAuthAuthorizeTokenList(), validationEnabled);
  }
  public OAuthAuthorizeTokenListBuilder(OAuthAuthorizeTokenListFluent<?> fluent,OAuthAuthorizeTokenList instance) {
    this(fluent, instance, false);
  }
  public OAuthAuthorizeTokenListBuilder(OAuthAuthorizeTokenListFluent<?> fluent,OAuthAuthorizeTokenList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OAuthAuthorizeTokenListBuilder(OAuthAuthorizeTokenList instance) {
    this(instance,false);
  }
  public OAuthAuthorizeTokenListBuilder(OAuthAuthorizeTokenList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OAuthAuthorizeTokenListFluent<?> fluent;
  Boolean validationEnabled;
  public OAuthAuthorizeTokenList build() {
    OAuthAuthorizeTokenList buildable = new OAuthAuthorizeTokenList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}