package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DeploymentConfigSpecFluent<A extends DeploymentConfigSpecFluent<A>> extends BaseFluent<A>{
  public DeploymentConfigSpecFluent() {
  }
  public DeploymentConfigSpecFluent(DeploymentConfigSpec instance) {
    instance = (instance != null ? instance : new DeploymentConfigSpec());

    if (instance != null) {
      this.withMinReadySeconds(instance.getMinReadySeconds());
      this.withPaused(instance.getPaused());
      this.withReplicas(instance.getReplicas());
      this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      this.withSelector(instance.getSelector());
      this.withStrategy(instance.getStrategy());
      this.withTemplate(instance.getTemplate());
      this.withTest(instance.getTest());
      this.withTriggers(instance.getTriggers());
      this.withMinReadySeconds(instance.getMinReadySeconds());
      this.withPaused(instance.getPaused());
      this.withReplicas(instance.getReplicas());
      this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      this.withSelector(instance.getSelector());
      this.withStrategy(instance.getStrategy());
      this.withTemplate(instance.getTemplate());
      this.withTest(instance.getTest());
      this.withTriggers(instance.getTriggers());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Integer minReadySeconds;
  private Boolean paused;
  private Integer replicas;
  private Integer revisionHistoryLimit;
  private Map<String,String> selector;
  private DeploymentStrategyBuilder strategy;
  private PodTemplateSpecBuilder template;
  private Boolean test;
  private ArrayList<DeploymentTriggerPolicyBuilder> triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();
  private Map<String,Object> additionalProperties;
  public Integer getMinReadySeconds() {
    return this.minReadySeconds;
  }
  public A withMinReadySeconds(Integer minReadySeconds) {
    this.minReadySeconds=minReadySeconds; return (A) this;
  }
  public boolean hasMinReadySeconds() {
    return this.minReadySeconds != null;
  }
  public Boolean getPaused() {
    return this.paused;
  }
  public A withPaused(Boolean paused) {
    this.paused=paused; return (A) this;
  }
  public boolean hasPaused() {
    return this.paused != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  public Integer getRevisionHistoryLimit() {
    return this.revisionHistoryLimit;
  }
  public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
    this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
  }
  public boolean hasRevisionHistoryLimit() {
    return this.revisionHistoryLimit != null;
  }
  public A addToSelector(String key,String value) {
    if(this.selector == null && key != null && value != null) { this.selector = new LinkedHashMap(); }
    if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
  }
  public A addToSelector(Map<String,String> map) {
    if(this.selector == null && map != null) { this.selector = new LinkedHashMap(); }
    if(map != null) { this.selector.putAll(map);} return (A)this;
  }
  public A removeFromSelector(String key) {
    if(this.selector == null) { return (A) this; }
    if(key != null && this.selector != null) {this.selector.remove(key);} return (A)this;
  }
  public A removeFromSelector(Map<String,String> map) {
    if(this.selector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.selector != null){this.selector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getSelector() {
    return this.selector;
  }
  public <K,V>A withSelector(Map<String,String> selector) {
    if (selector == null) { this.selector =  null;} else {this.selector = new LinkedHashMap(selector);} return (A) this;
  }
  public boolean hasSelector() {
    return this.selector != null;
  }
  public DeploymentStrategy buildStrategy() {
    return this.strategy!=null ?this.strategy.build():null;
  }
  public A withStrategy(DeploymentStrategy strategy) {
    _visitables.get("strategy").remove(this.strategy);
    if (strategy!=null){ this.strategy= new DeploymentStrategyBuilder(strategy); _visitables.get("strategy").add(this.strategy);} else { this.strategy = null; _visitables.get("strategy").remove(this.strategy); } return (A) this;
  }
  public boolean hasStrategy() {
    return this.strategy != null;
  }
  public StrategyNested<A> withNewStrategy() {
    return new StrategyNested(null);
  }
  public StrategyNested<A> withNewStrategyLike(DeploymentStrategy item) {
    return new StrategyNested(item);
  }
  public StrategyNested<A> editStrategy() {
    return withNewStrategyLike(java.util.Optional.ofNullable(buildStrategy()).orElse(null));
  }
  public StrategyNested<A> editOrNewStrategy() {
    return withNewStrategyLike(java.util.Optional.ofNullable(buildStrategy()).orElse(new DeploymentStrategyBuilder().build()));
  }
  public StrategyNested<A> editOrNewStrategyLike(DeploymentStrategy item) {
    return withNewStrategyLike(java.util.Optional.ofNullable(buildStrategy()).orElse(item));
  }
  public PodTemplateSpec buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(PodTemplateSpec template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public boolean hasTemplate() {
    return this.template != null;
  }
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
    return new TemplateNested(item);
  }
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
  }
  public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  public Boolean getTest() {
    return this.test;
  }
  public A withTest(Boolean test) {
    this.test=test; return (A) this;
  }
  public boolean hasTest() {
    return this.test != null;
  }
  public A addToTriggers(int index,DeploymentTriggerPolicy item) {
    if (this.triggers == null) {this.triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();}
    DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
    if (index < 0 || index >= triggers.size()) { _visitables.get("triggers").add(builder); triggers.add(builder); } else { _visitables.get("triggers").add(index, builder); triggers.add(index, builder);}
    return (A)this;
  }
  public A setToTriggers(int index,DeploymentTriggerPolicy item) {
    if (this.triggers == null) {this.triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();}
    DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
    if (index < 0 || index >= triggers.size()) { _visitables.get("triggers").add(builder); triggers.add(builder); } else { _visitables.get("triggers").set(index, builder); triggers.set(index, builder);}
    return (A)this;
  }
  public A addToTriggers(io.fabric8.openshift.api.model.DeploymentTriggerPolicy... items) {
    if (this.triggers == null) {this.triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();}
    for (DeploymentTriggerPolicy item : items) {DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
  }
  public A addAllToTriggers(Collection<DeploymentTriggerPolicy> items) {
    if (this.triggers == null) {this.triggers = new ArrayList<DeploymentTriggerPolicyBuilder>();}
    for (DeploymentTriggerPolicy item : items) {DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
  }
  public A removeFromTriggers(io.fabric8.openshift.api.model.DeploymentTriggerPolicy... items) {
    if (this.triggers == null) return (A)this;
    for (DeploymentTriggerPolicy item : items) {DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);_visitables.get("triggers").remove(builder); this.triggers.remove(builder);} return (A)this;
  }
  public A removeAllFromTriggers(Collection<DeploymentTriggerPolicy> items) {
    if (this.triggers == null) return (A)this;
    for (DeploymentTriggerPolicy item : items) {DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);_visitables.get("triggers").remove(builder); this.triggers.remove(builder);} return (A)this;
  }
  public A removeMatchingFromTriggers(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
    if (triggers == null) return (A) this;
    final Iterator<DeploymentTriggerPolicyBuilder> each = triggers.iterator();
    final List visitables = _visitables.get("triggers");
    while (each.hasNext()) {
      DeploymentTriggerPolicyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<DeploymentTriggerPolicy> buildTriggers() {
    return triggers != null ? build(triggers) : null;
  }
  public DeploymentTriggerPolicy buildTrigger(int index) {
    return this.triggers.get(index).build();
  }
  public DeploymentTriggerPolicy buildFirstTrigger() {
    return this.triggers.get(0).build();
  }
  public DeploymentTriggerPolicy buildLastTrigger() {
    return this.triggers.get(triggers.size() - 1).build();
  }
  public DeploymentTriggerPolicy buildMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
    for (DeploymentTriggerPolicyBuilder item: triggers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
    for (DeploymentTriggerPolicyBuilder item: triggers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTriggers(List<DeploymentTriggerPolicy> triggers) {
    if (this.triggers != null) { _visitables.get("triggers").clear();}
    if (triggers != null) {this.triggers = new ArrayList(); for (DeploymentTriggerPolicy item : triggers){this.addToTriggers(item);}} else { this.triggers = null;} return (A) this;
  }
  public A withTriggers(io.fabric8.openshift.api.model.DeploymentTriggerPolicy... triggers) {
    if (this.triggers != null) {this.triggers.clear(); _visitables.remove("triggers"); }
    if (triggers != null) {for (DeploymentTriggerPolicy item :triggers){ this.addToTriggers(item);}} return (A) this;
  }
  public boolean hasTriggers() {
    return triggers != null && !triggers.isEmpty();
  }
  public TriggersNested<A> addNewTrigger() {
    return new TriggersNested(-1, null);
  }
  public TriggersNested<A> addNewTriggerLike(DeploymentTriggerPolicy item) {
    return new TriggersNested(-1, item);
  }
  public TriggersNested<A> setNewTriggerLike(int index,DeploymentTriggerPolicy item) {
    return new TriggersNested(index, item);
  }
  public TriggersNested<A> editTrigger(int index) {
    if (triggers.size() <= index) throw new RuntimeException("Can't edit triggers. Index exceeds size.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public TriggersNested<A> editFirstTrigger() {
    if (triggers.size() == 0) throw new RuntimeException("Can't edit first triggers. The list is empty.");
    return setNewTriggerLike(0, buildTrigger(0));
  }
  public TriggersNested<A> editLastTrigger() {
    int index = triggers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last triggers. The list is empty.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public TriggersNested<A> editMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<triggers.size();i++) { 
    if (predicate.test(triggers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching triggers. No match found.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeploymentConfigSpecFluent that = (DeploymentConfigSpecFluent) o;
    if (!java.util.Objects.equals(minReadySeconds, that.minReadySeconds)) return false;

    if (!java.util.Objects.equals(paused, that.paused)) return false;

    if (!java.util.Objects.equals(replicas, that.replicas)) return false;

    if (!java.util.Objects.equals(revisionHistoryLimit, that.revisionHistoryLimit)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (!java.util.Objects.equals(strategy, that.strategy)) return false;

    if (!java.util.Objects.equals(template, that.template)) return false;

    if (!java.util.Objects.equals(test, that.test)) return false;

    if (!java.util.Objects.equals(triggers, that.triggers)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(minReadySeconds,  paused,  replicas,  revisionHistoryLimit,  selector,  strategy,  template,  test,  triggers,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (minReadySeconds != null) { sb.append("minReadySeconds:"); sb.append(minReadySeconds + ","); }
    if (paused != null) { sb.append("paused:"); sb.append(paused + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (revisionHistoryLimit != null) { sb.append("revisionHistoryLimit:"); sb.append(revisionHistoryLimit + ","); }
    if (selector != null && !selector.isEmpty()) { sb.append("selector:"); sb.append(selector + ","); }
    if (strategy != null) { sb.append("strategy:"); sb.append(strategy + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (test != null) { sb.append("test:"); sb.append(test + ","); }
    if (triggers != null && !triggers.isEmpty()) { sb.append("triggers:"); sb.append(triggers + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withPaused() {
    return withPaused(true);
  }
  public A withTest() {
    return withTest(true);
  }
  public class StrategyNested<N> extends DeploymentStrategyFluent<StrategyNested<N>> implements Nested<N>{
    StrategyNested(DeploymentStrategy item) {
      this.builder = new DeploymentStrategyBuilder(this, item);
    }
    DeploymentStrategyBuilder builder;
    public N and() {
      return (N) DeploymentConfigSpecFluent.this.withStrategy(builder.build());
    }
    public N endStrategy() {
      return and();
    }
    
  }
  public class TemplateNested<N> extends PodTemplateSpecFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) DeploymentConfigSpecFluent.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  public class TriggersNested<N> extends DeploymentTriggerPolicyFluent<TriggersNested<N>> implements Nested<N>{
    TriggersNested(int index,DeploymentTriggerPolicy item) {
      this.index = index;
      this.builder = new DeploymentTriggerPolicyBuilder(this, item);
    }
    DeploymentTriggerPolicyBuilder builder;
    int index;
    public N and() {
      return (N) DeploymentConfigSpecFluent.this.setToTriggers(index,builder.build());
    }
    public N endTrigger() {
      return and();
    }
    
  }
  
}