package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EgressNetworkPolicyBuilder extends EgressNetworkPolicyFluent<EgressNetworkPolicyBuilder> implements VisitableBuilder<EgressNetworkPolicy,EgressNetworkPolicyBuilder>{
  public EgressNetworkPolicyBuilder() {
    this(false);
  }
  public EgressNetworkPolicyBuilder(Boolean validationEnabled) {
    this(new EgressNetworkPolicy(), validationEnabled);
  }
  public EgressNetworkPolicyBuilder(EgressNetworkPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public EgressNetworkPolicyBuilder(EgressNetworkPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EgressNetworkPolicy(), validationEnabled);
  }
  public EgressNetworkPolicyBuilder(EgressNetworkPolicyFluent<?> fluent,EgressNetworkPolicy instance) {
    this(fluent, instance, false);
  }
  public EgressNetworkPolicyBuilder(EgressNetworkPolicyFluent<?> fluent,EgressNetworkPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EgressNetworkPolicy());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EgressNetworkPolicyBuilder(EgressNetworkPolicy instance) {
    this(instance,false);
  }
  public EgressNetworkPolicyBuilder(EgressNetworkPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EgressNetworkPolicy());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EgressNetworkPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public EgressNetworkPolicy build() {
    EgressNetworkPolicy buildable = new EgressNetworkPolicy(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}