package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitLabWebHookCauseBuilder extends GitLabWebHookCauseFluent<GitLabWebHookCauseBuilder> implements VisitableBuilder<GitLabWebHookCause,GitLabWebHookCauseBuilder>{
  public GitLabWebHookCauseBuilder() {
    this(false);
  }
  public GitLabWebHookCauseBuilder(Boolean validationEnabled) {
    this(new GitLabWebHookCause(), validationEnabled);
  }
  public GitLabWebHookCauseBuilder(GitLabWebHookCauseFluent<?> fluent) {
    this(fluent, false);
  }
  public GitLabWebHookCauseBuilder(GitLabWebHookCauseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitLabWebHookCause(), validationEnabled);
  }
  public GitLabWebHookCauseBuilder(GitLabWebHookCauseFluent<?> fluent,GitLabWebHookCause instance) {
    this(fluent, instance, false);
  }
  public GitLabWebHookCauseBuilder(GitLabWebHookCauseFluent<?> fluent,GitLabWebHookCause instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GitLabWebHookCause());

    if (instance != null) {
      fluent.withRevision(instance.getRevision());
      fluent.withSecret(instance.getSecret());
      fluent.withRevision(instance.getRevision());
      fluent.withSecret(instance.getSecret());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitLabWebHookCauseBuilder(GitLabWebHookCause instance) {
    this(instance,false);
  }
  public GitLabWebHookCauseBuilder(GitLabWebHookCause instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GitLabWebHookCause());

    if (instance != null) {
      this.withRevision(instance.getRevision());
      this.withSecret(instance.getSecret());
      this.withRevision(instance.getRevision());
      this.withSecret(instance.getSecret());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitLabWebHookCauseFluent<?> fluent;
  Boolean validationEnabled;
  public GitLabWebHookCause build() {
    GitLabWebHookCause buildable = new GitLabWebHookCause(fluent.buildRevision(),fluent.getSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}